//			Copyright (c) 1998 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/cxxutl/port.hxx#1 $
//

// Header file for C++ portability definitions.

//----------------------------------------------------------------------

#ifndef CXXUTIL_PORT_HXX
#define CXXUTIL_PORT_HXX

/* 64-bit porting. Introduction of new xp_long data type in CXX files. */
#include <avs/port.h>

//----------------------------------------------------------------------

#if defined(__alpha) && defined(__osf__)
#ifndef alpha_osf
#define alpha_osf
#endif
#endif

#ifdef _AIX
// __unix is predefined on all our Unix platforms except AIX
#ifndef __unix
#define __unix
#endif
#endif


//----------------------------------------------------------------------

#ifdef __hpux             // HP-UX
// No longer supporting the obsolete cfront-based compiler
#define CXX_HP_ANSI
#define CXX_TYPENAME
#endif	// HP

#ifdef __xlC__       // IBM AIX
#define CXX_TEMPLATES_INCLUDE_CXX_FILE
// Version 5 is ANSI
#define CXX_TYPENAME
#endif	// IBM AIX

#ifdef __SUNPRO_CC       // Solaris, Sun WorkShop Compiler
#define CXX_TEMPLATES_INCLUDE_CXX_FILE
#if __SUNPRO_CC < 0x0500 || !defined( _BOOL )
typedef unsigned char bool;
#endif
// WorkShop/Forte/whatever 6, update 2.  Perhaps earlier also.
#if __SUNPRO_CC >= 0x0530
#define CXX_TYPENAME
#endif
#endif	// Solaris

#ifdef __DECCXX             // HP/Compaq/Digital UNIX
#define CXX_TEMPLATES_INCLUDE_CXX_FILE
#define CXX_TEMPLATES_EXPLICIT
#define CXX_TYPENAME
#endif

#if defined(__sgi) && defined(__mips)  // IRIX 6 on MIPS
// n32 or n64 ABI
#if _COMPILER_VERSION >= 730
#define CXX_TYPENAME
#endif
#endif	// SGI

#if defined(__GNUG__)   // GCC/G++
#define CXX_TEMPLATES_INCLUDE_CXX_FILE
// I think gcc 2 can handle this as well, but we only
// get warnings in gcc 3.
#if __GNUC__ >= 3
#define CXX_TYPENAME
#endif
#endif

#if defined(_MSC_VER) || defined(__INTEL_COMPILER)
#define CXX_TEMPLATES_INCLUDE_CXX_FILE
#define CXX_TYPENAME
#endif

#endif
