//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/cxxutl/ptrattr.cxx#1 $
//

// ptrattr.cxx - Source file for UtPtrAttr and subclasses

#ifndef CXXUTIL_PTRATTR_CXX
#define CXXUTIL_PTRATTR_CXX

//----------------------------------------------------------------------

#ifndef CXXUTIL_ATTRMGR_HXX
#include "attrmgr.hxx"
#endif

#ifndef CXXUTIL_PTRATTR_HXX
#include "ptrattr.hxx"
#endif

//----------------------------------------------------------------------
template <class TYPE>
UtPtrAttr<TYPE>::UtPtrAttr(
    const char *name)
    : UtBaseAttr(name), _value(0)
//----------------------------------------------------------------------
{}

//----------------------------------------------------------------------
template <class TYPE>
UtPtrAttr<TYPE>::~UtPtrAttr()
//----------------------------------------------------------------------
{
    // Release memory in destructor
    if (_value) delete _value;
}

//----------------------------------------------------------------------
template <class TYPE>
UtBaseAttr*
UtPtrAttr<TYPE>::setState(
    UtAttrState s)
//----------------------------------------------------------------------
{
    // If we are unsetting then we might as well release _value
    if (s & UtATTR_UNSET) {
        if (_value) {
            delete _value;
            _value = 0;
        }
    }
    UtBaseAttr::setState(s);
    return this;
}

//----------------------------------------------------------------------
// Init attribute to the default values
//----------------------------------------------------------------------
template <class TYPE>
void
UtPtrAttr<TYPE>::init()
//----------------------------------------------------------------------
{
    _state = UtATTR_INIT;
    if (!_value) {
        _value = new TYPE;
    }
    _init();
}

//----------------------------------------------------------------------
template <class TYPE>
void
UtPtrAttr<TYPE>::set(
    const TYPE &value)
//----------------------------------------------------------------------
{
    if (!_value) _value = new TYPE;
    *_value = value;
    setState(UtATTR_USER_SET);
    // validate value and set to UtATTR_UNSET if value is illegal
    _validate();
}

//----------------------------------------------------------------------
template <class TYPE>
void
UtArrAttr<TYPE>::set(
    const UtArray<TYPE> &value)
//----------------------------------------------------------------------
{
    UtPtrAttr< UtArray<TYPE> >::set(value);
}

//----------------------------------------------------------------------
/* 64-bit porting. Directly Modified */
template <class TYPE>
void
UtArrAttr<TYPE>::set(
    TYPE *array,
    xp_long size)
//----------------------------------------------------------------------
{
    if (!this->_value) {
        this->_value = new UtArray<TYPE>(array, size);
    } else {
        this->_value->set(array, size);
    }
    this->setState(UtATTR_USER_SET);
    // validate value and set to UtATTR_UNSET if value is illegal
    this->_validate();
}

//----------------------------------------------------------------------
template <class TYPE>
UtArrAttr<TYPE>::UtArrAttr(
    const char *name)
    : UtPtrAttr< UtArray<TYPE> >(name)
//----------------------------------------------------------------------
{}

#endif
