//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/cxxutl/ptrattr.hxx#1 $
//

// ptrattr.hxx - Header file for UtPtrArr and UtArrAttr classes

//----------------------------------------------------------------------
#ifndef CXXUTIL_PTRATTR_HXX
#define CXXUTIL_PTRATTR_HXX

#ifndef CXXUTIL_BASEATTR_HXX
#include "baseattr.hxx"
#endif

#ifndef CXXUTIL_ARRAY_HXX
#include "array.hxx"
#endif

//----------------------------------------------------------------------
// Protected base class for each specific attribute type
// The UtPtrAttr is for attributes which are using much memory like
// arrays or classes
//----------------------------------------------------------------------
template<class TYPE>
class UtPtrAttr : public UtBaseAttr
//----------------------------------------------------------------------
{
  public:
    UtPtrAttr(const char *name);
    ~UtPtrAttr();

    TYPE &get() {return *_value;}
    void set(const TYPE &value);
    virtual UtBaseAttr *setState(UtAttrState s);

    // Init attribute to the default values
    virtual void init();

  protected:
    TYPE *_value;

    private:

    // Private copy and assignment functions to make copying illegal
    // At a later state these should be turned into to public
    // functions doing the "right" thing
    UtPtrAttr(const UtPtrAttr<TYPE>&) : UtBaseAttr("") {}
    UtPtrAttr<TYPE> &operator= (const UtPtrAttr<TYPE>&) {
        return *this;
    }
};

//----------------------------------------------------------------------
template<class TYPE>
class UtArrAttr : public UtPtrAttr< UtArray<TYPE> >
//----------------------------------------------------------------------
{
  public:
    void set(const UtArray<TYPE> &value);
    void set(TYPE *array, xp_long size);
  protected:
    UtArrAttr(const char *name);
};


// This is neccesary for "modern" template instantiation techniques
#ifdef CXX_TEMPLATES_INCLUDE_CXX_FILE
#include "ptrattr.cxx"
#endif

#endif

