//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/cxxutl/ptrsarr.cxx#1 $
//

// ptrsarr.cxx - Source file for UtPtrSortedArray

#ifndef CXXUTIL_PTRSARR_CXX
#define CXXUTIL_PTRSARR_CXX

//----------------------------------------------------------------------
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <avs/port.h>

#ifndef CXXUTIL_PTRSARR_HXX
#include "ptrsarr.hxx"
#endif

//----------------------------------------------------------------------
template <class TYPE>
UtPtrSortedArray<TYPE>::UtPtrSortedArray(int doDelete)
    : _doDelete(doDelete), _isSorted(1)
//----------------------------------------------------------------------
{}

//----------------------------------------------------------------------
// Destructor check for delete of elements
//----------------------------------------------------------------------
/* 64-bit porting. Only Modified Internally */
template <class TYPE>
UtPtrSortedArray<TYPE>::~UtPtrSortedArray()
//----------------------------------------------------------------------
{
    if (_doDelete) {
        for (xp_long i=0; i<_ptrArray.size(); i++) {
            delete _ptrArray[i];
        }
    }
}

//----------------------------------------------------------------------
template <class TYPE>
void
UtPtrSortedArray<TYPE>::add(
    TYPE *element)
//----------------------------------------------------------------------
{
    _ptrArray[_ptrArray.size()] = element;
    _isSorted=0;
}

//----------------------------------------------------------------------
// Remove given element
// If not found then do nothing
//----------------------------------------------------------------------
/* 64-bit porting. Only Modified Internally */
template <class TYPE>
void
UtPtrSortedArray<TYPE>::remove(
    TYPE *element)
//----------------------------------------------------------------------
{
    void *base = _ptrArray.data();
    xp_long  size = _ptrArray.size();

    // If empty array then just return
    if (size > 0) {
        // Special case only one element to check against
        if (size == 1) {
            if (element->compare(_ptrArray[0]) == 0) {
                _ptrArray.resize(0);
            }
        }
        // more than one element
        else {
            _sort();
            void *found = bsearch((char*)(&element), (char*)base, (size_t)size,
                sizeof(void*), _compare);
            if (found) {
                // memove handles overlapping memory pieces
                MEMMOVE(found, (char *)found+1,
                    (char *)base+(size-1)-(char *)found);
                // Be sure array knows we removed one
                _ptrArray.resize(size-1);
            }
        }
    }
}

//----------------------------------------------------------------------
// Find index for given element
// If not found then return -1
//----------------------------------------------------------------------
/* 64-bit porting. Directly Modified */
template <class TYPE>
xp_long
UtPtrSortedArray<TYPE>::findIndex(
    TYPE *element)
//----------------------------------------------------------------------
{
    xp_long returnValue = -1;
    void *base = _ptrArray.data();
    xp_long  size = _ptrArray.size();

    // If empty array then just return
    if (size > 0) {
        // Special case only one element to check against
        if (size == 1) {
            if (element->compare(_ptrArray[0]) == 0) {
                returnValue=0;
            }
        }
        // more than one element
        else {
            _sort();
            void *found = bsearch((char*)(&element), (char*)base, (size_t)size,
                sizeof(void*), _compare);
            if (found) {
                // cast the addresses properly, but assume
                // the net size can be held in a signed int
                returnValue =
                    (xp_long)(((unsigned long)(found)-(unsigned long)(base))/
                        sizeof(void*));
            }
        }
    }

    return returnValue;
}

//----------------------------------------------------------------------
// Find given element
// If not found then return 0
//----------------------------------------------------------------------
/* 64-bit porting. Only Modified Internally */
template <class TYPE>
TYPE*
UtPtrSortedArray<TYPE>::find(
    TYPE *element)
//----------------------------------------------------------------------
{
    TYPE *returnValue = 0;
    const xp_long index = findIndex(element);
    if (index >= 0) returnValue = (TYPE*)_ptrArray[index];
    return returnValue;
}

//----------------------------------------------------------------------
// Remove all elements from UtPtrSortedArray
//----------------------------------------------------------------------
/* 64-bit porting. Only Modified Internally */
template <class TYPE>
void
UtPtrSortedArray<TYPE>::clear(
    int doDelete)
//----------------------------------------------------------------------
{
    if (doDelete) {
        for (xp_long i=0; i<_ptrArray.size(); i++) {
            delete _ptrArray[i];
        }
    }
    _ptrArray.clear();
    _isSorted=1;
}

//----------------------------------------------------------------------
/* 64-bit porting. Only Modified Internally */
template <class TYPE>
void
UtPtrSortedArray<TYPE>::_sort()
//----------------------------------------------------------------------
{
    if (!_isSorted) {
        xp_long size = _ptrArray.size();
        if (size > 1) {
            qsort(_ptrArray.data(), _ptrArray.size(),
                  sizeof(void*), _compare);
        }
        _isSorted=1;
    }
}

#endif
