//			Copyright (c) 1993 by
//			Advanced Visual Systems Inc.
//			All Rights Reserved
//
//	This software comprises unpublished confidential information of
//	Advanced Visual Systems Inc. and may not be used, copied or made
//	available to anyone, except in accordance with the license
//	under which it is furnished.
//
//	This file is under Perforce control
//	$Id: //depot/express/fcs70/include/avs/cxxutl/ptrsarr.hxx#1 $
//

// ptrsarr.hxx - Header file for UtPtrSortedArray

//----------------------------------------------------------------------

#ifndef CXXUTIL_PTRSARR_HXX
#define CXXUTIL_PTRSARR_HXX

//----------------------------------------------------------------------
#ifndef CXXUTIL_ARRAY_HXX
#include "array.hxx"
#endif

//----------------------------------------------------------------------
// Double pointed list of any type
//----------------------------------------------------------------------
template <class TYPE>
class UtPtrSortedArray
//----------------------------------------------------------------------
{
  public:
    UtPtrSortedArray(int doDelete);
    virtual ~UtPtrSortedArray();

    // Add one element to the array
    void add(TYPE *element);

    // Search list for given element and remove first (if any) which is found
    void remove(TYPE *element);

    // Search list for given element and return if found.
    // Return 0 if not found
    TYPE *find(TYPE *element);

    // Search list for given element and return index
    // Return -1 if not found
    xp_long findIndex(TYPE *element);

    // Remove all elements from UtPtrSortedArray
    void clear(int doDelete);

    // Index function to return object at given index
    TYPE *&operator[](int index) {
        _sort();
        return *(&_ptrArray[index]);
    }

    // Return size
    xp_long size() const {
        return _ptrArray.size();
    }

    int isEmpty() const {
        return (_ptrArray.size() == 0);
    }

  protected:

    void _sort();
    static int _compare(const void *elem1, const void *elem2) {
        return (*(TYPE**)elem1)->compare(*(TYPE**)elem2);
    }

    UtArray<TYPE*> _ptrArray;
    int _doDelete;
    int _isSorted;

};

// This is neccesary for "modern" template instantiation techniques
#ifdef CXX_TEMPLATES_INCLUDE_CXX_FILE
#include "ptrsarr.cxx"
#endif

#endif
