/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/dtype.h#1 $
*/
#ifndef DTYPE_INCLUDED
#define DTYPE_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

#define DTYPE_CHAR	 0 	/* used in strings       (i.e. ascii)      */
#define DTYPE_BYTE	 1	/* used in byte arrays (i.e. 8 bit values)  */
#define DTYPE_SHORT      2
#define DTYPE_INT	 3
#define DTYPE_FLOAT      4
#define DTYPE_DOUBLE     5
#define DTYPE_LONG       6
#define DTYPE_PTR        7 /* this type can't be used in rd/wr ops */
#define DTYPE_STRING     8 /* not supported by rd/wr ops either    */
#define DTYPE_GROUP      9  /* not supported by rd/wr ops either    */
#define DTYPE_ARRAY      10 /* not supported by rd/wr ops either    */
#define DTYPE_LIST       11 /* not supported by rd/wr ops either    */
#define DNTYPES	         12
#define DTYPE_UNSET	 DNTYPES+1

/*
 * This macro handles the case where CHAR == BYTE from a type conversion
 * perspective.
 */
#define DTYPES_ARE_EQUAL(A,B)	((A) == (B) || (A) + (B) == 1)

#ifdef DTYPE_DECLARE
#define DTYPE_EXTERN
#else
#ifdef XP_INTERNAL_GLOBALS
#define DTYPE_EXTERN extern
#else
#define DTYPE_EXTERN DLL_IMPORT
#endif
#endif

DTYPE_EXTERN int DTYPEtype_size[DNTYPES];
DTYPE_EXTERN int DTYPEtype_align[DNTYPES];
DTYPE_EXTERN int DTYPEtype_precedence[DTYPE_UNSET+1]; /* 64-bit porting */

#ifndef DTYPE_DECLARE
DTYPE_EXTERN const char *DTYPEtype_str[DTYPE_UNSET+1];
#else
const char *DTYPEtype_str[] = {
   "CHAR",
   "BYTE",
   "SHORT",
   "INT",
   "FLOAT",
   "DOUBLE",
   "LONG",
   "PTR",
   "STRING",
   "GROUP",
   "ARRAY",
   "LIST",
   "ERROR",
   "UNSET",
};
#endif

/* Defined in tool/dtype.c */
int	DTYPEstr_to_type_id (const char *);
const char * DTYPEtype_id_to_str (int);

int 	DTYPEcvt_copy_array (
            unsigned char * dst, int dst_type,
            const unsigned char * src, int src_type,
            size_t n);

int	DTYPEcvt_copy_array_list (
            unsigned char * dst, int dst_type,
            const unsigned char * src, int src_type,
            size_t num_elems, xp_long * list);

int	DTYPEcvt_copy_array_2d (
            unsigned char *dst, int dst_type,
            const unsigned char *src, int src_type,
            xp_long *dims, xp_long *min_rng, xp_long *max_rng, xp_long offset);

int	DTYPEcvt_copy_array_2d_rev (
            const unsigned char *src, int dst_type,
            unsigned char *dst, int src_type,
            xp_long *dims, xp_long *min_rng, xp_long *max_rng, xp_long offset);

int	DTYPEcvt_copy_array_3d (
            unsigned char *dst, int dst_type,
            const unsigned char *src, int src_type,
            xp_long *dims, xp_long *min_rng, xp_long *max_rng, xp_long offset);

int	DTYPEcvt_copy_array_3d_rev (
            const unsigned char *src, int dst_type,
            unsigned char *dst, int src_type,
            xp_long *dims, xp_long *min_rng, xp_long *max_rng, xp_long offset);

#ifdef WORDLENGTH_64

int	DTYPEcvt_copy_array_list_n (
            unsigned char * dst, int dst_type,
            const unsigned char * src, int src_type,
            size_t num_elems, int * list);

int	DTYPEcvt_copy_array_2d_n (
            unsigned char *dst, int dst_type,
            const unsigned char *src, int src_type,
            int *dims, int *min_rng, int *max_rng, int offset);

int	DTYPEcvt_copy_array_2d_rev_n (
            const unsigned char *src, int dst_type,
            unsigned char *dst, int src_type,
            int *dims, int *min_rng, int *max_rng, int offset);

int	DTYPEcvt_copy_array_3d_n (
            unsigned char *dst, int dst_type,
            const unsigned char *src, int src_type,
            int *dims, int *min_rng, int *max_rng, int offset);

int	DTYPEcvt_copy_array_3d_rev_n (
            const unsigned char *src, int dst_type,
            unsigned char *dst, int src_type,
            int *dims, int *min_rng, int *max_rng, int offset);
#endif

#if defined(WORDLENGTH_64) && !defined(XP_WIDE_API)
	#define   DTYPEcvt_copy_array_list      DTYPEcvt_copy_array_list_n
	#define   DTYPEcvt_copy_array_2d        DTYPEcvt_copy_array_2d_n
	#define   DTYPEcvt_copy_array_2d_rev    DTYPEcvt_copy_array_2d_rev_n
	#define   DTYPEcvt_copy_array_3d        DTYPEcvt_copy_array_3d_n
	#define   DTYPEcvt_copy_array_3d_rev    DTYPEcvt_copy_array_3d_rev_n
#endif

#ifdef __cplusplus
} /* End of extern "C" */
#endif

#endif
