/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/dv_util.h#1 $
*/

#ifdef __cplusplus
extern "C" {
#endif

/* blk_tbl.c */
int UTILinterp_init (char *field_table, char **block_table);
int UTILinterp_init_struct (char *field_table, char **block_table);
int UTILinterp_init_unif (char *field_table, char **block_table);
int UTILinterp_init_rect (char *field_table, char **block_table);

/* cell.c */
int UTILcell_to_node (char *field_table, int set, int dtype,
                      char *cell_data, int veclen, int null_flag,
                      char *null_value, int order, char *node_data,
                      char **ptr, char **ptr_null);

/* cell2ord.c */
int UTILcopy_mesh_info (char *fld_tbl, char **fld_tbl1);
int UTILreplace_cell_set (char *fld_tbl, int set, xp_long ncells, xp_long *node_list, int cell_nnodes);
int UTILtesselate_line_2 (xp_long ncells, xp_long *node_list, xp_long *out_ncells, xp_long **out_node_list, int *cell_nnodes);
int UTILtesselate_tri_2 (xp_long ncells, xp_long *node_list, xp_long *out_ncells, xp_long **out_node_list, int *cell_nnodes);
int UTILtesselate_quad_2 (xp_long ncells, xp_long *node_list, xp_long *out_ncells, xp_long **out_node_list, int *cell_nnodes);
int UTILtesselate_tet_2 (xp_long ncells, xp_long *node_list, xp_long *out_ncells, xp_long **out_node_list, int *cell_nnodes);
int UTILtesselate_pyr_2 (xp_long ncells, xp_long *node_list, xp_long *out_ncells, xp_long **out_node_list, int *cell_nnodes);
int UTILtesselate_prism_2 (xp_long ncells, xp_long *node_list, xp_long *out_ncells, xp_long **out_node_list, int *cell_nnodes);
int UTILtesselate_hex_2 (xp_long ncells, xp_long *node_list, xp_long *out_ncells, xp_long **out_node_list, int *cell_nnodes);

/* cell_fnd.c */
int UTILfind_cell (char *field_table, char *block_table, float *point, xp_long *cell, float *uvw);
int UTILfind_cell_unif (char *field_table, char *block_table, float *point, xp_long *cell, float *uvw);
int UTILfind_cell_rect (char *field_table, char *block_table, float *point, xp_long *cell, float *uvw);
int UTILget_cell_id (char *field_table, xp_long cell, xp_long *cell_id, int *set);
int UTILcell_extent (char *field_table, xp_long cell, float *min_ext, float *max_ext);
int UTILcell_extent_struct (char *field_table, xp_long cell, float *min_ext, float *max_ext);
int UTILcell_extent_unif (char *field_table, xp_long cell, float *min_ext, float *max_ext);
int UTILcell_extent_rect (char *field_table, xp_long cell, float *min_ext, float *max_ext);

/* con_stct.c */
int UTILcontour_struct (char *field_table, char *node_data, int dtype, int null_flag, char *null_value,
			       double iso_val1, double iso_val2, xp_long *old_nnodes, xp_long **old_nlist, xp_long *new_nnodes,
			       xp_long **min_nodes, xp_long **max_nodes, char **list, xp_long *out_ncells, xp_long **out_conn_list,
			       xp_long *conn_size, int nspace, float **xyz,
			       xp_long *nline1, xp_long **line_conn1, xp_long *nline2, xp_long **line_conn2);

/* contr.c */
int UTILcontour (char *field_table, char *node_data, int data_type, int null_data_flag,
			char *null_data_value, double level1, double level2, xp_long *old_nnodes, xp_long **node_ind,
			xp_long *new_nnodes, xp_long **min_nodes, xp_long **max_nodes, char **list, xp_long *out_ncells,
			xp_long **out_conn_list, xp_long *conn_size, int nspace, float **xyz,
			       xp_long *nline1, xp_long **line_conn1, xp_long *nline2, xp_long **line_conn2);
int UTILcontour_cells (char *cell_table, char *node_data, int data_type,
			      int null_data_flag, char *null_data_value, double level1, double level2, xp_long *old_nnodes,
			      xp_long **node_ind, xp_long *new_nnodes, xp_long **min_nodes, xp_long **max_nodes, char **list, xp_long *out_ncells,
			      xp_long **out_conn_list, xp_long *conn_size, int nspace, float **xyz,
                              xp_long *nline1, xp_long **line_conn1, xp_long *nline2, xp_long **line_conn2);
int UTILcontour_hex (char *cell_table, int set, int dtype, char *node_data, int null_flag, char *null_value, double iso_val1, double iso_val2, xp_long old_nnodes, xp_long *node_ind, char *edge_table, xp_long *out_ncells, xp_long **nlist, xp_long *nloc, xp_long *nsize, xp_long *nline1, xp_long **line_conn1, xp_long *nline2, xp_long **line_conn2);
int UTILcontour_prism (char *cell_table, int set, int dtype, char *node_data, int null_flag, char *null_value, double iso_val1, double iso_val2, xp_long old_nnodes, xp_long *node_ind, char *edge_table, xp_long *out_ncells, xp_long **nlist, xp_long *nloc, xp_long *nsize, xp_long *nline1, xp_long **line_conn1, xp_long *nline2, xp_long **line_conn2);
int UTILcontour_pyr (char *cell_table, int set, int dtype, char *node_data, int null_flag, char *null_value, double iso_val1, double iso_val2, xp_long old_nnodes, xp_long *node_ind, char *edge_table, xp_long *out_ncells, xp_long **nlist, xp_long *nloc, xp_long *nsize, xp_long *nline1, xp_long **line_conn1, xp_long*nline2, xp_long **line_conn2);
int UTILcontour_tet (char *cell_table, int set, int dtype, char *node_data, int null_flag, char *null_value, double iso_val1, double iso_val2, xp_long old_nnodes, xp_long *node_ind, char *edge_table, xp_long *out_ncells, xp_long **nlist, xp_long *nloc, xp_long *nsize, xp_long *nline1, xp_long **line_conn1, xp_long *nline2, xp_long **line_conn2);
int UTILcontour_quad (char *cell_table, int set, int dtype, char *node_data, int null_flag, char *null_value, double iso_val1, double iso_val2, xp_long old_nnodes, xp_long *node_ind, char *edge_table, xp_long *out_ncells, xp_long **nlist, xp_long *nloc, xp_long *nsize, xp_long *nline1, xp_long **line_conn1, xp_long *nline2, xp_long **line_conn2);
int UTILcontour_tri (char *cell_table, int set, int dtype, char *node_data, int null_flag, char *null_value, double iso_val1, double iso_val2, xp_long old_nnodes, xp_long *node_ind, char *edge_table, xp_long *out_ncells, xp_long **nlist, xp_long *nloc, xp_long *nsize, xp_long *nline1, xp_long **line_conn1, xp_long *nline2, xp_long **line_conn2);
xp_long UTILnode_thresh2 (xp_long nnodes, int data_type, char *node_data, int null_flag, char *null_value,
			     double level1, double level2, xp_long *node_ind);
int UTILeval_contour (xp_long n, xp_long nnodes, xp_long nstart, int dtype, char *node_data, double level1, double level2, xp_long *min_node_list, xp_long *max_node_list, char *list, int veclen, int in_type, int null_flag, char *null_value, xp_long offset, char *in_data, char *out_data);

/* cut_fnc.c */
int UTILcut (char *field_table, char *node_data, int data_type, int null_data_flag, char *null_data_value,
		    double level, int dir, xp_long *old_nnodes, xp_long **node_ind,
		    xp_long *new_nnodes, xp_long **min_nodes, xp_long **max_nodes, xp_long *out_ncells, xp_long **out_conn_list, xp_long *conn_size, xp_long *ncell, xp_long **cell_ind);
int UTILcut_cells (char *cell_table, char *node_data, int data_type, int null_data_flag, char *null_data_value,
			  double level, int dir, xp_long *old_nnodes, xp_long **node_ind, xp_long *new_nnodes,
			  xp_long **min_nodes, xp_long **max_nodes, xp_long *out_ncells, xp_long **out_conn_list, xp_long *conn_size, xp_long *ncell, xp_long **cell_ind);
int UTILcut_hex (char *cell_table, int set, int null_flag, unsigned char * flags, int dir, xp_long old_nnodes, xp_long *node_ind, char *edge_table, xp_long *out_ncells, xp_long **nlist, xp_long *nloc, xp_long *nsize, xp_long *ncell, xp_long **cell_ind);
int UTILcut_prism (char *cell_table, int set, int null_flag, unsigned char * flags, int dir, xp_long old_nnodes, xp_long *node_ind, char *edge_table, xp_long *out_ncells, xp_long **nlist, xp_long *nloc, xp_long *nsize, xp_long *ncell, xp_long **cell_ind);
int UTILcut_pyr (char *cell_table, int set, int null_flag, unsigned char * flags, int dir, xp_long old_nnodes, xp_long *node_ind, char *edge_table, xp_long *out_ncells, xp_long **nlist, xp_long *nloc, xp_long *nsize, xp_long *ncell, xp_long **cell_ind);
int UTILcut_tet (char *cell_table, int set, int null_flag, unsigned char * flags, int dir, xp_long old_nnodes, xp_long *node_ind, char *edge_table, xp_long *out_ncells, xp_long **nlist, xp_long *nloc, xp_long *nsize, xp_long *ncell, xp_long **cell_ind);
int UTILcut_quad (char *cell_table, int set, int null_flag, unsigned char * flags, int dir, xp_long old_nnodes, xp_long *node_ind, char *edge_table, xp_long *out_ncells, xp_long **nlist, xp_long *nloc, xp_long *nsize, xp_long *ncell, xp_long **cell_ind);
int UTILcut_tri (char *cell_table, int set, int null_flag, unsigned char * flags, int dir, xp_long old_nnodes, xp_long *node_ind, char *edge_table, xp_long *out_ncells, xp_long **nlist, xp_long *nloc, xp_long *nsize, xp_long *ncell, xp_long **cell_ind);
int UTILcut_line (char *cell_table, int set, int null_flag, unsigned char * flags, int dir, xp_long old_nnodes, xp_long *node_ind, char *edge_table, xp_long *out_ncells, xp_long **nlist, xp_long *nloc, xp_long *nsize, xp_long *ncell, xp_long **cell_ind);
xp_long UTILnode_thresh (xp_long nnodes, int data_type, char *node_data, int null_flag, char *null_value,
		     double level, int dir, xp_long *node_ind);

/* cut_stct.c */
int UTILcut_struct (char *field_table, char *node_data, int dtype, int null_flag, char *null_value,
		    double iso_val, int dir, xp_long *old_nnodes, xp_long **old_nlist,
		    xp_long *new_nnodes, xp_long **min_nodes, xp_long **max_nodes, xp_long *out_ncells,
		    xp_long **out_conn_list, xp_long *conn_size, xp_long *ncell, xp_long **cell_ind);

/* data_fnc.c */
int UTILcopy_array_list (xp_long n, int veclen, int dtype, char *data,
                         xp_long size, xp_long *list, char *out_data);
int UTILextract_vector (xp_long nnodes, int *in_veclen, char **in_data, int dtype,
			       int out_veclen, int *subcomp, char *out_data);
int UTILextract_scalar (xp_long nnodes, int in_veclen, char *in_data,
                        int dtype, int comp, char *out_data);
int UTILthreshold (xp_long nnodes, char *thresh_data, int thresh_veclen, int thresh_comp,
		   int thresh_type, int null_flag, char *null_value, int below, double min_val,
		   int above, double max_val, char *in_data, int in_veclen, int in_type,
		   double in_null_value, char *out_data);
int UTILthreshold_scalar (xp_long nnodes, char *in_data, int dtype, int null_flag, char *null_value, int above, double thresh_val, int out_below, int out_above, int out_null, char *out_data);
int UTILclamp (xp_long nnodes, char *in_data, int clamp_veclen, int clamp_comp, int dtype,
	       int null_flag, char *null_value, int below, double min_val, int above, double max_val, char *out_data);
int UTILdownsize (int ndim, xp_long *dims, xp_long *stride, int dtype, char *in_data, char *out_data);
int UTILresample (int ndim, xp_long *dims, xp_long *rdims, int veclen, int dtype, char *in_data, char *out_data);
int  UTILfilter_1d (int nkern, float *kernels, xp_long n, int veclen,
                    int dtype, char  *in_data, char *out_data);
int  UTILinterpolate (xp_long n, double t, int dtype, char *in_data1,
                      char *in_data2, char *out_data);

/* delaun_2.c */
int UTILdelaun_tess_2D (xp_long nnodes, float *in_xyz, int nspace, float *min_ext, float *max_ext,
			int check, xp_long *nsimp, xp_long **connect_list);

/* delaun_3.c */
int UTILdelaun_tess_3D (xp_long nnodes, float *in_xyz, float *min_ext, float *max_ext,
			int check, xp_long *nsimp, xp_long **connect_list);

/* deriv.c */
int UTILderiv_3d (char *field_table, xp_long cell, int veclen, char *node_data, int dtype,
		  int null_flag, char *null_value, float *uvw, float *deriv);
int UTILderiv_2d (char *field_table, xp_long cell, int veclen, char *node_data, int dtype,
		  int null_flag, char *null_value, float *uvw, float *deriv, float xform[3][3], float xyz_loc[][3]);
int UTILderiv_cell_3d (char *field_table, xp_long cell, int veclen, char *node_data, int dtype,
		       int null_flag, char *null_value, float *uvw, float *deriv);
int UTILderiv_cell_2d (char *field_table, xp_long cell, int veclen, char *node_data, int dtype,
		       int null_flag, char *null_value, float *uvw, float *deriv, float xform[3][3], float xyz_loc[][3]);
int UTILderiv_struct_3d (char *field_table, xp_long cell, int veclen, char *node_data, int dtype,
			 int null_flag, char *null_value, float *uvw, float *deriv);
int UTILderiv_struct_2d (char *field_table, xp_long cell, int veclen, char *node_data, int dtype,
				int null_flag, char *null_value, float *uvw, float *deriv, float xform[3][3], float xyz_loc[][3]);
int UTILderiv_unif_3d (char *field_table, xp_long cell, int veclen, char *node_data,
		       int dtype, int null_flag, char *null_value, float *uvw, float *deriv);
int UTILderiv_unif_2d (char *field_table, xp_long cell, int veclen, char *node_data,
		       int dtype, int null_flag, char *null_value, float *uvw, float *deriv, float xform[3][3], float xyz_loc[][3]);
int UTILderiv_rect_3d (char *field_table, xp_long cell, int veclen, char *node_data,
		       int dtype, int null_flag, char *null_value, float *uvw, float *deriv);
int UTILderiv_rect_2d (char *field_table, xp_long cell, int veclen, char *node_data,
		       int dtype, int null_flag, char *null_value, float *uvw, float *deriv, float xform[3][3], float xyz_loc[][3]);

/* derv_fnc.c */
int UTILgrad (char *mesh_info, char *node_data, int veclen, int dtype, int null_flag, char *null_value, float *grad);
int UTILcurl (char *mesh_info, char *node_data, int veclen, int dtype, int null_flag, char *null_value, float *curl);
int UTILdiv (char *mesh_info, char *node_data, int veclen, int dtype, int null_flag, char *null_value, float *div);
int UTILgrad_cell (char *mesh_info, int cell_ndim, xp_long cell, char *node_data,
		   int dtype, int null_flag, char *null_value, xp_long n, float *uvw, float *grad);
int UTILcurl_cell (char *mesh_info, int cell_ndim, xp_long cell, char *node_data, int veclen, int dtype, int null_flag, char *null_value, xp_long n, float *uvw, float *curl);
int UTILdiv_cell (char *mesh_info, int cell_ndim, xp_long cell, char *node_data,
		  int veclen, int dtype, int null_flag, char *null_value, xp_long n, float *uvw, float *div);
int UTILgrad_cells (char *mesh_info, char *node_data, int veclen,
		    int dtype, int null_flag, char *null_value, float *grad);
int UTILcurl_cells (char *mesh_info, char *node_data, int veclen,
		    int dtype, int null_flag, char *null_value, float *curl);
int UTILdiv_cells (char *mesh_info, char *node_data, int veclen,
		   int dtype, int null_flag, char *null_value, float *div);
int UTILgrad_struct (char *mesh_info, char *node_data, int veclen,
		     int dtype, int null_flag, char *null_value, float *grad);
int UTILgrad_unif (char *mesh_info, char *node_data, int veclen,
		   int dtype, int null_flag, char *null_value, float *grad);
int UTILgrad_rect (char *mesh_info, char *node_data, int veclen,
		   int dtype, int null_flag, char *null_value, float *grad);
int UTILcurl_struct (char *mesh_info, char *node_data, int veclen,
		     int dtype, int null_flag, char *null_value, float *curl);
int UTILcurl_unif (char *mesh_info, char *node_data, int veclen,
		   int dtype, int null_flag, char *null_value, float *curl);
int UTILcurl_rect (char *mesh_info, char *node_data, int veclen,
		   int dtype, int null_flag, char *null_value, float *curl);
int UTILdiv_struct (char *mesh_info, char *node_data, int veclen,
		    int dtype, int null_flag, char *null_value, float *div);
int UTILdiv_unif (char *mesh_info, char *node_data, int veclen,
		  int dtype, int null_flag, char *null_value, float *div);
int UTILdiv_rect (char *mesh_info, char *node_data, int veclen,
		  int dtype, int null_flag, char *null_value, float *div);

/* edge.c */
int UTILedges_2D (xp_long nnodes, xp_long ncells, int cell_nnodes, xp_long *node_list,
                  int cell_corner_nnodes, xp_long *out_ncells, xp_long **out_node_list);
int UTILedges_3D (xp_long nnodes, xp_long ncells, int cell_nnodes, xp_long *node_list,
                  int nfaces, int *face_nnodes, int *face_corner_nnodes,
                  xp_long *face_node_list, xp_long *out_ncells, xp_long **out_node_list);

/* edge_ext.c */
int UTILexternal_edges (xp_long nnodes, int nspace, float *xyz, xp_long nfaces, int face_nnodes,
			int face_corner_nnodes, xp_long *node_list, xp_long *out_edges, xp_long **out_list, double angle);

/* extent.c */
int UTILfield_extent (char *field_table, float *min_ext, float *max_ext);

/* face_ext.c */
int UTILexternal_faces (xp_long nnodes, xp_long ncells, int cell_nnodes, xp_long *node_list, int nfaces,
			int *face_nnodes, int *face_corner_nnodes, xp_long *face_node_list,
			int max_sets, int *nsets, xp_long *out_ncells,
			int *out_cell_nnodes, xp_long **out_cells, xp_long **out_lists, xp_long *out_list_sizes);

/* fglyph.c */
int UTILglyph_func (char *field_table, int dtype, int veclen, char *data, int null_flag, char *null_value,
		    int scale_veclen, int color_veclen, char* scale_data, char *color_data, int vec_flag, int comp_flag, int norm_flag, double scale, int *scale_xyz,
		     float *in_xform, xp_long g_nnodes, int g_nspace, float *g_xyz, float *xform,
		     int out_nspace, float *out_xyz, char *out_data);
int UTILglyph (char *field_table, int dtype, int veclen, char *data, int null_flag, char *null_value,
	       int scale_veclen, int color_veclen, char *scale_data, char *color_data, int vec_flag, int comp_flag, int norm_flag, double scale, int *scale_xyz,
	       float *in_xform, xp_long g_nnodes, int g_nspace, float *g_xyz, float *xform,
	       int out_nspace, float *out_xyz, char *out_data);
int UTILglyph_unif (char *field_table, int dtype, int veclen, char *data, int null_flag, char *null_value,
			   int scale_veclen, int color_veclen, char *scale_data, char *color_data, int vec_flag, int comp_flag, int norm_flag, double scale, int *scale_xyz,
			   float *in_xform, xp_long g_nnodes, int g_nspace, float *g_xyz, float *xform,
			   int out_nspace, float *out_xyz, char *out_data);
int UTILglyph_rect (char *field_table, int dtype, int veclen, char *data, int null_flag, char *null_value,
			   int scale_veclen, int color_veclen, char *scale_data, char *color_data, int vec_flag, int comp_flag, int norm_flag, double scale, int *scale_xyz,
			   float *in_xform, xp_long g_nnodes, int g_nspace, float *g_xyz, float *xform,
			   int out_nspace, float *out_xyz, char *out_data);

/* fintegr.c */
int UTILintegrate (char *field_table, char * block_table, xp_long cell, char *node_data, int dtype, int veclen, int null_flag, char *null_value, double step, int order, float *start_point, float *end_point, float *start_value, float *value);
int UTILstream_line (char *field_table, char *block_table, char *node_data, int dtype, int veclen, int null_flag,
			    char *null_value, int order, int direct, int nseg, double min_vel,
			    float *start_point, int max_points, int *npoints, float *points, float *values,
			    int store, xp_long *cells, float *uvws, float *mags, float *times, float *end_point);

/* finterp.c */
int UTILinterpolate_data (xp_long nprobes, float *probe_xyz, int probe_nspace, float *xfm,
			  char *field_table, char *block_table, int ncomp, int dtype, int *veclen, char **node_data,
			   double *min, double *max, int *null_flag, double *null_value, char **out_node_data);
int UTILinterpolate_cell_data (xp_long nprobes, float *probe_xyz,
	int probe_nspace, float *xfm, char *field_table, char *block_table,
	int *sets, int dtype, int veclen, char **cell_data, char *min,
	char *max, int *null_flag, char *null_value, char *out_node_data);

/* gauss.c */
int UTILvol_integr (char *field_table, int dim, char *node_data, int dtype, int null_flag, char *null_value, float *volume, float *mass);
int UTILvol_integr_cell_line (char *field_table, int set, xp_long cell, char *node_data, int dtype, int null_flag, char *null_value, float *volume, float *mass);
int UTILvol_integr_cell_tri (char *field_table, int set, xp_long cell, char *node_data, int dtype, int null_flag, char *null_value, float *volume, float *mass);
int UTILvol_integr_cell_quad (char *field_table, int set, xp_long cell, char *node_data, int dtype, int null_flag, char *null_value, float *volume, float *mass);
int UTILvol_integr_cell_tet (char *field_table, int set, xp_long cell, char *node_data, int dtype, int null_flag, char *null_value, float *volume, float *mass);
int UTILvol_integr_cell_hex (char *field_table, int set, xp_long cell, char *node_data, int dtype, int null_flag, char *null_value, float *volume, float *mass);
int UTILvol_integr_cell_prism (char *field_table, int set, xp_long cell, char *node_data, int dtype, int null_flag, char *null_value, float *volume, float *mass);

/* gen_data.c */
int UTILgen_data (xp_long nnodes, int veclen, int comp, int dtype, char *data, int nspace, float *xyz, float *coeff, int null_flag, double null_value);

/* interpol.c */
int UTILinterp_cell_uvw (char *field_table, xp_long cell, float *point, int inside, double tol, float *uvw);
int UTILinterp_cell_val (char *field_table, xp_long cell, int veclen, char *node_data, int dtype, int null_flag, char *null_value, int nval, float *uvw, float *output);
int UTILinterp_cell_uvw_struct (char *field_table, xp_long cell, float *point, int inside, double tol, float *uvw);
int UTILinterp_cell_uvw_unif (char *field_table, xp_long cell, float *point, int inside, double tol, float *uvw);
int UTILinterp_cell_uvw_rect (char *field_table, xp_long cell, float *point, int inside, double tol, float *uvw);
int UTILinterp_cell_val_struct (char *field_table, xp_long cell, int veclen, char *node_data, int dtype, int null_flag, char *null_value, int nval, float *uvw, float *output);

/* iso_fnc.c */
int UTILisosurf (char *field_table, char *node_data, int data_type, int null_flag, char *null_value, double level,
			xp_long *out_nnodes, xp_long **min_nodes, xp_long **max_nodes,
			xp_long *out_ncells_line, xp_long **out_conn_list_line, xp_long *conn_size_line,
			xp_long *out_ncells_tri, xp_long **out_conn_list_tri, xp_long *conn_size_tri,
			xp_long *ncell, xp_long **cell_ind);
int UTILslice_cells (char *field_table, char *node_data, int data_type, int null_flag, char *null_value, double level,
			    xp_long *out_nnodes, xp_long **min_nodes, xp_long **max_nodes,
			    xp_long *out_ncells_line, xp_long **out_conn_list_line, xp_long *conn_size_line,
			    xp_long *out_ncells_tri, xp_long **out_conn_list_tri, xp_long *conn_size_tri,
			    xp_long * ncell, xp_long **cell_ind);

xp_long UTILslice_hex (char *field_table, int set, int null_flag, unsigned char *flags, char *edge_table, xp_long **nlist, xp_long *nloc, xp_long *nsize, xp_long **cell_ind);
xp_long UTILslice_tet (char *field_table, int set, int null_flag, unsigned char *flags, char *edge_table, xp_long **nlist, xp_long *nloc, xp_long *nsize, xp_long **cell_ind);
xp_long UTILslice_prism (char *field_table, int set, int null_flag, unsigned char *flags, char *edge_table, xp_long **nlist, xp_long *nloc, xp_long *nsize, xp_long **cell_ind);
xp_long UTILslice_pyr (char *field_table, int set, int null_flag, unsigned char *flags, char *edge_table, xp_long **nlist, xp_long *nloc, xp_long *nsize, xp_long **cell_ind);
int UTILedge_table_add_points (char *edge_table, xp_long *node1_list, xp_long *node2_list, int npts, int *pts);
int UTILedge_table_get_free (char *edge_table, xp_long **min_node_list, xp_long **max_node_list, xp_long *size);
char *UTILedge_table_create (xp_long size);
int UTILedge_table_delete (char *edge_table);

/* iso_stct.c */
int UTILslice_struct (char *field_table, char *node_data, int dtype, int null_flag, char *null_value, double iso_val,
			     xp_long *out_nnodes, xp_long **min_nodes, xp_long **max_nodes,
			     xp_long *out_ncells_line, xp_long **out_conn_list_line, xp_long *conn_size_line,
			     xp_long *out_ncells_tri, xp_long **out_conn_list_tri, xp_long *conn_size_tri,
			     xp_long *ncell, xp_long **cell_ind);

int UTILedge_table_clean (char *edge_table, xp_long clean_size);
int UTILedge_table_add_str (char *edge_table, xp_long *node1_list, xp_long *node2_list, xp_long offset, int npts, int *pts);
int UTILedge_table_free_str (char *edge_table, xp_long **min_node_list, xp_long **max_node_list, xp_long *nnodes);
char *UTILedge_table_create_str (xp_long size, int block);
int UTILedge_table_delete_str (char *edge_table);

/* iso_trc.c */
int UTILiso_trace (char *field_table, char *block_table, char *node_data, int dtype, int null_flag, char *null_value, float *xyz, double *iso_val, xp_long *out_nnodes, xp_long **min_nodes, xp_long **max_nodes, xp_long *out_ncells, xp_long **out_conn_list, xp_long *conn_size);
char *UTILcell_table_create (xp_long size, xp_long ncells);
int UTILcell_table_delete (char *table);
int UTILcell_table_add (char *table, xp_long cell);
int UTILcell_in_table (char *table, xp_long cell);
int UTILedge_table_add_hash_points (char *edge_table, xp_long *node1_list, xp_long *node2_list, xp_long nnodes, int npts, int *pts);
int UTILisoline_trace (char *field_table, char *block_table, char *node_data, int dtype, int null_flag, char *null_value, float *xyz, double *iso_val, xp_long *out_nnodes, xp_long **min_nodes, xp_long **max_nodes, xp_long *out_ncells, xp_long **out_conn_list, xp_long *conn_size);

/* isoline.c */
int UTILisoline (char *field_table, char *node_data, int data_type, int null_flag, char *null_value, double level, xp_long *out_nnodes, xp_long **min_nodes, xp_long **max_nodes, xp_long *out_ncells, xp_long **out_conn_list, xp_long *conn_size, xp_long *ncell, xp_long **cell_ind);
int UTILisoline_cells (char *field_table, char *node_data, int data_type, int null_flag, char *null_value,double level, xp_long *out_nnodes, xp_long **min_nodes, xp_long **max_nodes, xp_long *out_ncells, xp_long **out_conn_list, xp_long *conn_size, xp_long *ncell, xp_long **cell_ind);
xp_long UTILisoline_tri (char *field_table, int set, int null_flag, unsigned char *flags, char *edge_table, xp_long **nlist, xp_long *nloc, xp_long *nsize, xp_long **cell_ind);
xp_long UTILisoline_quad (char *field_table, int set, int null_flag, unsigned char *flags, char *edge_table, xp_long **nlist, xp_long *nloc, xp_long *nsize, xp_long **cell_ind);
int UTILisoline_struct (char *field_table, char *node_data, int data_type, int null_flag, char *null_value,double level, xp_long *out_nnodes, xp_long **min_nodes, xp_long **max_nodes, xp_long *out_ncells, xp_long **out_conn_list, xp_long *conn_size, xp_long *ncell, xp_long **cell_ind);

/* jacobian.c */
float UTILjacobian_1d_det (xp_long num_nodes, float *derivs, float n_xyz[][3]);
float UTILjacobian_2d_det (xp_long num_nodes, float *derivs, float n_xyz[][3]);
float UTILjacobian_3d_det (xp_long num_nodes, float *derivs, float n_xyz[][3]);

/* least_sq.c */
int UTILleast_squares (xp_long n, float *x, int type, char *y, xp_long ncoef, double *coeff);
int UTILeval_polynom (xp_long ncoef, double *coeff, xp_long n,
                      float *x, char *y, int type);

/* mat_solv.c */
int UTILgauss_solve(double *matrix, double *rhs, xp_long *permute, double *dof, xp_long dim, double tolerance);

/* optm_srf.c */
int UTILoptimize_surface (xp_long *dims, int nspace, float *points,
                          int dtype, char *data, double eps,
                          xp_long *nnodes, float **coord, xp_long *ntri,
                          xp_long **conn, char **out_data);

/* param.c */
int UTILeval_coord (char *field_table, xp_long nnodes, xp_long *min_node_list, xp_long *max_node_list, float *t, float *out_data);
int UTILeval_param_coord (char *field_table, xp_long nnodes, xp_long *min_node_list, xp_long *max_node_list, float *t, float *out_data);
int UTILeval_param_coord_unif (char *field_table, xp_long nnodes, xp_long *min_node_list, xp_long *max_node_list, float *t, float *coord);
int UTILeval_param_coord_rect (char *field_table, xp_long nnodes, xp_long *min_node_list, xp_long *max_node_list, float *t, float *coord);
int UTILget_param (xp_long nnodes, int dtype, char *node_data, double level, xp_long *min_node_list, xp_long *max_node_list, float *t);
int UTILeval_param (xp_long nnodes, int veclen, int dtype, char *in_data, int null_flag, char *null_value, xp_long *min_node_list, xp_long *max_node_list, float *t, char *out_data);
int UTILget_coord_list (char *field_table, xp_long nnodes, xp_long *nlist, float *coord);
int UTILcoord_list (char *field_table, xp_long size, xp_long *nlist, float *coord);
int UTILcoord_list_struct (char *field_table, xp_long nnodes, xp_long *nlist, float *coord);
int UTILcoord_list_unif (char *field_table, xp_long nnodes, xp_long *nlist, float *coord);
int UTILcoord_list_rect (char *field_table, xp_long nnodes, xp_long *nlist, float *coord);
int UTILget_data_list (char *field_table, int data_type, int veclen, char *node_data, xp_long nnodes, xp_long *node_ind, char *out_data);
xp_long UTILdata_list (char *field_table, int data_type, int veclen, char *node_data, xp_long nnodes, xp_long *node_ind, char *out_data);
xp_long UTILdata_list_struct (char *field_table, int data_type, int veclen, char *node_data, xp_long nnodes, xp_long *node_ind, char *out_data);

/* rev_par.c */
int UTILrev_par_line_1 (float n_xyz[][3], float p_xyz[3], float *uvw);
int UTILrev_par_line_2 (float n_xyz[][3], float p_xyz[3], float *uvw);
int UTILrev_par_tri_1 (float n_xyz[][3], float p_xyz[3], float *uvw);
int UTILrev_par_quad_1 (float n_xyz[][3], float p_xyz[3], float *uvw);
int UTILrev_par_tri_2 (float n_xyz[][3], float p_xyz[3], float *uvw);
int UTILrev_par_quad_2 (float n_xyz[][3], float p_xyz[3], float *uvw);
int UTILrev_par_tet_1 (float n_xyz[][3], float p_xyz[3], float *uvw);
int UTILrev_par_pent_1 (float n_xyz[][3], float p_xyz[3], float *uvw);
int UTILrev_par_pyr_1 (float n_xyz[][3], float p_xyz[3], float *uvw);
int UTILrev_par_hex_1 (float n_xyz[][3], float p_xyz[3], float *uvw);
int UTILrev_par_tet_2 (float n_xyz[][3], float p_xyz[3], float *uvw);
int UTILrev_par_pent_2 (float n_xyz[][3], float p_xyz[3], float *uvw);
int UTILrev_par_hex_2 (float n_xyz[][3], float p_xyz[3], float *uvw);

/* ribbon.c */
int UTILribbon (char *field_table, int npoints, int nspace, float *points, float *values, xp_long *cells,
		float *uvws, float *mags, float *times, int veclen, char *node_data, int dtype,
		int null_flag, char *null_value, double width0, double angle0, float *width_end, float *angle_end);

/* roi_util.c */
int UTILroi_sort_verts (int nspace, float *xyz, xp_long *poly_line,
		        int start_angle, xp_long *list, float *t);
int UTILroi_connect_verts (xp_long n0, xp_long n1, xp_long *list0, xp_long * list1,
			   float *t0, float *t1, xp_long *ntri, xp_long *conn);

/* sctintrp.c */
int UTILscat_interp_alloc (xp_long nnodes, int ndim, xp_long *dims, char **block_table);
int UTILscat_interp_end (char *block_tbl);
int UTILscat_interp_init (xp_long nnodes, int nspace, float *xyz, float *min_xyz, float *max_xyz, int ndim, xp_long *dims, char **block_table);
int UTILscat_data_interp (char *block_table, xp_long nnodes, int nspace, float *xyz, int dtype, int veclen, char *in_data, float *min_xyz, float *max_xyz, int ndim, xp_long *dims, int *depth, int order, int *null_flag, char *null_value, char *out_data);
int UTILscat_data_interp2 (xp_long nnodes, int nspace, float *xyz,
        int dtype, int veclen, char *in_data, float *min_xyz, float *max_xyz,
        int ndim, xp_long *dims, int *depth, int order, int *null_flag,
        char *null_value, char *out_data);

/* shape.c */
void UTILsh_func_line_1 (float *uvw, float sh_func[2]);
void UTILsh_deriv_line_1 (float *uvw, float sh_func_deriv[2]);
void UTILsh_func_line_2 (float *uvw, float sh_func[3]);
void UTILsh_deriv_line_2 (float *uvw, float sh_func_deriv[3]);
void UTILsh_func_tri_1 (float *uvw, float sh_func[3]);
void UTILsh_deriv_tri_1 (float *uvw, float sh_func_deriv[2][3]);
void UTILsh_func_quad_1 (float *uvw, float sh_func[4]);
void UTILsh_deriv_quad_1 (float *uvw, float sh_func_deriv[2][4]);
void UTILsh_func_tri_2 (float *uvw, float sh_func[6]);
void UTILsh_deriv_tri_2 (float *uvw, float sh_func_deriv[2][6]);
void UTILsh_func_quad_2 (float *uvw, float sh_func[8]);
void UTILsh_deriv_quad_2 (float *uvw, float sh_func_deriv[2][8]);
void UTILsh_func_pent_1 (float *uvw, float sh_func[6]);
void UTILsh_deriv_pent_1 (float *uvw, float sh_func_deriv[3][6]);
void UTILsh_func_hex_1 (float *uvw, float sh_func[8]);
void UTILsh_deriv_hex_1 (float *uvw, float sh_func_deriv[3][8]);
void UTILsh_func_pyr_1 (float *uvw, float sh_func[5]);
void UTILsh_deriv_pyr_1 (float *uvw, float sh_func_deriv[3][5]);
void UTILsh_func_tet_1 (float *uvw, float sh_func[4]);
void UTILsh_deriv_tet_1 (float *uvw, float sh_func_deriv[3][4]);
void UTILsh_func_tet_2 (float *uvw, float sh_func[10]);
void UTILsh_deriv_tet_2 (float *uvw, float sh_func_deriv[3][10]);
void UTILsh_func_pent_2 (float *uvw, float sh_func[15]);
void UTILsh_deriv_pent_2 (float *uvw, float sh_func_deriv[3][15]);
void UTILsh_func_hex_2 (float *uvw, float sh_func[20]);
void UTILsh_deriv_hex_2 (float *uvw, float sh_func_deriv[3][20]);

/* slice.c */
xp_long UTILrslice (char *field_table, xp_long *dims, float *points, float *plane_norm, double plane_dist, xp_long *out_dims, float **out_points, int out_nspace, float *xform, xp_long **min_node, xp_long **max_node, float **t, char **list);
xp_long UTILrslice_unif (xp_long *dims, float *points, float *plane_norm, double plane_dist, xp_long *out_dims, float **out_points, int out_nspace, float *xform, xp_long **min_node, xp_long **max_node, float **t, char **list);
xp_long UTILrslice_rect (xp_long *dims, float *points, float *plane_norm, double plane_dist, xp_long *out_dims, float **out_points, int out_nspace, float *xform, xp_long **min_node, xp_long **max_node, float **t, char **list);

/* struct.c */
int UTILget_coords_unif (int ndim, xp_long *dims, int nspace, float *points, xp_long min_node, xp_long max_node, int min_space, int max_space, float *array);
int UTILget_coords_rect (int ndim, xp_long *dims, int nspace, float *points, xp_long min_node, xp_long max_node, int min_space, int max_space, float *array);
int UTILget_connect_struct (int ndim, xp_long *dims, xp_long min_cell, xp_long max_cell, xp_long *array);

/* thresh.c */
int UTILthresh_null (char *field_table, char *node_data, int data_type, char *null_data_value, xp_long *old_nnodes, xp_long **node_ind, int nsets, xp_long **out_cell_list, xp_long *out_ncells, xp_long **out_conn_list, xp_long *conn_size);
int UTILthresh_null_cells (char *field_table, char *node_data, int data_type, char *null_data_value, xp_long *old_nnodes, xp_long **node_ind, int nsets, xp_long **out_cell_list, xp_long *out_ncells, xp_long **out_conn_list, xp_long *conn_size);
int UTILcells_from_nlist (char *field_table, int set, xp_long old_nnodes, xp_long *node_ind, xp_long **out_cell_list, xp_long *out_ncells, xp_long **nlist, xp_long *nsize);
xp_long UTILnode_thresh_null (xp_long nnodes, int data_type, char *node_data, char *null_value, xp_long *node_ind);
int UTILthresh_null_struct (char *field_table, char *node_data, int data_type, char *null_data_value, xp_long *old_nnodes, xp_long **node_ind, int nsets, xp_long **out_cell_list, xp_long *out_ncells, xp_long **out_conn_list, xp_long *conn_size);

/* thresh_cell.c */
int UTILthresh_null_from_cells (char *field_table, int set, 
        char *cell_data, int data_type, char *null_data_value,
        xp_long **cell_ind, xp_long *out_ncells, xp_long **out_conn_list, xp_long *conn_size);

/* vec_null.c */
int UTILderiv_null (char *mesh_info, char *node_data, int veclen, int dtype, char *null_value, int out_veclen, float *out_node_data);
int UTILderiv_null_struct (char *mesh_info, char *node_data, int veclen, int dtype, char *null_value, int out_veclen, float *out_node_data);

/* vec_rect.c */
int UTILcurl_rect_3d (xp_long *dims, float xyz[], char *src, int dtype, float dst[][3]);
int UTILgrad_rect_3d (xp_long *dims, float xyz[], char *src, int dtype, float dst[]);
int UTILgrad_rect_2d (xp_long *dims, int nspace, float xyz[], char *src, int dtype, float dst[]);
int UTILdiv_rect_3d (xp_long *dims, float xyz[], char *src, int dtype, float dst[]);

/* vec_strc.c */
int UTILcurl_struct_3d (xp_long *dims, float xyz[], char *src, int dtype, float dst[][3]);
int UTILgrad_struct_3d (xp_long *dims, float xyz[], char *src, int dtype, float dst[]);
int UTILgrad_struct_2d (xp_long *dims, int nspace, float xyz[], char *src, int dtype, float dst[]);
int UTILdiv_struct_3d (xp_long *dims, float xyz[], char *src, int dtype, float dst[]);

/* vec_unif.c */
int UTILcurl_unif_3d (xp_long *dims, float xyz[], char *src, int dtype, float dst[][3]);
int UTILgrad_unif_3d (xp_long *dims, float xyz[], char *src, int dtype, float dst[]);
int UTILgrad_unif_2d (xp_long *dims, int nspace, float xyz[], char *src, int dtype, float dst[]);
int UTILdiv_unif_3d (xp_long *dims, float xyz[], char *src, int dtype, float dst[]);

#ifdef __cplusplus
} /* extern "C" */
#endif
