/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/event.h#1 $
*/

#ifndef XP_EVENT_INCLUDED
#define XP_EVENT_INCLUDED

#include <avs/port.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * constant definitions for use with the event handler abstraction.
 */

/* values for the type argument to EVadd_select */

#define EV_SELECT	1	/* call function on select hit */
#define EV_PRE		2	/* always call function as a warmup to select */
#define EV_POST		3	/* always call function after select */
#define EV_POLL		4	/* call function continuously (i.e. don't */
				/* hang in select) */
#define EV_TIMEOUT	5	/* call a function after a certain timeout */
#define EV_SELECT0	6	/* execute events only at 0 context level */
#define EV_PRE0		7	/* execute pre select only at 0 context */
#define EV_POLL0	8	/* execute poll only at 0 context */
#define EV_TIMEOUT0	9	/* execute timeout events at 0 context */
#define EV_MAX_SEL	9	/* end of the list */

#define EV_NO_AUX	0x10000 /* Bit that modifies the type field above */

/* values for direction */

#define EV_SEL_IN	1	/* select on input */
#define EV_SEL_OUT      2	/* select on output */
#define EV_SEL_EX	4	/* select on exceptions */


/* modes for the process_event call */
#define EV_INFINITE	1  	/* never return 		        */
#define EV_PRE_EVENT    2	/* return before event is delivered     */
#define EV_POST_EVENT   3	/* return once event has been delivered */
#define EV_ANY_EVENT	4	/* return after processing each event */

#define EV_NO_TIMEOUT   -1

int 	EVprocess_events (int, int, int, char *,int);
void 	EVadd_select     (int, int, void (*)(char *), void (*)(char *),
                          char *, int);
int  	EVdel_select     (int, int, void (*)(char *), void (*)(char *),
                          char *, int);
void	EVerror	         (const char *);
void 	EVflush_output   (void);
void 	EVflush_dynamic  (void);
void 	EVflush_events   (void);

void EVadd_select_handler (
   void (*add_sel_hndlr) (int, int, void (*)(char *), void (*)(char *),
                          char *, int, void *),
   void (*del_sel_hndlr) (int, int, void (*)(char *), void (*)(char *),
                          char *, int));

void EVset_event_processor (void (*)(void *), void *);

#ifdef EV_DECLARE_GLOBALS
#define EV_EXTERN
#else
#ifdef XP_INTERNAL_GLOBALS
#define EV_EXTERN extern
#else
#define EV_EXTERN DLL_IMPORT
#endif
#endif

EV_EXTERN int EV_ctx_key;

#define EVset_ctx_key(val)  	EV_ctx_key = val


#ifdef WIN32

#ifdef __cplusplus
#include <afxwin.h>
#else
#include <windows.h>
#endif

#undef min
#undef max

HWND	EVset_curr_shell (HWND);

/*
 * These are windows events we use internally.  There values are defined
 * using RegisterWindowMessage
 */
#define WM_SOCKETREADY	EV_wm_socketready
#define WM_PIPEREADY	EV_wm_pipeready
#define WM_POLL		EV_wm_poll

EV_EXTERN UINT EV_wm_socketready, EV_wm_pipeready, EV_wm_poll;

#endif  /* WIN32 */

#ifdef __cplusplus
} /* End of extern "C" */
#endif

#endif
