/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/event_x.h#1 $
*/
#ifndef XP_EVENT_X_INCLUDED
#define XP_EVENT_X_INCLUDED

#include <avs/port.h>

#include <X11/Intrinsic.h>

#define EVX_NO_SELECT	1

/* 
 * Need to select for events that do not have bits in the windows event
 * structure.  These bits represent these guys.  These can't conflict with
 * the X masks (e.g. ExposureMask).
 */
#define EVX_CLIENT_MESSAGE_MASK		(1L<<30)
#define EVX_NON_X_MASK			(EVX_CLIENT_MESSAGE_MASK)

typedef void (*EVXhndlr) (Display *xdisp, Window xwind,
                          XEvent *event, void *arg);
typedef void (*EVXfilter) (Display *xdisp, Window xwin,
                           XEvent *event, void *arg, EVXhndlr func,
                           void *filtarg);

#ifdef __cplusplus
extern "C" {
#endif

void 	EVXadd_select (Display *,void (*)(void *), char *);
void 	EVXdel_select (Display *);
void	EVXinit_display (Display *);

void	EVXinit_display_xt (Display *);

void 	EVXadd_event_hndlr (Display *display, Window window, 
                            unsigned int mask, 
                            EVXhndlr hndlr,
                            void *udata, unsigned int flags, EVXfilter filter,
                            void *filtarg);

int 	EVXdel_event_hndlr (Display *display, Window window,
                            unsigned int mask, 
                            void (*func)(Display *, Window, XEvent *, void *),
                            void *udata);
int 	EVXdel_events (Display *display, Window window);

void    EVXhandle_event (Display *display, XEvent *event,
                         XtAppContext app_ctx);

void	EVXflush_expose_events (void);
void	EVXflush_dynamic_events (void);

#ifdef MSDOS
void	EVadd_dynamic_window (int window);
void	EVdel_dynamic_window (int window, int all);
#else
void	EVadd_dynamic_window (void *);
void	EVdel_dynamic_window (void *, int all);
#endif

#ifdef __cplusplus
}
#endif

#endif /* XP_EVENT_X_INCLUDED */
