/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/f_utils.h#1 $
*/

#ifndef f_utils_h
#define f_utils_h

/*
 * file_utils.h
 *
 * include file for source modules use the FILExxx functions
 */

#ifndef PORT_HEADER_IS_INCLUDED
#   include <avs/port.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#define FILE_READ	1
#define FILE_WRITE	2
#define FILE_EXEC	4
#define FILE_DIR	8

/*
 * useful characters and strings for file/directory name
 * processing
 */
#ifdef VMS
#define ROOT_DIR_STR            "[000000]"
#define PARENT_PATH_STR         "[-]"
#define PARENT_PATH_CHAR        '-'
#define ROOT_DIR_CHAR           '['
#define END_DIR_CHAR            ']'
#define DELIMIT_NODE_STR        "::"
#define DELIMIT_DEVICE_CHAR     ':'
#define DELIMIT_DIR_CHAR        '.'
#define DELIMIT_DIR_STR         "."
#define DELIMIT_EXTENSION_CHAR  '.'
#define DELIMIT_VERSION_CHAR    ';'
#define CURRENT_DIR_STR         "[]"
#else
#ifdef MSDOS
#define ROOT_DIR_STR            "\\"
#define PARENT_PATH_STR         "..\\"
/* fine PARENT_PATH_CHAR        not applicable */
#define ROOT_DIR_CHAR           '\\'
#define END_DIR_CHAR            '\\'
#define DELIMIT_NODE_STR        "\\\\"
#define DELIMIT_DIR_STR		"\\"
/* fine DELIMIT_DEVICE_CHAR     not applicable */
#define DELIMIT_DIR_CHAR        '\\'
#define ALT_DELIMIT_DIR_CHAR	'/'
#define DELIMIT_EXTENSION_CHAR  '.'
/* fine DELIMIT_VERSION_CHAR    not applicable */
#define CURRENT_DIR_STR         "."
#define CURRENT_PATH_STR	".\\"
#else
#define HOME_DIR_STR		"~"
#define ROOT_DIR_STR            "/"
#define PARENT_PATH_STR         "../"
/* fine PARENT_PATH_CHAR        not applicable */
#define ROOT_DIR_CHAR           '/'
#define END_DIR_CHAR            '/'
#define DELIMIT_NODE_STR        "@"
/* fine DELIMIT_DEVICE_CHAR     not applicable */
#define DELIMIT_DIR_CHAR        '/'
#define DELIMIT_DIR_STR		"/"
#define ALT_DELIMIT_DIR_CHAR	'\\'
#define DELIMIT_EXTENSION_CHAR  '.'
/* fine DELIMIT_VERSION_CHAR    not applicable */
#define CURRENT_DIR_STR         "."
#define CURRENT_PATH_STR	"./"
#endif
#endif

/*
 * FLAGS for FILEget_base_name()
 */
#define FILE_STRIP_VERSION        0x01
#define FILE_STRIP_EXTENSION      0x02   /* this implies strip version */

/*
 * FLAGS for FILEget_dir_name()
 */
#define FILE_STRIP_DEVICE         0x01
#define FILE_NAME_RELATIVE        0x02

char *FILEget_parent_name (const char *);
char *FILEget_parent_dir (const char *);
char *FILEget_base_name (const char *, int);
char *FILEget_dir_name (const char *, int);
char *FILEget_dir_name_buf (const char *, int, char *);
char *FILEget_file_extension (const char *filename);
char *FILEparent_path_string (void);
char *FILEroot_dir_string (void);
char *FILEdirectory_delimiter (char *);
char *FILEclean_directory_name (char *);
char *FILEconcat_dir_and_dir (char *,char *,char *);
char *FILEconcat_dir_and_file (const char *, const char *,char *);
char *FILEconcat_file_and_extension (const char *, const char *,char *);
int   FILEis_path_parent (const char *);
int   FILEis_path_absolute (const char *);
int   FILEis_hidden (const char *);
char *FILEcondition_filename (char *);

char *FILEmap_variables (const char *, char *);
char *FILEunmap_variables (char *, char *);

void FILEadd_variable (const char *name, char *def, int hidden);
char *FILElookup_var (const char *);

/* Functions in filepath.c */
FILE *FILEpath_fopen (const char *filename, const char *type, const char *path, char sep);
char *FILEpath_find (const char *filename, const char *path, char sep);
FILE *FILEfopen (const char *filename, const char *type);
char *FILEfind (const char *filename, const char *path, char sep, int mode,
		time_t *mod_time, int *path_index);
int FILEexists (const char *path, int mode, time_t *mod_time);
char * FILEwhich (const char *path);
char * FILEget_exec_dir (const char *path);

void pt_initialize_getcwd (void);
char *pt_getcwd (char *str, int size);

#ifdef __cplusplus
} /* end of extern C */
#endif

#endif /* f_utils_h */
