/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved
	
	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.
	
	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/flow.h#1 $
*/
/*		@(#)flow.h	9.1 AVS 93/03/16	*/

/*
 * flow.h: FLOW header
 */

#ifndef _FLOW_defined

#ifndef MSDOS
/*
   #include <avs/lui.h>
*/
#endif
#include <avs/avs_data.h>
#include <avs/avs.h>

/* Contains port specific definitions */
#include <avs/port.h>


#ifdef __cplusplus
extern "C" {
#endif

#define AVS_MAX_ARGS	80	/* maximum args to an AVS filter routine */
#define AVS_MAX_TAGS    2       /* Maxmimum number of allowed tags       */
#define MOD_GROUP_TAG   0       /* Index of group identifier tag         */
#define MOD_TYPE_TAG    1       /* Index of type equivalent tag          */
                                /* Other tags undefined at this time     */

/******************************************************************************/
#define FLOW_INTERACTOR char

struct DataElement {
	char *string_name;
	struct AVSdata_desc *descriptor;
	char *template;
};


/* Flags for a connection */
#define CLASS_CONNECTION 0x1   	/* Means connection was created automatically */

struct Connection {
	struct module *peer;	/* peer module */
	int port;		/* port number on peer that we are connected to */
	struct Connection *next; /* next link on list */
	int flags;
	int changed;		/* 
				 * Whether or not the input port part of the
				 * connection has been changed since the 
				 * downstream module has been executed.
				 * This flag is basically the same as 
				 * inputPorts[i].changed except for cases
				 * where there are multiple inputs for a 
				 * particular port (e.g. render geometry).
				 * XXX Implentation note:
				 *   Currently we don't maintain the 
				 *   connection data structure in the module.	
				 *   this will make multiple inputs in remote
				 *   modules be tricky.  The right thing to do
				 *   is to build this data structure as
				 *   we read in inputs from the kernel.
				 *   we could also, then, read additional 
				 *   information about the upstream module
				 *   at that time and provide the module 
				 *   access to it.
				 */
};

struct GenPort {
	char *name;
	int flags;		/* defined in avs.h */
	struct DataElement type;
	/* These connections are the user interface connections */
	struct Connection *connections;
	/* 
         * These connections are the connections that data flow through.
 	 * They are usually the same but if the module is connected to 
	 * a ROUTE module, the data connections will go directly to the
	 * module that wants to get the data.
	 */
	struct Connection *data_conns;
	int changed;
	char *class;
};


/******************************************************************************/
/* AVS Widget description block                                               */
/******************************************************************************/

typedef struct _uiProp {
   char *name;
   char *typename;
   char *valuep;
} uiProp, *uiPropList;

extern float *UIfloat(/* float */);

struct AVSwidget {
   char *desc;          /* Preferred widget class if any */
   char *instance;      /* Actual widget once created    */
   int prop_count;      /* Widget properties             */
   uiPropList props;
};

extern struct AVSwidget *AVSwidget_create();

/* 
 * Structure for each input or output port.
 */
struct Port {
/**** These fields are shared in common with the GenPort structure above ****/
	char *name;
	int flags;		/* defined in avs.h */
	struct DataElement type;
	struct Connection *connections;	/* linked list of connections */
	struct Connection *data_conns;	/* See GenPort for description */
	int changed;
	char *class;
/****************************************************************************/

	int source_port;	/* port to initialize data from */
	char *data;		/* For an output port this is address */
				/* of the data. */
				/* For an input port this is address of */
				/* an array of pointers to data. */
				/* The number of elements in this array */
				/* is in source_port. */
 	int data_state;		/*   For output ports: (in the kernel)
				 * DATA_VALID if data is on the port and ok
				 * DATA_NOTSET if data has never been set before
				 * DATA_INVALID if data is ok but on client side
				 *
				 *   For input ports: (in the module)
				 * bit flags: n'th bit corresponds to the n'th
				 * connection to the port.  If it is set,
				 * the data was read and allocated -- if 0
				 * it is just a reference to another data set.
				 * XXX Note: this limits us to 32 input ports.
				 */
};

/* Values for the "data_invalid" field of a modules output port */
#define DATA_VALID 0
#define DATA_NOTSET 1
#define DATA_INVALID 2

/****************************************************************/
/*               Generic Parameter Data Value                   */
/****************************************************************/

typedef union _gen_value {
	void            *gen_ptr;
	unsigned long    gen_ulong;
	long             gen_long;
	unsigned int     gen_uint;
	int              gen_int;
	unsigned short   gen_ushort;
	short            gen_short;
	unsigned char    gen_uchar;
	char             gen_char;
	float            gen_float;
	double           gen_double;
} GenValue;

#define GenValuePtr(_g)           ( (_g).gen_ptr )
#define GenValueULong(_g)         ( (_g).gen_ulong )
#define GenValueLong(_g)          ( (_g).gen_long )
#define GenValueUInt(_g)          ( (_g).gen_uint )
#define GenValueInt(_g)           ( (_g).gen_int )
#define GenValueUShort(_g)        ( (_g).gen_ushort )
#define GenValueShort(_g)         ( (_g).gen_short )
#define GenValueUChar(_g)         ( (_g).gen_uchar )
#define GenValueChar(_g)          ( (_g).gen_char )
#define GenValueFloat(_g)         ( (_g).gen_float )
#define GenValueDouble(_g)        ( (_g).gen_double )

/****************************************************************/

/*
 * Definition of the parameter structure.
 */
struct Parameter {
/**** These fields are shared in common with the GenPort structure above ****/
	char *name;
	int flags;
	struct DataElement type; /* the data type */
	struct Connection *connections; /* Any connections to this parameter */
	struct Connection *data_conns; /* Data connections to the parameter */
	int changed;
	char *class;
/****************************************************************************/

#if SX
   !!!  I just broke the SX stuff with GenValue below  !!!
	Pointer minval, maxval;	/* the range */
#else
	GenValue minval, maxval;	/* the range */
#endif
	struct AVSwidget *widget;
	GenValue valuep;		/* the current value */
};

#define CONN_DATA_SIZE 4

typedef struct module *FLOW_MODULE_PTR;

typedef struct {
    int transport_type;		/* transport type - DECnet, TCP */
    union
	{
	char *decnet_server_name;	/* data:  int (port) for TCP
				         string(server name) for DECnet */
	int tcp_port_number;
	char *smt_port_name;		/* the SMT name */
	} transport;
    int host_addr;
    } LISTEN_PORTS;
				    
#define MAXLISTENPORTS	3	/* 3 is plenty for now as only TCP and
				   DECnet and SMT are defined */
				    
/******************************************************************************/
typedef struct module {
    int              type;	/* the type of module - see avs.h for options */
    char            *name;	/* the name of this module */

    /* The functions associated with this module */
    FNCP	     initfn;	/* function to call to initialize instances */
    FNCP             filter;	/* function that does the computation */
    FNCP	     destroy;	/* function used to destroy a module */

    /* Input/Output ports and parameters */
    int		     in_channels, max_in_channels;
    struct Port	     *inputPorts;
    int		     out_channels, max_out_channels;
    struct Port	     *outputPorts;
    int		     param_count, max_param_count;
    struct Parameter *parameters;

    /* Flow executive support */
    int              changed;
    int              enabled;
    int		     on_queue;	/* boolean - true if we're on the flow exec queue */
    struct module   *next_exec;	/* next element in the flow exec queue */
    char            *network;
    char	    *static_area; /* area the module can use for itself */
    int		     flags;	  /* see below for bit definitions */

    /* external module support */
    int		     proto;	/* the connection protocol (e.g., TCP) */
    char	    *conn_id;	/* connection ID */
				/* This is a pointer to a block of */
				/* information to access control socket */
				/* to a module. */
    struct AVSclient_protocol *proto_tab; /* protocol function table */
    int		     proto_vers; /* protocol version that client is using */
    char	    *exec_command; /* command to exec to create the module */
    int		     mod_priority; /* an order count of when this module was started */

    /* Control panel support */
    char            *interactor;  /* Control panel widget if any */
    
    /* Network Editor support */
    char            *label;
    char            *message;	     /* an informational message that the module wants */

    /* Qualifier Tags */
    int             tags[AVS_MAX_TAGS];  /* Various qualifiers */

    /* More external module support. */
    int		    host_addr;	/* Internet address of machine where */
				/* the module is running. */
    int		    pid;	/* Process id of this instance. */
    int		    spid;	/* Process id of the starter module */

    /* More Network Editor support */
    char            *module_library; /* a tag for the module library */

    /* Even more external module support. */
    char	    *host_name;	/* Host name where module is running */
				/* if different than AVS kernel. */
				/* NULL when on same host. */
    char	    *rexec_method; /* Remote execution method used to run */
				/* module on remote host.  Should be */
				/* NULL if host_name is NULL. */
    int		    user_flags; /* Flags set by the user with */ 
				/* AVSset_module_flags.  Current */
				/* possibilities are COOPERATIVE, */
				/* REENTRANT, and SERVER_MOD which are */
				/* defined in avs.h. */

    /* Module alias for persistent name */
    char            *alias;     /* Optional user set alias */

    /* These are used for the remote directory lister. */
    FNCP	    server_callback_func; /* Function called when server */
					/* module sends back results. */
    FNCP	    lui_callback_func;	/* Update file browser. */
    char	    *lui_callback_arg;	/* Argument to lui_callback_func. */

    /* For direct module-to-module communication. */

    int		    listener_port_count;/* 0 if not listener ports for
					   direct module-module comm. */
    LISTEN_PORTS    listener_ports[MAXLISTENPORTS];
				    
    FLOW_MODULE_PTR parent;		/* defines the parent module */

    /* This information is only for macro slave modules */
    FLOW_MODULE_PTR master;		/* defines the master mod for parents */

    /* The following info is only relevant for "macro" modules */
    FLOW_MODULE_PTR inp_slave;
    FLOW_MODULE_PTR out_slave;
    FLOW_MODULE_PTR *children;
    int		    nchildren;

    FNCP	    connect;	/* function called for ROUTE modules to 
				   cause them to create the data connections */
    char 	    *pgroup;    /* group name for determining processes */
    int		    conn_data[CONN_DATA_SIZE]; /* impl specific conn data */
    unsigned int    feature_mask; /* feature mask for this module */
				/* See FLOW_FEATURE_... definitions, below. */
} FLOW_MODULE;

#ifdef DECLARE_AVSSTATIC_GLOBALS
EXPORT_GLOBAL char *AVSstatic; /* a static pointer kept by modules */
#else
IMPORT_GLOBAL char *AVSstatic;	/* a static pointer kept by modules */
#endif

IMPORT FLOW_MODULE *AVSmodule;

/* definitions for flags field */

#define FORTRAN        (1L<<0)	/* indicates whether module wants fortran */
				/* style args */

#define EXTERNAL_MOD   (1L<<1)	/* if module is in a separate process, i.e. */
				/* not linked with the AVS Kernel. */
				/* This was previously named REMOTE, a */
				/* rather unfortunate choice because we */
				/* now have modules on remote hosts. */
#if 0
#define REMOTE	       (1L<<1)	/* Old name for EXTERNAL_MOD.  Will be */
				/* gone after I clean out all references */
				/* to it. */
#endif

#define COROUTINE      (1L<<2)	/* if module is functioning in coroutine mode */
#define WAITING	       (1L<<3)	/* if a coroutine is waiting for param change */
#define SENDING	       (1L<<4)	/* a coroutine was stopped while trying to send */
#define USER_INSTANCED (1L<<5)  /* if a module has been instanced by the user */
				/* spare bit. */
				/* spare bit. */
#define DEAD	       (1L<<8)	/* module appears to be dead */
#define HIDE_LABEL     (1L<<9)  /* Hide module label in network editor */
#define VISITED	       (1L<<10) /* flag to mark mod for graph traversal */
#define PENDED         (1L<<11) /* flag for postpended or prepended modules */
#define NOMAP          (1L<<12) /* flag for modules not allowing mapping */
#define RESTARTING     (1L<<13) /* flag for module being restarted */
#define SAME_PARMS     (1L<<14) /* restart module with same parameters */

#define SERVER_BUSY    (1L<<15) /* A command has been sent to a server */
				/* module but it has not responded yet. */
				/* Applicable only when SERVER_MOD is */
				/* set in user_flags. */
#define COR_SYNC       (1L<<16) /* coroutine is in sync mode */
#define COR_SCHEDULED  (1L<<17) /* coroutine has been scheduled since output */
#define MACRO	       (1L<<18) /* module is a macro module */
#define MACRO_SLAVE    (1L<<19) /* module is a slave of a macro module */
#define ROUTE_MODULE   (1L<<20) /* module is a flow-execution module */
#define DONT_SAVE      (1L<<21) /* temporary bit used to control cli output */
#define USER_SELECTED  (1L<<22) /* module is in a user group */

/* definitions for connection protocol */
#define CONN_TCP	1	/* DARPA TCP */

/* definitions for feature_mask */

#define FLOW_FEATURE_DYNLOAD 1	/* Dynamic module loading (DEC) */
	
/* Used to print statistics such as cpu time used by modules. */
/* In the future we might want to add other information such */
/* as memory usage. */

typedef struct {
	long utime;
	long stime;
	long elapsed;
} FLOW_MOD_TIME;

/******************************************************************************/
#define FLOW_MAX_SERVER_MODULES 256

#define FLOW_SYS_MOD_CHUNK_SIZE 128

#ifdef DECLARE_FLOW_GLOBALS
EXPORT FLOW_MODULE 
  **FlowUserModules,
  **FlowSystemModules,
  *FlowServerModules[FLOW_MAX_SERVER_MODULES];
EXPORT int 
  FlowVerbose = 0, 
  FlowSystemModuleIndex = 0,
  FlowUserModuleIndex = 0,
  FlowServerModuleIndex = 0,
  FlowSystemAlloced = 0;

#else
IMPORT int
  FlowSystemModuleIndex,
  FlowUserModuleIndex,
  FlowServerModuleIndex,
  FlowVerbose,
  FlowSystemAlloced;

IMPORT FLOW_MODULE 
  **FlowUserModules,
  **FlowSystemModules,
  *FlowServerModules[];
#endif

FLOW_MODULE 
  *FLOWdefine_user_module(),
  *FLOWlookup_user_module(),
  *FLOWlookup_system_module(),
  *FLOWcreate_macro_module(),
  *FLOWget_server();

struct GenPort *FLOWget_input_port();

/* flags for AVSexec_module */

#define SYSTEM_MODULE	1
#define USER_MODULE	2

/* There is no malloc.h on BSD systems.  */
/* I don't think taking this out will cause any problems. */
#if 0
#ifndef M_KEEP
#include <malloc.h>
#endif
#endif

#ifdef __cplusplus
} /* End of extern "C" */
#endif

#endif
#define _FLOW_defined
