/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/gd.h#1 $
*/

#ifndef XP_GD_INCLUDED
#define XP_GD_INCLUDED

#include <avs/port.h>

/* mat operations header file */
#include <avs/mat.h>

/* Defines the renderers that we are to use */
#include <avs/gd_ren.h>

/**********************************************/
/* Forward typedef declarations               */
/* Needed because of so many cross references */
/**********************************************/

typedef struct _GDview GDview;
typedef struct _GDwinfo GDwinfo;
typedef struct _GDlight_info GDlight_info;
typedef struct _GDlight GDlight;
typedef struct _GDcamera GDcamera;
typedef struct _GDoutput GDoutput;
typedef struct _GDprtOutput GDprtOutput;
typedef struct _GDvrmlOutput GDvrmlOutput;
typedef struct _GDfieldOutput GDfieldOutput;
typedef struct _GDfileOutput GDfileOutput;
typedef struct _GDviewAttrs GDviewAttrs;
typedef struct _GDobject GDobject;
typedef struct _GDobj_list GDobj_list;
typedef struct _GDobj_sel GDobj_sel;
typedef struct _GDprops GDprops;
typedef struct _GDcolor GDcolor;
typedef struct _GDmodes GDmodes;
typedef struct _GDtexture GDtexture;
typedef struct _GDxform GDxform;
typedef struct _GDtrack_edit GDtrack_edit;
typedef struct _GDpick_data GDpick_data;
typedef struct _GDpick_info GDpick_info;
typedef struct _GDgeom_data GDgeom_data;
typedef struct _GDcache GDcache;
typedef struct _GDcache_block GDcache_block;
typedef struct _GDcache_header GDcache_header;
typedef struct _GDstack GDstack;
typedef struct _GDclip GDclip;
typedef struct _GDstate_lights GDstate_lights;
typedef struct _GDstate GDstate;

/* new flipbook structures */
typedef struct _GDframe    GDframe;
typedef struct _GDflipbook GDflipbook;

#ifdef MSDOS
#ifdef __cplusplus
#include <afxwin.h>
#else
#include <windows.h>
#endif
#undef min
#undef max
#else
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Intrinsic.h>
#include <X11/IntrinsicP.h>
#include <avs/RenderV.h>
#endif

#include <avs/pal.h>		/* Need virtual palette stuff */
#include <avs/gd_def.h>
#include <avs/gd_str.h>

#ifdef __cplusplus
extern "C" {
#endif

/*****************************************************/
/*                 GD Functions                      */
/*****************************************************/

/* defined in gd/bounds.c */
void  GDdraw_bounds (GDobject *, GDgeom_data *, GDstate *);
void  GDdraw_bounds_altobj (GDview *, GDobject *);

/* defined in gd/fld_util.c */
int   GDfld_get_coord_extents (GDobject *);
void  GDfld_get_node_data (OMobj_id, GDgeom_data *);
int   GDfld_get_node_data_minmax (OMobj_id, double *, double *);
void  GDfld_get_node_data_ids (OMobj_id, GDgeom_data *);
int   GDfld_get_pick_node_data (OMobj_id, xp_long *, int *, char **);
void  GDfld_get_cell_data (OMobj_id, GDgeom_data *);
int   GDfld_get_cell_data_minmax (OMobj_id, double *, double *);
void  GDfld_get_cell_data_ids (OMobj_id, GDgeom_data *);

/* defined in gd/geom.m */
void  GDinit_geom_data (GDgeom_data *, GDstate *);
void  GDinit_geom_renderer_data (GDgeom_data *, GDstate *);
void  GDbuild_geom_renderer_data (GDobject *obj, GDgeom_data *data, GDstate *state);
void  GDfree_geom_data (GDgeom_data *);
void  GDfree_cache_geom_data (GDgeom_data *);
int   GDdata_size (int);
void  GDincr_geom_data (GDgeom_data *);

/* defined in gd/dmap_utl.c */
void  GDgen_colors (xp_long, int, char *, OMobj_id, float *);
void  GDgen_argbs (OMobj_id, char *, int, unsigned int *, unsigned int,
                   unsigned int, unsigned int, unsigned int, short *);
void  GDgen_rgbas (OMobj_id, char *, int, unsigned int *, unsigned int,
                   unsigned int, unsigned int, unsigned int, short *);
int   GDgen_pixels (OMobj_id, PALvirt *, unsigned int *);
int   GDdmap_get_byte_argbs (OMobj_id, unsigned int **);
int   GDdmap_get_short_argbs (OMobj_id, unsigned int **, int *);
int   GDdmap_get_func (OMobj_id, const char *, OMpfi *, void *);
int   GDdmap_get_minmax (OMobj_id, double *, double *);

/* defined in gd/gather.m */
char * GDgather_convert (GDobject *, GDstate *, char *, xp_long, xp_long *, char *,
                         int, int, int, int, int);
char * GDgather (GDobject *, GDstate *, char *, xp_long, xp_long *, char *,
                 int, int, int, int);
char * GDgraph_gather (GDobject *, GDstate *, char *, xp_long *, char *,
                       int, int, int, int);
char * GDgraph_gather_cells (GDobject *, GDstate *, char *, xp_long *, char *,
                             int, int, int, int, int);                             
xp_long GDremove_null_cells (xp_long, xp_long **, int, GDgeom_data *, int);
void    GDfree_null_cells (GDgeom_data *, xp_long *);
xp_long GDremove_null_strip_nodes (xp_long, xp_long, xp_long, GDgeom_data *, xp_long **);
xp_long GDremove_null_line_nodes (xp_long, xp_long, xp_long, GDgeom_data *, xp_long *, xp_long *,
                                xp_long **, xp_long **);
/* Defined in gd/view.c */
OMobj_id GDview_create (OMobj_id);
int   GDview_init (OMobj_id);
int   GDview_delete (OMobj_id);
int   GDview_update (OMobj_id);
void  GDview_render (GDview *);
int   GDview_status (GDview *);
void  GDview_clear_status (GDview *);
int   GDview_is_active (GDview *);
int   GDview_pick (OMobj_id);
int   GDview_event (OMobj_id);
#ifndef MSDOS
void  GDview_expose_event (Widget, XtPointer, XEvent *, Boolean *);
void  GDview_resize_event (Widget, XtPointer, XConfigureEvent *, Boolean *);
void  GDview_visibility_event (Widget, XtPointer, XVisibilityEvent *, Boolean *);
#endif
int   GDview_update_virtpal (OMobj_id);
int   GDview_build_view (GDview *);

int   GDview_call_func (GDview *, const char *, int);
int   GDview_get_func (GDview *, const char *, OMpfi *);
int   GDoutput_get_func (GDview *, const char *);
int   GDoutput_call_writefunc (GDview *, const char *, xp_long *, char *,char *);
int   GDprim_get_func (GDview *, const char *, OMpfi *);
int   GDview_pal_func (GDview *);
void  GDview_update_buffers (GDview *);
void  GDview_update_cameras (GDview *);
void  GDview_update_output (GDview *);
void  GDview_update_pick_ctrl (GDview *);
void  GDview_update_light_info (GDview *);
void  GDview_update_objects (GDview *);
void  GDview_update_picked_info (GDview *, int, OMobj_id *, OMobj_id *);
void  GDview_picked_info_valid (GDview *);
void  GDview_update_view (GDview *);
void  GDview_update_true_scale (GDview *);
void  GDview_concat_true_scale_matrix (GDview *, GDcamera *, float[4][4]);
int   GDview_set_renderer (OMobj_id, int);
void  GDview_get_renderer (OMobj_id, int *);
int   GDview_set_accel (OMobj_id, int);
void  GDview_get_accel (OMobj_id, int *);
int   GDview_set_timer (OMobj_id, int);
void  GDview_get_timer (OMobj_id, int *);
int   GDview_set_pcache (OMobj_id, int);
void  GDview_get_pcache (OMobj_id, int *);
int   GDview_set_render_mode (OMobj_id, int);
void  GDview_get_render_mode (OMobj_id, int *);
int   GDview_set_buffer_mode (OMobj_id, int);
void  GDview_get_buffer_mode (OMobj_id, int *);
int   GDview_set_back_color (OMobj_id, float *);
void  GDview_get_back_color (OMobj_id, float *);
int   GDview_set_output (OMobj_id, int);
void  GDview_get_output (OMobj_id, int *);
int   GDview_set_aspect (OMobj_id, int);
void  GDview_get_aspect (OMobj_id, int *);
void  GDview_set_stereo (OMobj_id, int);
void  GDview_get_stereo (OMobj_id, int *);
void  GDview_set_stereo_enable (OMobj_id, int);
void  GDview_get_stereo_enable (OMobj_id, int *);
void  GDview_set_video (OMobj_id, int);
void  GDview_get_video (OMobj_id, int *);
void  GDview_get_video_off (OMobj_id, int *);
void  GDview_set_video_off (OMobj_id, int);
void  GDview_set_stereo_balance (OMobj_id, float);
void  GDview_get_stereo_balance (OMobj_id, float *);
void  GDview_set_stereo_offset (OMobj_id, float);
void  GDview_get_stereo_offset (OMobj_id, float *);
int   GDview_set_refresh (OMobj_id);
int   GDview_get_time (int, char *);
int   GDview_set_config_flags (GDview *, int, int, int, int);
int   GDview_set_ts_enable (OMobj_id, int);
void  GDview_get_ts_enable (OMobj_id, int *);
int   GDview_set_ts_uniform (OMobj_id, int);
void  GDview_get_ts_uniform (OMobj_id, int *);
void  GDview_set_ts_scale (OMobj_id, float );
void  GDview_get_ts_scale (OMobj_id, float *);
void  GDview_set_ts_yscale (OMobj_id, float );
void  GDview_get_ts_yscale (OMobj_id, float *);
void  GDview_set_ts_xorig (OMobj_id, float);
void  GDview_get_ts_xorig (OMobj_id, float *);
void  GDview_set_ts_yorig (OMobj_id, float);
void  GDview_get_ts_yorig (OMobj_id, float *);
void  GDview_set_blend_mode (OMobj_id, int);
void  GDview_get_blend_mode (OMobj_id, int *);

/* Defined in gd/view_att.c */
void  GDview_attach_camera (OMobj_id, OMobj_id, int);
void  GDview_detach_cameras (OMobj_id);
void  GDview_detach_camera (OMobj_id, OMobj_id);
void  GDview_attach_light_info (OMobj_id, OMobj_id, int);
void  GDview_detach_light_info (OMobj_id, int);
void  GDview_attach_output (OMobj_id, OMobj_id, int);
void  GDview_detach_output (OMobj_id, int);
void  GDview_attach_object (OMobj_id, OMobj_id, int);
void  GDview_detach_objects (OMobj_id);
void  GDview_detach_object (OMobj_id, OMobj_id);
void  GDview_attach_pick_ctrl (OMobj_id, OMobj_id, int);
void  GDview_detach_pick_ctrl (OMobj_id, int);
void  GDview_attach_virtpal (OMobj_id, OMobj_id, int);
void  GDview_detach_virtpal (OMobj_id, int);

/* Defined in gd/handle.c */
OMobj_id GDhandle_create (void);
void  GDhandle_delete (OMobj_id);
void  GDview_attach_handle (OMobj_id, OMobj_id);
void  GDview_detach_handle (OMobj_id);
void  GDhandle_set_widget (OMobj_id, int);
void  GDhandle_set_window (OMobj_id, int);
void  GDhandle_set_event (OMobj_id, int);

/* Defined in gd/stack.c */
void  GDstack_create (GDview *);
void  GDstack_delete (GDview *);
void  GDstack_init (GDview *);
void  GDstack_enable (GDview *, int);
void  GDstack_add_entry (GDview *, const char *, OMpfi, char *, int, char *);
void  GDstack_push (GDview *view);
void  GDstack_pop (GDview *view);

/* Defined in gd/state.c */
void  GDstate_create (GDview *);
void  GDstate_init (GDview *);
void  GDstate_delete (GDview *);
int   GDstate_get_func (GDview *, const char *, OMpfi *);
void  GDstate_concat_obj_matrix (GDview *, float [4][4]);
void  GDstate_set_dith_tech (GDview *, int);
void  GDstate_set_interp_type (GDview *, int);
void  GDstate_set_tmap_method (GDview *, int);
void  GDstate_set_tri_subdiv (GDview *, int);
void  GDstate_set_missing (GDview *, float, float *);
void  GDstate_set_drawable (GDview *, int);
void  GDstate_set_clip_plane_status (GDview *, int, int);
void  GDstate_set_cmap (GDview *, OMobj_id *);
void  GDstate_set_color (GDview *, float *);
void  GDstate_set_highlight_colors (GDview *, float *);
void  GDstate_set_draw_mode (GDview *, int);
void  GDstate_set_line_width (GDview *, int);
void  GDstate_set_line_style (GDview *, int);
void  GDstate_set_line_aa (GDview *, int);
void  GDstate_set_font (GDview *, char *);
void  GDstate_set_depth_cue (GDview *, int);
void  GDstate_set_lights (GDview *);
void  GDstate_set_material (GDview *, float *);
void  GDstate_set_mode (GDview *, int *);
void  GDstate_set_mode_normals (GDview *, int);
void  GDstate_set_mode_outline (GDview *, int);
void  GDstate_set_obj_matrix (GDview *, float [4][4]);
void  GDstate_set_pick (GDview *, GDcamera *, int, int, int);
void  GDstate_set_pick_ray (GDview *);
void  GDstate_set_specular_color (GDview *, float *);
void  GDstate_set_texture (GDview *, GDtexture *, float[4][4]);
void  GDstate_set_transparency (GDview *, float *);
void  GDstate_set_dir_pt_size (GDview *, float *);
void  GDstate_set_subdiv (GDview *, int);
void  GDstate_set_backface_cull (GDview *, int);
void  GDstate_set_jitter (GDview *, int);
void  GDstate_set_vox_interp (GDview *, int);
void  GDstate_set_ray_algo (GDview *, int);
void  GDstate_set_ray_norm (GDview *, int);
void  GDstate_set_blend_mode (GDview *, int);
void  GDstate_set_fat_ray (GDview *, int);
void  GDstate_set_sfp_absorb (GDview *, float *);
void  GDstate_set_sfp_emit (GDview *, float *);
void  GDstate_update_matrix (GDview *);
void  GDstate_set_viewport (GDview *, float *);
void  GDstate_set_stereo_attrs (GDview *, float, float);

/* Defined in gd/cam.c */
void  GDcamera_create (OMobj_id);
int   GDcamera_delete (OMobj_id);
void  GDcamera_reset (OMobj_id);
int   GDcamera_update (OMobj_id);
void  GDcamera_notify_views (GDcamera *);
void  GDcamera_notify_viewlist (GDcamera *);
void  GDcamera_notify_virtpal (GDcamera *);
void  GDcamera_update_camera (GDcamera *);
void  GDcamera_update_depth_cue (GDcamera *);
void  GDcamera_update_objects (GDcamera *);
void  GDcamera_update_xform (GDcamera *);
void  GDcamera_update_viewport (GDcamera *);
void  GDcamera_3d_render1 (GDview *, GDcamera *);
void  GDcamera_3d_render_2d (GDview *, GDcamera *);
void  GDcamera_2d_render1 (GDview *, GDcamera *);
void  GDcamera_3d_render_static (GDview *, GDcamera *);
void  GDcamera_3d_render_dynamic (GDview *, GDcamera *);
void  GDcamera_2d_render_static (GDview *, GDcamera *);
void  GDcamera_2d_render_dynamic (GDview *, GDcamera *);
void  GDcamera_set_attrs (GDview *, GDcamera *, int);
void  GDcamera_pick (GDview *, GDcamera *, int, OMobj_id *, int *, OMobj_id * );
void  GDcamera_pick_reset (GDcamera *);
int   GDcamera_status (GDcamera *, int, int, int, int);
void  GDcamera_clear_status (GDcamera *);
int   GDcamera_is_active (GDcamera *);
void  GDcamera_auto_norm (GDcamera *, int);

void  GDcamera_set_type (OMobj_id, int);
void  GDcamera_get_type (OMobj_id, int *);
void  GDcamera_set_render_mode (OMobj_id, int);
void  GDcamera_get_render_mode (OMobj_id, int *);
void  GDcamera_set_refresh (OMobj_id);
void  GDcamera_set_from (OMobj_id, float *);
void  GDcamera_get_from (OMobj_id, float *);
void  GDcamera_set_up (OMobj_id, float *);
void  GDcamera_get_up (OMobj_id, float *);
void  GDcamera_set_at (OMobj_id, float *);
void  GDcamera_get_at (OMobj_id, float *);
void  GDcamera_set_scale (OMobj_id, float);
void  GDcamera_get_scale (OMobj_id, float *);
void  GDcamera_set_perspec (OMobj_id, int);
void  GDcamera_get_perspec (OMobj_id, int *);
void  GDcamera_set_hither (OMobj_id, int);
void  GDcamera_get_hither (OMobj_id, int *);
void  GDcamera_set_front (OMobj_id, float);
void  GDcamera_get_front (OMobj_id, float *);
void  GDcamera_set_back (OMobj_id, float);
void  GDcamera_get_back (OMobj_id, float *);
void  GDcamera_set_fov (OMobj_id, float);
void  GDcamera_get_fov (OMobj_id, float *);
void  GDcamera_set_wsize (OMobj_id, float);
void  GDcamera_get_wsize (OMobj_id, float *);
void  GDcamera_set_depth_cue (OMobj_id, int);
void  GDcamera_get_depth_cue (OMobj_id, int *);
void  GDcamera_set_depth_front (OMobj_id, float);
void  GDcamera_get_depth_front (OMobj_id, float *);
void  GDcamera_set_depth_back (OMobj_id, float);
void  GDcamera_get_depth_back (OMobj_id, float *);
void  GDcamera_set_depth_scale (OMobj_id, float);
void  GDcamera_get_depth_scale (OMobj_id, float *);
void  GDcamera_set_auto_norm (OMobj_id, int);
void  GDcamera_get_auto_norm (OMobj_id, int *);
void  GDcamera_set_norm_scale (OMobj_id, float);
void  GDcamera_get_norm_scale (OMobj_id, float *);
void  GDcamera_set_norm_invisible (OMobj_id, int);
void  GDcamera_get_norm_invisible (OMobj_id, int *);
void  GDcamera_set_extents (OMobj_id, int);
void  GDcamera_get_extents (OMobj_id, int *);
void  GDcamera_set_mapping (OMobj_id, int);
void  GDcamera_get_mapping (OMobj_id, int *);
int   GDcamera_set_image_pass (OMobj_id, int);
void  GDcamera_get_image_pass (OMobj_id, int *);
int   GDcamera_set_pickable (OMobj_id, int);
void  GDcamera_get_pickable (OMobj_id, int *);
void  GDcamera_set_jitter_scale (OMobj_id, float);
void  GDcamera_get_jitter_scale (OMobj_id, float *);

/* Defined in gd/cam_att.c */
void  GDcamera_attach_object (OMobj_id, OMobj_id, int);
void  GDcamera_detach_objects (OMobj_id);
void  GDcamera_detach_object (OMobj_id, OMobj_id);
void  GDcamera_attach_xform (OMobj_id, OMobj_id, int);
void  GDcamera_detach_xform (OMobj_id, int);
void  GDcamera_detach_views (OMobj_id);

/* Defined in gdif/cam_int.c */
void  GDcamera_set_orient (GDcamera *);
void  GDcamera_set_project (GDcamera *);
void  GDcamera_set_matrix (GDcamera *);
void  GDcamera_get_orient (GDcamera *);
float GDcamera_compute_depth_value (GDcamera *, float);

/* Defined in gd/object.c */
int   GDobject_create (OMobj_id);
int   GDobject_delete (OMobj_id);
int   GDobject_update (OMobj_id);
int   GDobject_data (OMobj_id);
void  GDobject_update_dmap (GDobject *, int);
void  GDobject_update_props (GDobject *, int);
void  GDobject_update_modes (GDobject *, int);
void  GDobject_update_texture (GDobject *, int);
void  GDobject_update_xform (GDobject *, int);
void  GDobject_update_altxform (GDobject *);
void  GDobject_update_txtrxform (GDobject *);
void  GDobject_update_pick_info (GDobject *, int);
void  GDobject_update_object (GDobject *);
void  GDobject_update_children (GDobject *);
void  GDobject_update_altobj (GDobject *);
void  GDobject_update_data (GDobject *);
void  GDobject_notify_views (GDobject *);
void  GDobject_notify_viewlist (GDobject *);
void  GDobject_notify_virtpal (GDobject *);
int   GDobject_status (GDobject *, int, int, int, int, int);
void  GDobject_clear_status (GDobject *);
int   GDobject_is_active (GDobject *);
void  GDobject_auto_norm (GDobject *, int);
void  GDobject_render (GDview *, GDobject *, int);
void  GDobject_draw (GDview *, GDobject *);
int   GDobject_get_render_method (GDobject *);
void  GDobject_set_render_flags (GDobject *);
int   GDobject_pick (GDview *, GDcamera *, GDobject *, int, OMobj_id *, int *, OMobj_id *);
void  GDobject_pick_reset (GDobject *);
void  GDobject_select (GDview *, GDobject *);
void  GDobject_set_rspace (GDobject *, int);
int   GDobject_set_visible (OMobj_id, int);
void  GDobject_get_visible (OMobj_id, int *);
int   GDobject_set_pickable (OMobj_id, int);
void  GDobject_get_pickable (OMobj_id, int *);
int   GDobject_set_www_url (OMobj_id, char *);
void  GDobject_get_www_url (OMobj_id, char **);
int   GDobject_set_www_label (OMobj_id, char *);
void  GDobject_get_www_label (OMobj_id, char **);
int   GDobject_set_cache (OMobj_id, int);
void  GDobject_get_cache (OMobj_id, int *);
int   GDobject_set_type (OMobj_id, int);
void  GDobject_get_type (OMobj_id, int *);
int   GDobject_set_dith_tech (OMobj_id, int);
void  GDobject_get_dith_tech (OMobj_id, int *);
int   GDobject_set_interp_type (OMobj_id, int);
void  GDobject_get_interp_type (OMobj_id, int *);
int   GDobject_set_altobj (OMobj_id, int);
void  GDobject_get_altobj (OMobj_id, int *);
int   GDobject_set_space (OMobj_id, int);
void  GDobject_get_space (OMobj_id, int *);
int   GDobject_set_tmap_method (OMobj_id, int);
void  GDobject_get_tmap_method (OMobj_id, int *);
int   GDobject_set_tri_subdiv_type (OMobj_id, int);
void  GDobject_get_tri_subdiv_type (OMobj_id, int *);
int   GDobject_set_tri_subdiv_aval (OMobj_id, int);
void  GDobject_get_tri_subdiv_aval (OMobj_id, int *);
int   GDobject_set_tri_subdiv_fval (OMobj_id, int);
void  GDobject_get_tri_subdiv_fval (OMobj_id, int *);
int   GDobject_set_missing_val (OMobj_id, float);
void  GDobject_get_missing_val (OMobj_id, float *);
int   GDobject_set_missing_rgb (OMobj_id, float *);
void  GDobject_get_missing_rgb (OMobj_id, float *);
int   GDobject_set_xform_mode (OMobj_id, int);
void  GDobject_get_xform_mode (OMobj_id, int *);
int   GDobject_set_window (OMobj_id, float *);
void  GDobject_get_window (OMobj_id, float *);
int   GDobject_set_surf_conv (OMobj_id, int);
void  GDobject_get_surf_conv (OMobj_id, int *);
int   GDobject_set_surf_chunk (OMobj_id, int);
void  GDobject_get_surf_chunk (OMobj_id, int *);
int   GDobject_set_surf_chunk_size (OMobj_id, int);
void  GDobject_get_surf_chunk_size (OMobj_id, int *);
int   GDobject_set_line_chunk_size (OMobj_id, int);
void  GDobject_get_line_chunk_size (OMobj_id, int *);
int   GDobject_set_active (OMobj_id, int);
int   GDobject_set_cache_size (OMobj_id, int);
void  GDobject_get_cache_size (OMobj_id, int *);
int   GDobject_set_surf_subdiv (OMobj_id, int);
void  GDobject_get_surf_subdiv (OMobj_id, int *);

/* Defined in gd/obj_att.c */
void  GDobject_attach_altobj (OMobj_id, OMobj_id, int);
void  GDobject_detach_altobj (OMobj_id, int);
void  GDobject_detach_cameras (OMobj_id);
void  GDobject_attach_dmap (OMobj_id, OMobj_id, int);
void  GDobject_detach_dmap (OMobj_id, int);
void  GDobject_attach_modes (OMobj_id, OMobj_id, int);
void  GDobject_detach_modes (OMobj_id, int);
void  GDobject_attach_object (OMobj_id, OMobj_id, int);
void  GDobject_detach_children (OMobj_id);
void  GDobject_detach_parents (OMobj_id);
void  GDobject_detach_object (OMobj_id, OMobj_id);
void  GDobject_attach_pick_info (OMobj_id, OMobj_id, int);
void  GDobject_detach_pick_info (OMobj_id, int);
void  GDobject_attach_props (OMobj_id, OMobj_id, int);
void  GDobject_detach_props (OMobj_id, int);
void  GDobject_attach_texture (OMobj_id, OMobj_id, int);
void  GDobject_detach_texture (OMobj_id, int);
void  GDobject_detach_views (OMobj_id);
void  GDobject_attach_xform (OMobj_id, OMobj_id, int);
void  GDobject_detach_xform (OMobj_id, int);
void  GDobject_attach_altxform (OMobj_id, OMobj_id, int);
void  GDobject_detach_altxform (OMobj_id, int);
void  GDobject_attach_txtrxform (OMobj_id, OMobj_id, int);
void  GDobject_detach_txtrxform (OMobj_id, int);

/* Defined in gd/obj_cach.c */
GDcache_header *GDcache_init (void);
GDcache_block *GDcache_new_block (xp_long);
char  *GDcache_malloc (GDobject *, GDstate *, xp_long);
void  GDobject_cache_append (GDobject *, GDgeom_data *, GDstate *, int, OMpfi, int, OMpfi);
void  GDobject_cache_draw (GDview *, GDobject *);
void  GDview_cache_delete (GDview *);
void  GDobject_cache_check (GDview *, GDobject *);
void  GDobject_cache_delete (GDobject *);
void  GDobject_cache_free (GDobject *);
void  GDobject_renderer_cache_free (GDobject *, int);
int   GDcache_ref_inc (GDcache_header *cache);
void  GDcache_ref_dec (GDcache_header *cache);

/* flipbook extensions to cache */
GDcache_header *GDflipbook_cache_init (void);
char *GDflipbook_cache_malloc (GDcache_header *, xp_long);
void  GDflipbook_cache_append  (GDview *, GDcache_header *, GDgeom_data *, int, int);
void  GDflipbook_prim_func_2d_swap (GDview *view, GDcache *cache);
void  GDflipbook_prim_func_3d_swap (GDview *view, GDcache *cache);

GDobject *GDflipbook_get_object (GDview *view, OMobj_id camera_id, OMobj_id obj_id);

void  GDflipbook_object_ext_center (GDobject *obj);
void  GDflipbook_object_ext_norm (OMobj_id, GDobject *, int);
int   GDflipbook_object_get_extent (GDobject *obj, float xform[4][4], float extent[6], int flag);
int   GDflipbook_object_get_extent_world (GDobject *obj, float extent[6], int flag);
/* general flipbook functions */
void  GDview_set_flipbook_mode (GDview *view , int flip_mode);
int   GDview_save_active_objects (GDview *view);
int   GDview_restore_active_objects (GDview *view);
int   GDview_set_flipbook_objects (GDview *view);

/* Defined in gd/gfa.c */
int   GDview_delete_flipbooks(GDview *view);
int   GDview_get_number_of_frames  (GDview *view);
int   GDview_set_flipbook_cPframe (GDview *view, int frame_no);
int   GDview_get_flipbook_cPframe (GDview *view);
int   GDview_get_flipbook_cCframe (GDview *view);
int   GDview_delete_frame(GDview *view, int frame_no);
int   GDview_clear_frames(GDview *view);
int   GDview_replay_frame(GDview *view);
int   GDview_capture_frame(GDview *view, int frameNumber, int force, int copy_cache);

int   GDcamera_set_flipbook_frame (GDcamera *camera, int frame_no);
int   GDcamera_set_flipbook_objects (GDcamera *camera);
int   GDcamera_save_active_objects (GDcamera *camera);
int   GDcamera_restore_active_objects (GDcamera *camera);
int   GDcamera_flipbook_auto_norm (GDcamera *camera, int flag);

void  GDobject_flipbook_render (GDview *view, GDobject *obj, int flag);

int   GDflipbook_remove(GDflipbook *);
void  GDflipbook_dmap_ref_inc(OMobj_id dmap_id);
void  GDflipbook_dmap_ref_dec(OMobj_id dmap_id);

int   ResetUniqueCacheID(int id);
int   ResetUniqueTxtrID(int id);

/* Defined in gd/obj_util.c */
void  GDobject_ext_reset (OMobj_id);
void  GDobject_ext_center (OMobj_id, OMobj_id);
void  GDobject_ext_norm (OMobj_id, OMobj_id, int);
int   GDobject_ext_compute (OMobj_id, OMobj_id, float[6]);
int   GDobject_ext_compute_world (OMobj_id, OMobj_id, float[6]);
int   GDobject_get_parent_xform (OMobj_id, OMobj_id *, OMobj_id *);
void  GDobject_get_rotation (OMobj_id, float [4][4]);
int   GDobject_get_transform (OMobj_id, float [4][4], int);
int   GDobject_get_extent (GDobject *, float [4][4], float [6], int, int);
int   GDobject_get_extent_world (GDobject *, float [6], int, int);

/* Defined in gd/gd_init.c */
void  GDinit (int *, char **);
int   GDinit_hardware_renderer (void);

/* Defined in gd/output.c */
int   GDfield_output_create (OMobj_id);
int   GDfield_output_delete (OMobj_id);
int   GDfield_output_update (OMobj_id);
int   GDfile_output_create (OMobj_id);
int   GDfile_output_delete (OMobj_id);
int   GDfile_output_update (OMobj_id);
void  GDoutput_init (GDview *);
void  GDoutput_flush (GDview *);
void  GDfield_output_write (xp_long *, char *, char *, GDoutput *);
void  GDfile_output_write (xp_long *, char *, char *, GDoutput *);
void  GDoutput_done (GDview *);

/* Defined in gd/roi.c */
int   GDroi2d_cont_create (OMobj_id);
int   GDroi2d_cont_delete (OMobj_id);
int   GDroi2d_cont_update (OMobj_id);
int   GDroi2d_click_create (OMobj_id);
int   GDroi2d_click_delete (OMobj_id);
int   GDroi2d_click_update (OMobj_id);
int   GDdraw2d_cursor_create (OMobj_id);
int   GDdraw2d_cursor_delete (OMobj_id);
int   GDdraw2d_cursor_update (OMobj_id);
int   GDmap2d_ss_update (OMobj_id);
int   GDedit_mesh_create (OMobj_id);
int   GDedit_mesh_delete (OMobj_id);
int   GDedit_mesh_update (OMobj_id);
void  GDmap_ss_to_2dworld (GDcamera *, float *, xp_long, short *, float *);
void  GDmap_ss_to_3dworld (GDcamera *, float *, xp_long, short *, float *, float *, int);
void  GDmap_get_matrix (GDview *, GDcamera *, GDobject *, float *, int);
int   GDmap2d_obj_concat (GDview *, GDobject *, GDobject *, float *, int);
void  UTILclear_mesh (OMobj_id);

/* Defined in gd/roi_conv.c */
int   GDvector2raster_update (OMobj_id);

/* Defined in gd/mesh.c */
void  GDdraw_mesh_unif (GDobject *, GDstate *);
void  GDdraw_mesh_rect (GDobject *, GDstate *);
void  GDdraw_mesh (GDobject *, GDstate *);
void  GDdraw_volume (GDobject *, GDstate *);
void  GDpick_mesh (GDobject *, GDstate *);
void  GDpick_mesh_unif (GDobject *, GDstate *);
void  GDpick_volume (GDobject *, GDstate *);

/* Defined in gd/mesh_arr.c */
void  GDdraw_mesh_array (GDobject *, GDstate *);
void  GDpick_mesh_array (GDobject *, GDstate *);
void  GDdraw_volume_tiled (GDobject *, GDstate *);
void  GDpick_volume_tiled (GDobject *, GDstate *);

/* Defined in gd/minmax.c */
int   GDminmax_update (OMobj_id);
int   GDvol_minmax_update (OMobj_id);
void  GDminmax_set_values (OMobj_id, double, double);

/* Defined in gd/polyh.c */
void  GDdraw_polyh (GDobject *, GDstate *);
void  GDpick_polyh (GDobject *, GDstate *);
void  GDpolyh_size_check (GDobject *, GDstate *, GDgeom_data *);

/* Defined in cell_3d.c */
int   GDextract_2d_cells (OMobj_id, OMobj_id, OMobj_id, int, int, int *);
int   GDpick_3d_cells( GDobject *, OMobj_id, GDgeom_data *, GDstate * );

/* Defined in gd/struct_3d.c */
void  GDdraw_struct_3d (GDobject *, GDstate *);
void  GDpick_struct_3d (GDobject *, GDstate *);

/* Defined in gd/cells.c */
void  GDdraw_point_cells (GDobject *, OMobj_id, GDgeom_data *, GDstate *);
void  GDdraw_line_cells (GDobject *, OMobj_id, GDgeom_data *, GDstate *);
void  GDdraw_polyline_cells (GDobject *, OMobj_id, GDgeom_data *, GDstate *);
void  GDdraw_polytri_cells (GDobject *, OMobj_id, GDgeom_data *, GDstate *);
void  GDdraw_tri_cells (GDobject *, OMobj_id, GDgeom_data *, GDstate *);
void  GDdraw_quad_cells (GDobject *, OMobj_id, GDgeom_data *, GDstate *);
void  GDdraw_polyh_cells (GDobject *, OMobj_id, GDgeom_data *, GDstate *);
void  GDrender_surf  (GDobject *, GDgeom_data *, GDstate *, int, xp_long, xp_long *, xp_long *, int);
void  GDpolyh_gen_norms (int, xp_long, xp_long *, xp_long, float *, int, float **, int);
void  GDrender_lines_pts (GDobject *, GDgeom_data *, GDstate *, int, xp_long, xp_long *, int *, int);

int   GDpick_point_cells (GDobject *, OMobj_id, GDgeom_data *, GDstate *);
int   GDpick_line_cells (GDobject *, OMobj_id, GDgeom_data *, GDstate *);
int   GDpick_polyline_cells (GDobject *, OMobj_id, GDgeom_data *, GDstate *);
int   GDpick_polytri_cells (GDobject *, OMobj_id, GDgeom_data *, GDstate *);
int   GDpick_tri_cells (GDobject *, OMobj_id, GDgeom_data *, GDstate *);
int   GDpick_quad_cells (GDobject *, OMobj_id, GDgeom_data *, GDstate *);
int   GDpick_polyh_cells (GDobject *, OMobj_id, GDgeom_data *, GDstate *);

/* Defined in gd/cells2.c */
void  GDdraw_line2_cells (GDobject *, OMobj_id, GDgeom_data *, GDstate *);
int   GDpick_line2_cells (GDobject *, OMobj_id, GDgeom_data *, GDstate *);
void  GDdraw_tri2_cells (GDobject *, OMobj_id, GDgeom_data *, GDstate *);
int   GDpick_tri2_cells (GDobject *, OMobj_id, GDgeom_data *, GDstate *);
void  GDdraw_quad2_cells (GDobject *, OMobj_id, GDgeom_data *, GDstate *);
int   GDpick_quad2_cells (GDobject *, OMobj_id, GDgeom_data *, GDstate *);

/* Defined in gd/quads.c */
void  GDtesselate_quad_cells (GDobject *, OMobj_id, GDgeom_data *, GDstate *);
void  GDquad_init_shapes (GDstate *);
void  GDquad_free_shapes (GDstate *);

/* Defined in gd/gr_surf.c */
void  GDgraph_cvt (int, xp_long, xp_long *, xp_long **, xp_long **);
void  GDgraph_cvt_thorough (int, xp_long, xp_long *, xp_long **, xp_long **);

/* Defined in gd/gr_wire.c */
int   GDgraph_cvt_wire (int, xp_long, xp_long[], int[], xp_long **, xp_long **);

/* Defined in gd/text.c */
void  GDdraw_text (GDobject *, GDstate *);
void  GDpick_text (GDobject *, GDstate *);
void  GDdraw_text_array (GDobject *, GDstate *);
void  GDpick_text_array (GDobject *, GDstate *);
void  GDdraw_stroke_text (GDobject *, GDstate *);
void  GDpick_stroke_text (GDobject *, GDstate *);
void  GDdraw_stroke_text_array (GDobject *, GDstate *);
void  GDpick_stroke_text_array (GDobject *, GDstate *);
int   GDtext_stroke_get_extents (GDobject *, GDtext **, GDstrokeText **, GDgeom_data *, int, int);

/* Defined in gd/pick.c */
void  GDpick_points (GDgeom_data *, GDstate *);
void  GDpick_spheres (GDgeom_data *, GDstate *);
void  GDpick_lines (GDgeom_data *, GDstate *);
void  GDpick_polyline (GDgeom_data *, GDstate *);
void  GDpick_wiretris (GDgeom_data *, GDstate *);
void  GDpick_wirequads (GDgeom_data *, GDstate *);
void  GDpick_polytri (GDgeom_data *, GDstate *);
void  GDpick_tris (GDgeom_data *, GDstate *);
void  GDpick_quads (GDgeom_data *, GDstate *);
void  GDpick_polygon (GDgeom_data *, GDstate *);
void  GDpick_2dimage (GDgeom_data *, GDstate *);

/* Defined in gd/view_ed.c */
int   GDview_edit_update (OMobj_id, OMevent_mask, int);

/* Defined in gd/view_sel.c */
int   GDview_selector_update (OMobj_id, OMevent_mask, int);
int   GDview_creator_create (OMobj_id, OMevent_mask, int);
int   GDview_creator_destroy (OMobj_id, OMevent_mask, int);
int   GDview_creator_view_update (OMobj_id, OMevent_mask, int);

/* Defined in gd/obj_sel.c */
int   GDobj_sel_create (OMobj_id);
int   GDobj_sel_delete (OMobj_id);
int   GDobj_sel_update (OMobj_id);
void  GDobj_get_obj_name (OMobj_id, char *, int);

/* Defined in gd/obj_ed.c */
int   GDobj_edit_update (OMobj_id, OMevent_mask, int);

/* Defined in gd/cam_ed.c */
int   GDcamera_edit_update (OMobj_id, OMevent_mask, int);

/* Defined in gd/linfo_ed.c */
int   GDlinfo_edit_update (OMobj_id, OMevent_mask, int);

/* Defined in gd/light_ed.c */
int   GDlight_edit_update (OMobj_id, OMevent_mask, int);

/* Defined in gd/modes_ed.c */
int   GDmodes_edit_update (OMobj_id, OMevent_mask, int);

/* Defined in gd/props_ed.c */
int   GDprops_edit_update (OMobj_id, OMevent_mask, int);

/* Defined in gd/txtr_ed.c */
int   GDtexture_edit_update (OMobj_id, OMevent_mask, int);

/* Defined in gd/track_ed.c */
int   GDtrack_edit_create (OMobj_id);
int   GDtrack_edit_delete (OMobj_id);
int   GDtrack_edit_update (OMobj_id);
int   GDtrack_xlate (GDtrack_edit *, int, int, int, int, float[4][4], float[3]);
int   GDtrack_zlate (GDtrack_edit *, int, int, int, int, float[4][4], float[3]);
int   GDtrack_begin (GDtrack_edit *, OMobj_id, OMobj_id, OMobj_id, OMobj_id, int, int, int, int);
int   GDtrack_scale (GDtrack_edit *, int, int, int, int, float[4][4], float[3]);
int   GDtrack_rotate (GDtrack_edit *, int, int, int, int, float[4][4], float[3]);
void  GDtrack_set_timer (int);
void  GDtrack_stop_roll (void);
int   GDtrack_rolling (void);

/* Defined in gd/xform_ed.c */
int   GDxform_edit_update (OMobj_id, OMevent_mask, int);
void  GDxform_get_SR (float[4][4], int *, float[3], int *, float[3]);

/* Defined in gd/x_winfo.c and gd/nt_winfo.c */
#ifndef MSDOS
int   GDwinfo_window_changed (GDview *);
#endif
int   GDwinfo_window_valid (GDview *);
int   GDwinfo_get_event (GDview *, int *);
int   GDwinfo_create (GDview *);
void  GDwinfo_delete (GDview *);
void  GDwinfo_update_size (GDview *);

/* Defined in gd/dpy_img.c */
int   GDdisplay_image (OMobj_id);

/*****************************************************/
/*              GDIF Functions                     */
/*****************************************************/

/* Defined in gdif/om_util.c */
OMobj_id GDcreate_instance (OMobj_id, const char *, const char *);
void  GDset_local (OMobj_id, char *);
void  GDclear_local (OMobj_id);
char * GDget_local (OMobj_id, OMpfi);
void  GDset_refer_db (OMobj_id, const char *, OMobj_id);
int   GDget_refer_db (OMobj_id, const char *, OMobj_id *);
int   GDget_refer_db2 (OMobj_id, const char *, OMobj_id *);
int   GDget_seqref_db (OMobj_id, const char *, int, int *, OMobj_id *);
int   GDget_obj_seq (OMobj_id, const char *, int *, int);
void  GDset_int_val (OMobj_id, const char *, int);
int   GDget_int_val (OMobj_id, const char *, int *);
void  GDset_newint_val (OMobj_id, const char *, int *, int);
int   GDget_newint_val (OMobj_id, const char *, int *, int *);
int   GDget_updint_val (OMobj_id, const char *, int, int *);
void  GDset_long_val (OMobj_id, const char *, xp_long);
int   GDget_long_val (OMobj_id, const char *, xp_long *);
void  GDset_newlong_val (OMobj_id, const char *, int *, xp_long);
int   GDget_newlong_val (OMobj_id, const char *, int *, xp_long *);
int   GDget_updlong_val (OMobj_id, const char *, int, xp_long *);
int   GDget_updstr_val (OMobj_id, const char *, int, char **);
void  GDset_float_val (OMobj_id, const char *, float);
int   GDget_float_val (OMobj_id, const char *, float *);
void  GDset_newfloat_val (OMobj_id, const char *, int *, float);
int   GDget_newfloat_val (OMobj_id, const char *, int *, float *);
int   GDget_updfloat_val (OMobj_id, const char *, int, float *);
void  GDset_int_array (OMobj_id, const char *, xp_long, int *);
int   GDget_newint_array (OMobj_id, const char *, int *, xp_long *, int **);
int   GDget_updint_array (OMobj_id, const char *, int, xp_long *, int **);
int   GDget_int_array (OMobj_id, const char *, xp_long *, int **);
#ifdef WORDLENGTH_64
int   GDget_newint_array_n (OMobj_id, const char *, int *, int *, int **);
int   GDget_updint_array_n (OMobj_id, const char *, int, int *, int **);
int   GDget_int_array_n (OMobj_id, const char *, int *, int **);
#endif
void  GDset_long_array (OMobj_id, const char *, xp_long, xp_long *);
int   GDget_newlong_array (OMobj_id, const char *, int *, xp_long *, xp_long **);
int   GDget_updlong_array (OMobj_id, const char *, int, xp_long *, xp_long **);
int   GDget_long_array (OMobj_id, const char *, xp_long *, xp_long **);
void  GDset_float_array (OMobj_id, const char *, xp_long, float *);
int   GDget_newfloat_array (OMobj_id, const char *, int *, xp_long *, float **);
int   GDget_updfloat_array (OMobj_id, const char *, int, xp_long *, float **);
int   GDget_float_array (OMobj_id, const char *, xp_long *, float **);
#ifdef WORDLENGTH_64
int   GDget_newfloat_array_n (OMobj_id, const char *, int *, int *, float **);
int   GDget_updfloat_array_n (OMobj_id, const char *, int, int *, float **);
int   GDget_float_array_n (OMobj_id, const char *, int *, float **);
#endif
int   GDget_str_val (OMobj_id, const char *, char **);
void  GDset_newstr_val (OMobj_id, const char *, int *, char *);
int   GDget_newstr_val (OMobj_id, const char *, int *, char **);

/* Defined in gdif/lt_info.c */
int   GDlight_info_create (OMobj_id);
int   GDlight_info_delete (OMobj_id);
int   GDlight_info_update (OMobj_id);
void  GDlight_info_reset (OMobj_id);
void  GDlight_info_update_lights (GDlight_info *);
void  GDlight_info_attach_light (OMobj_id, OMobj_id, int);
void  GDlight_info_detach_light (OMobj_id, OMobj_id, int);
void  GDlight_info_set_show (OMobj_id, int);
void  GDlight_info_get_show (OMobj_id, int *);
void  GDlight_info_set_amb_state (OMobj_id, int);
void  GDlight_info_get_amb_state (OMobj_id, int *);
void  GDlight_info_set_amb_color (OMobj_id, float *);
void  GDlight_info_get_amb_color (OMobj_id, float *);

/* Defined in gdif/light.c */
int   GDlight_create (OMobj_id);
int   GDlight_delete (OMobj_id);
int   GDlight_update (OMobj_id);
void  GDlight_update_xform (GDlight *);
void  GDlight_attach_xform (OMobj_id, OMobj_id, int);
void  GDlight_detach_xform (OMobj_id, int);
void  GDlight_reset (OMobj_id);
void  GDlight_set_type (OMobj_id, int);
void  GDlight_get_type (OMobj_id, int *);
void  GDlight_set_state (OMobj_id, int);
void  GDlight_get_state (OMobj_id, int *);
void  GDlight_set_color (OMobj_id, float *);
void  GDlight_get_color (OMobj_id, float *);
void  GDlight_set_att (OMobj_id, float *);
void  GDlight_get_att (OMobj_id, float *);
void  GDlight_set_concen (OMobj_id, float);
void  GDlight_get_concen (OMobj_id, float *);
void  GDlight_set_angle (OMobj_id, float);
void  GDlight_get_angle (OMobj_id, float *);

/* Defined in gdif/pickctrl.c */
void  GDpick_ctrl_create (OMobj_id);
void  GDpick_ctrl_reset (OMobj_id);
void  GDpick_ctrl_set_mode (OMobj_id, int);
void  GDpick_ctrl_get_mode (OMobj_id, int *);
void  GDpick_ctrl_get_on_start (OMobj_id, int *);
void  GDpick_ctrl_get_xy (OMobj_id, int *, int *);
void  GDpick_ctrl_get_event (OMobj_id, int *);

/* Defined in gdif/modes.c */
void  GDmodes_ref_set(GDmodes *modes);
void  GDmodes_ref_inc(GDmodes *modes);
void  GDmodes_ref_dec(GDmodes *modes);
int   GDmodes_create (OMobj_id);
int   GDmodes_delete (OMobj_id);
void  GDmodes_reset (OMobj_id);
int   GDmodes_update (OMobj_id);
void  GDmodes_set_points (OMobj_id, int);
void  GDmodes_set_lines (OMobj_id, int);
void  GDmodes_set_surf (OMobj_id, int);
void  GDmodes_set_volume (OMobj_id, int);
void  GDmodes_set_bounds (OMobj_id, int);
void  GDmodes_get_mode (OMobj_id, int *);
void  GDmodes_set_normals (OMobj_id, int);
void  GDmodes_get_normals (OMobj_id, int *);
void  GDmodes_set_colors (OMobj_id, int);
void  GDmodes_get_colors (OMobj_id, int *);
void  GDmodes_set_outline (OMobj_id, int);
void  GDmodes_get_outline(OMobj_id, int *);

/* Defined in gdif/props.c */
void  GDprops_ref_set(GDprops *props);
void  GDprops_ref_inc(GDprops *props);
void  GDprops_ref_dec(GDprops *props);
int   GDprops_create (OMobj_id);
int   GDprops_delete (OMobj_id);
void  GDprops_reset (OMobj_id);
int   GDprops_update (OMobj_id);
void  GDprops_set_font (OMobj_id, char *);
void  GDprops_set_color (OMobj_id, float *);
void  GDprops_get_color (OMobj_id, float *);
void  GDprops_set_hi1_col (OMobj_id, float *);
void  GDprops_get_hi1_col (OMobj_id, float *);
void  GDprops_set_hi2_col (OMobj_id, float *);
void  GDprops_get_hi2_col (OMobj_id, float *);
void  GDprops_set_material (OMobj_id, float *);
void  GDprops_get_material (OMobj_id, float *);
void  GDprops_set_specular_color (OMobj_id, float *);
void  GDprops_get_specular_color (OMobj_id, float *);
void  GDprops_set_transparency (OMobj_id, float);
void  GDprops_get_transparency (OMobj_id, float *);
void  GDprops_set_draw_mode (OMobj_id, int);
void  GDprops_get_draw_mode (OMobj_id, int *);
void  GDprops_set_line_width (OMobj_id, int);
void  GDprops_get_line_width (OMobj_id, int *);
void  GDprops_set_line_style (OMobj_id, int);
void  GDprops_get_line_style (OMobj_id, int *);
void  GDprops_set_line_aa (OMobj_id, int);
void  GDprops_get_line_aa (OMobj_id, int *);
void  GDprops_set_inherit (OMobj_id, int);
void  GDprops_get_inherit (OMobj_id, int *);
void  GDprops_set_dir_pt_size (OMobj_id, float);
void  GDprops_get_dir_pt_size (OMobj_id, float *);
void  GDprops_set_subdiv (OMobj_id, int);
void  GDprops_get_subdiv (OMobj_id, int *);
void  GDprops_set_jitter (OMobj_id, int);
void  GDprops_get_jitter (OMobj_id, int *);
void  GDprops_set_cull (OMobj_id, int);
void  GDprops_get_cull (OMobj_id, int *);
void  GDprops_set_vox_interp (OMobj_id, int);
void  GDprops_get_vox_interp (OMobj_id, int *);
void  GDprops_set_ray_algo (OMobj_id, int);
void  GDprops_get_ray_algo (OMobj_id, int *);
void  GDprops_set_ray_norm (OMobj_id, int);
void  GDprops_get_ray_norm (OMobj_id, int *);
void  GDprops_set_fat_ray (OMobj_id, int);
void  GDprops_get_fat_ray (OMobj_id, int *);
void  GDprops_set_sfp_absorb (OMobj_id, float);
void  GDprops_get_sfp_absorb (OMobj_id, float *);
void  GDprops_set_sfp_emit (OMobj_id, float);
void  GDprops_get_sfp_emit (OMobj_id, float *);

/* Defined in gdif/texture.c */
void  GDtexture_ref_inc (GDtexture *texture);
void  GDtexture_ref_dec (GDtexture *texture);
int   GDtexture_create (OMobj_id);
void  GDtexture_free_data (GDtexture *);
void  GDtexture_free_colormap (GDtexture *);
void  GDtexture_free (GDtexture *);
int   GDtexture_delete (OMobj_id);
void  GDtexture_reset (OMobj_id);
int   GDtexture_update (OMobj_id);
int   GDtexture_get_data (GDtexture *);
int   GDtexture_get_colormap (GDtexture *);
void  GDtexture_update_data (GDtexture *);
void  GDtexture_update_colormap (GDtexture *);
void  GDtexture_set_tile (OMobj_id, int);
void  GDtexture_get_tile (OMobj_id, int *);
void  GDtexture_set_alpha (OMobj_id, int);
void  GDtexture_get_alpha (OMobj_id, int *);
void  GDtexture_set_filter (OMobj_id, int);
void  GDtexture_get_filter (OMobj_id, int *);
void  GDtexture_set_type (OMobj_id, int);
void  GDtexture_get_type (OMobj_id, int *);
void  GDtexture_set_stage (OMobj_id, int);
void  GDtexture_get_stage (OMobj_id, int *);

/* Defined in gdif/xform.c */
void  GDxform_ref_inc(GDxform *xform);
void  GDxform_ref_dec(GDxform *xform);
void  GDxform_ref_set(GDxform *xform);
GDxform *GDxform_alloc (OMobj_id);
void  GDxform_reset (OMobj_id);
void  GDxform_update (OMobj_id, GDxform *);
void  GDxform_set_matrix (OMobj_id, float [4][4]);
void  GDxform_concat_matrix (OMobj_id, float [4][4]);
void  GDxform_get_matrix (OMobj_id, float *);
void  GDxform_get_comp_matrix (OMobj_id, float *);
void  GDxform_set_xlate (OMobj_id, float [3]);
void  GDxform_concat_xlate (OMobj_id, float [3]);
void  GDxform_get_xlate (OMobj_id, float *);
void  GDxform_set_center (OMobj_id, float [3]);
void  GDxform_concat_center (OMobj_id, float [3]);
void  GDxform_get_center (OMobj_id, float *);

/* Defined in gdif/pickinfo.c */
int   GDpick_info_create (OMobj_id);
int   GDpick_info_delete (OMobj_id);
void  GDpick_info_reset (OMobj_id);
void  GDpick_info_add_pick_data (GDstate *);
void  GDpick_info_set_matricies (GDstate *, float [4][4]);
void  GDpick_info_set_ids (GDstate *, GDpick_data *, OMobj_id, OMobj_id);
int   GDpick_info_update (GDobject *, GDstate *, GDpick_info *, int, OMobj_id *);
void  GDpick_info_set_objxform (OMobj_id, float [4][4]);
void  GDpick_info_get_objxform (OMobj_id, float *);
void  GDpick_info_set_topxform (OMobj_id, float [4][4]);
void  GDpick_info_get_topxform (OMobj_id, float *);
void  GDpick_info_set_viewxform (OMobj_id, float [4][4]);
void  GDpick_info_get_viewxform (OMobj_id, float *);
void  GDpick_info_set_selected (OMobj_id, int);
void  GDpick_info_get_selected (OMobj_id, int *);
void  GDpick_info_set_npicked (OMobj_id, int);
void  GDpick_info_get_npicked (OMobj_id, int *);
void  GDpick_info_set_pickdata (OMobj_id, int, GDpick_data *);
void  GDpick_info_get_pickdata (OMobj_id, int, GDpick_data *);
void  GDpick_info_set_pickpath (OMobj_id, int, OMobj_id *);
void  GDpick_info_set_toppath (OMobj_id, OMobj_id, OMobj_id, OMobj_id);
void  GDpick_info_get_pickpath (OMobj_id, int *, OMobj_id *);

/* Defined in gdif/track.c */
int   GDtrack_begin ( GDtrack_edit*, OMobj_id, OMobj_id, OMobj_id,
                      OMobj_id, int, int, int, int);
int   GDtrack_xlate ( GDtrack_edit*,
                      int, int, int, int, float [4][4], float [3]);
int   GDtrack_zlate ( GDtrack_edit*,
                      int, int, int, int, float [4][4], float [3]);
int   GDtrack_scale ( GDtrack_edit*,
                      int, int, int, int, float [4][4], float [3]);
int   GDtrack_rotate ( GDtrack_edit*,
                       int, int, int, int, float[4][4], float [3]);

#if defined(WORDLENGTH_64) && !defined(XP_WIDE_API)
   #define	GDget_newint_array            GDget_newint_array_n
   #define	GDget_updint_array            GDget_updint_array_n
   #define	GDget_int_array               GDget_int_array_n
   #define	GDget_newfloat_array          GDget_newfloat_array_n
   #define	GDget_updfloat_array          GDget_updfloat_array_n
   #define	GDget_float_array             GDget_float_array_n
#endif

#ifdef __cplusplus
}	/* extern "C" */
#endif

#endif	/* XP_GD_INCLUDED */
