/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/gmod.h#1 $
*/
#ifndef GMOD_INCLUDED
#define GMOD_INCLUDED
#include <avs/strmio.h>
#include <avs/om.h>

typedef struct _TimerStruct {
    int 	Active;
    int 	TimeStep;
    float	Val;
    float	ValStep;

    int		WasActive;
#if 1
    int		OldTimeStep;
#else /* MSDOS */
    int		Timer;
    struct _TimerStruct *Next;
#endif
} TimerStruct;

typedef struct _OMjournal {
   int start_recording;
   int playback;
   int record;
   int stop;
   char *playback_filename;
   char *record_filename;
   IOstream *stream;
   OMobj_id elem_id;
   OMobj_id hndlr_elem;
   int hndlr_active;
} OMjournal;

typedef struct _LoopStruct {
   int  reset;
   int  reset_back;
   int  run;
   int  run_back;
   int  step;
   int  step_back;
   int  cycle;
   int  done;
   double  start_val;
   double  end_val;
   double  incr;
   double  count;
   int  is_active;
   int  set;
   int  direction;
} LoopStruct;

typedef struct _FileStruct {
   char  *name;
   FILE  *fptr;
   int   status;
   int   cur_offset;
} FileStruct;

#endif

