/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/heap.h#1 $
*/
#ifndef XP_HEAP_INCLUDED
#define XP_HEAP_INCLUDED

#include <avs/dtx.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _HPheap {
    int heap_id;		/* the index of this heap in the file's heap
				   list.  This will be stored in the process
				   id structure for the object */
    xp_long size_used;
    xp_long size_alloced;
    char *heap_ptr;
    xp_long vol_byte_size;
    int vol_num_ptrs;
    int align;
    unsigned int fixed_size:1;
} HPheap;

typedef struct _HPheader {
   DTlong size_used;
   DTlong vol_byte_size;
   DTint vol_num_ptrs;
} HPheader;

#define HPptr(H,O)  \
   (H->size_used > O ? H->heap_ptr + O : HPerror(__FILE__,__LINE__) )

#define HEAP_BLOCK_SIZE 16384

#define HPalign(nbytes,asize) \
	((nbytes) + ((asize - ((nbytes) % asize)) % asize))

/* volatile storage is always aligned to 8 byte boundaries */
#define HP_VOL_ALIGN	8

#define HPvcreate(SIZE)	HPcreate(SIZE,HP_VOL_ALIGN)

char   * HPerror           (const char *file, int line);
xp_long  HPalloc           (HPheap *heap, xp_long size);
xp_long  HPzero_alloc      (HPheap *heap, xp_long size);
char   * HPptr_alloc       (HPheap *heap, xp_long size);
char   * HPvptr_alloc      (HPheap *heap, xp_long size, int *alloced_in_heap);
xp_long  HPvalloc          (HPheap *heap, xp_long size,
                            xp_long vol_size, int vol_nptrs);
void     HPdestroy         (HPheap *heap);
HPheap * HPcreate          (xp_long min_size, int align);
HPheap * HPmem_create      (char *ptr, int align);
xp_long  HPinsert_heap     (HPheap *dst_heap, HPheap *src_heap);
HPheap * HPdefine_sub_heap (HPheap *parent_heap, xp_long offset);
int      HPwrite           (HPheap *heap, FILE *fp);
HPheap * HPread            (FILE *fp, int align);
HPheap * HPread_fd         (int fd, int align);
int      HPwrite_c_heap    (FILE *fp, const char *name, HPheap *heap);
HPheap * HPdefine_heap     (xp_long size, xp_long vol_byte_size,
			    int vol_num_ptrs, int align, char *ptr);

#ifdef __cplusplus
} /* extern "C" */
#endif

#endif
