/*

                        Copyright (c) 1994 by
                        Advanced Visual Systems Inc.
                        All Rights Reserved

        This software comprises unpublished confidential information of
        Advanced Visual Systems Inc. and may not be used, copied or made
        available to anyone, except in accordance with the license
        under which it is furnished.

        This file is under Perforce control
        $Id: //depot/express/fcs70/include/avs/locale.h#1 $
*/

/*---------------------------------------------------------------------*
 *
 *  Locale and language header
 *
 *---------------------------------------------------------------------*/

#ifndef XP_LOCALE_INCLUDED
#define XP_LOCALE_INCLUDED

/*---------------------------------------------------------------------*/

#include <avs/port.h>
#include <avs/kanji.h>

/*---------------------------------------------------------------------*/
/*                         Type definitions                            */
/*---------------------------------------------------------------------*/

/* character set format */

typedef enum
{
  LOC_SBCS,
  LOC_MBCS
} LocaleCSet;

/* locale language */

typedef enum
{
  XP_LANG_W_EUROPE,  /* ISO8859-1, C, English, French.. */
  XP_LANG_E_EUROPE,  /* ISO8859-2, Czech, Hungarian..   */
  XP_LANG_CYRILLIC,  /* ISO8859-5, Russian & Bulgarian  */
  XP_LANG_ARABIC,    /* ISO8859-6, Arabic               */
  XP_LANG_GREECE,    /* ISO8859-7, Greek                */
  XP_LANG_HEBREW,    /* ISO8859-8, Hebrew               */
  XP_LANG_TURKEY,    /* ISO8859-9, Turkish              */

  XP_LANG_JAPAN,     /* kanas and kanji                 */
  XP_LANG_KOREA,     /* hangul and hanja                */
  XP_LANG_CHINA,     /* simplified characters           */
  XP_LANG_TAIWAN     /* traditional characters          */

} LocaleLang;

#define XP_LANG_DEFAULT XP_LANG_W_EUROPE

/* format for composing lists of font names */

typedef enum
{
  LOC_SEP_XFS,     /* XCreateFontSet with commas           */
  LOC_SEP_XRM      /* XmFontList resource with semi-colons */
} LocaleSep;

/* charsets are different types for Motif and NT */

#ifdef MSDOS
typedef int     LocaleCharset;
#else
typedef const char *  LocaleCharset;
#endif

/*---------------------------------------------------------------------*/
/*                      Locale info structure                          */
/*---------------------------------------------------------------------*/

/*
 * 'font family' info is handled differently for X/Motif and NT
 *
 * X/Motif uses the foundry and family name, separated by a hyphen,
 * plus a charset string that includes the registry and encoding,
 * separated by a hyphen
 *
 * NT uses the family name, e.g. "helvetica",
 * and also has a charset enum for the font
 *
 */

typedef struct _LocaleFontFamilyList  LocaleFontFamilyList;

struct _LocaleFontFamilyList
{
  int            tag;              /* unique identifier for the font */
  const char     **font_families;  /* partial font descriptions      */
  LocaleCharset  *charsets;        /* array of charsets, ids or tags */
  int            nfonts;           /* number of font families        */
  struct _LocaleFontFamilyList  *next;
};

typedef struct
{
  const char            *name;      /* text description of the locale */
  LocaleLang            lang;       /* kanji language flag            */
  LocaleCSet            cset;       /* character set category         */
  const char            *locale;    /* XPG-style locale name          */
  const char            **aliases;  /* alternative locale names       */
  int                   nalias;     /* number of locale aliases       */
  LocaleFontFamilyList  *fontLL;    /* list of font family lists      */
  int                   fontHeight; /* default font height            */
} LocaleInfo;

/* For the LOCALEadd_font_families API function */

typedef struct
{
  char           *font_family;
  LocaleCharset  charset;
} LocaleFontFamily;

/*---------------------------------------------------------------------*/
/*                      Function prototypes                            */
/*---------------------------------------------------------------------*/

#ifdef __cplusplus
extern "C" {
#endif

void          LOCALEinit          ( const char * );
void          LOCALEset_locale    ( const char *, const char * );
const char *  LOCALEget_locale    ( void );
void          LOCALEset_encoding  ( const char * );
KanjiEncoding LOCALEget_encoding  ( void );
LocaleCSet    LOCALEget_cset      ( void );
const char *  LOCALEget_name      ( void );
  LocaleLang    LOCALEget_lang      ( void );
void          LOCALEget_fonts_arr ( int, int *, const char ***,
                                    LocaleCharset** );
char *        LOCALEget_fonts_str ( int, LocaleSep, const char * );
void          LOCALEadd_font_families ( int, LocaleFontFamily*, int );
int           LOCALEget_font_height ( void );

#ifdef __cplusplus
}
#endif

/*---------------------------------------------------------------------*/

#endif /* XP_LOCALE_INCLUDED */
