/*
			Copyright (c) 1993 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/mat.h#1 $
*/

/* mat.h - Prototypes for mat.c */

#ifndef MAT_H
#define MAT_H

#include <avs/port.h> /* 64-bit porting. Included for 'xp_long' definition */

#ifdef __cplusplus
extern "C" {
#endif

/* use the following type for casting float* to parameters of type 
 * float [][4] or float [][3] or float [][2]
 * it is done like (Matr4 *)
 */
typedef float Matr4[4];
typedef float Matr3[3];
typedef float Matr2[2];

extern void
MATmat4_rotate(
    float result_mat[4][4],
    float axis_x,
    float axis_y, 
    float axis_z, 
    float angle_in_radians);

extern void
MATvec3_length(
    double *res,	/* length retured in this pointer */
    float *vec);

extern void
MATvec3_normalize(
    float *vec);

extern void
MATvec3_cross_prod(
    float *res,
    float *vec1, 
    float *vec2);

extern void
MATmat4_identity(
    float m[4][4]);

extern int
MATmat_is_identity(
    float *m,
    int   dim);

extern int
MATmat4_xform_dim(
    float *m,
    int   *dim);

extern void
MATmat4_copy(
    float res[4][4], 
    float src[4][4]);

extern void
MATmat4_x_rotate(
    float rotx,
    float m[4][4]);

extern void
MATmat4_y_rotate(
    float roty, 
    float m[4][4]);

extern void
MATmat4_z_rotate(
    float rotz,
    float m[4][4]);

extern void
MATmat4_translate(
    float m[4][4],
    float x, 
    float y, 
    float z);

extern void
MATmat4_scale(
    float m[4][4],
    float x,
    float y, 
    float z);

extern void
MATvec3_add(
    float res[3], 
    float vec1[3], 
    float vec2[3]);

/* res = vec1 - vec2 */
extern void
MATvec3_sub(
	float res[3], 
    float vec1[3], 
    float vec2[3]);

extern void
MATvec3_copy(
    float res[3], 
    float vec[3]);

extern void
MATvec3_mat4_multiply(
    float v[3],
    float m[4][4]);

extern int
MATmat4_inverse(
    float res[4][4], 
    float src[4][4]);

extern float 
MATmat2_inverse(
    float res[2][2], 
    float src[2][2]);

extern float 
MATmat3_inverse(
    float res[3][3], 
    float src[3][3]);

extern void
MATmat4_transpose(
    float res[4][4], 
    float src[4][4]);

extern void
MATmat3_transpose(
    float res[3][3], 
    float src[3][3]);

extern void
MATmat4_sample_perspect(
    float res[4][4],
    float src[4][4]);

extern void
MATbuild_sqrt_table(void);

extern float 
MATfast_fsqrt(
    float n);

extern void
MATvec_by_mat(
    float       *vec_in,
    float       *mat,
    float       *vec_out,
    xp_long     num_vec,
    xp_long     num_row, 
    xp_long     num_col);

extern void
MATmat4_orthonormalize(
    float ortho[4][4],
    float matrix[4][4]);

extern void
MATmat4_multiply(
    float s1[4][4],
    float s2[4][4],
    float res[4][4]);

extern void
MATxform_vecs(
    xp_long nvec,
    float vec[][3],
    float xform[4][4],
    float tvec[][3]);

extern void
MATnormalize_vecs(
    xp_long nvec,
    float vec[][3]);

extern void
MATxform_vert(
    float vert[3],
    float xform[4][4],
    float tvert[4]);

extern void
MATxform_verts(
    xp_long nvert,
    float vert[][3],
    float xform[4][4],
    float tvert[][4]);

extern void
MATxform_verts3(
    xp_long nvert,
    float vert[][3],
    float xform[4][4],
    float tvert[][3]);

extern void
MATxform_verts3to2(
    xp_long nvert,
    float vert[][3],
    float xform[4][4],
    float tvert[][2],
    int flag);

extern void
MATxform_verts2(
    xp_long nvert,
    float vert[][2],
    float xform[4][4],
    float tvert[][2]);

extern void
MATmat4_perspect(
    float mat[4][4],
    float fov, 
    float front, 
    float back);

#ifdef __cplusplus
}
#endif

#endif
