/*
		Copyright (c) 1994 by
		Advanced Visual Systems Inc.
		All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/math.h#1 $
*/

#ifndef _MATH_H_INCLUDED
#define _MATH_H_INCLUDED

#include <math.h>

#ifdef _AIX 
/* problems with _ABS defined for IBM in port.h,
   this _ABS will be used for C compilation,
   since /usr/include/math.h does not have _ABS,
   but /usr/lpp/xlC/include/math.h does have _ABS for C++ ! */
#ifndef _ABS
#define _ABS(A) ((A)>0?(A):-(A))
#endif
#endif

/* Pick up the includes for the MAT utilities. */
#include <avs/mat.h>

#ifdef __cplusplus
extern "C" {
#endif

#define VEC_LEN(A) sqrt( A[0]*A[0] + A[1]*A[1] + A[2]*A[2] )

#define VEC_UNITIZE(A,EPS) { float len,len0; len0=A[0]*A[0]+A[1]*A[1]+A[2]*A[2];\
			     len = sqrt(len0); \
			     if (len>EPS) { A[0] /= len; A[1] /= len; A[2] /= len; } }

#define VEC_NORMALIZE(C,L) { C[0] =  C[0] / (L) ; \
			     C[1] =  C[1] / (L) ; \
			     C[2] =  C[2] / (L) ; } 

#define VEC_DOT(A,B)	( A[0]*B[0] + A[1]*B[1] + A[2]*B[2] )

#define VEC_CROSS(C,A,B) { C[0] = A[1]*B[2] - A[2]*B[1]; \
			   C[1] = A[2]*B[0] - A[0]*B[2]; \
			   C[2] = A[0]*B[1] - A[1]*B[0]; }

#define VEC_TRIPLE_PROD(A,B,C)	\
	               ( A[0]*B[1]*C[2] + A[1]*B[2]*C[0] + A[2]*B[0]*C[1]	\
	               - A[2]*B[1]*C[0] - A[1]*B[0]*C[2] - A[0]*B[2]*C[1] )

#define VEC_DIST(A,B) sqrt(((A[0]-B[0])*(A[0]-B[0])) +\
                           ((A[1]-B[1])*(A[1]-B[1])) +\
                           ((A[2]-B[2])*(A[2]-B[2])) )

#define VEC_UNIT_TRANS(vec, matrix, axis) { vec[0]= matrix[axis][0]; \
                                        vec[1]= matrix[axis][1]; \
                                        vec[2]= matrix[axis][2]; }

#define VEC_SCALAR_PROD(res, scalar, vec) { res[0]= scalar * vec[0]; \
                                            res[1]= scalar * vec[1]; \
                                            res[2]= scalar * vec[2]; }

#define VEC_SCALAR_DIV(res, vec, scalar) { res[0]= vec[0] / scalar; \
					   res[1]= vec[1] / scalar; \
                                           res[2]= vec[2] / scalar; }

#define VEC_SUBTRACT(res, vec1, vec2) { res[0]= vec1[0] - vec2[0]; \
                                        res[1]= vec1[1] - vec2[1]; \
                                        res[2]= vec1[2] - vec2[2]; }

#define VEC_ADD(res, vec1, vec2) { res[0]= vec1[0] + vec2[0]; \
                                        res[1]= vec1[1] + vec2[1]; \
                                        res[2]= vec1[2] + vec2[2]; }

#define VEC_COPY(res, vec) { res[0]= vec[0]; \
                             res[1]= vec[1]; \
                             res[2]= vec[2]; }

#define VEC_INVERT(vec) { vec[0] *= -1.0; \
                          vec[1] *= -1.0; \
                          vec[2] *= -1.0; }

#ifdef __cplusplus
} /* End of extern "C" */
#endif

#endif /* _MATH_H_INCLUDED */
