/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/mem_defs.h#1 $
*/

/*-------------------------------------------------------------------------
 * Dynamic memory allocation is always a problem area.  There are
 * many ways to make mistakes:
 *
 *	* Write beyond end of memory allocated.
 *	* Use memory after it has been freed.
 *	* Assume that 'malloc' clears memory.
 *	* Not checking for NULL returned from 'malloc'.
 *	* Specify single argument to 'calloc'.
 *	* Failure to free memory (a "memory leak").
 *
 * These macros insert a layer of error checking routines between the
 * application and the system memory allocation routines.
 * For instance if you call 'malloc', this substitutes a call to 
 * 'MEMmalloc' instead.  It collects statistics, does error checking,
 * and optionally prints out debugging information.
 *
 * To activate this substitution, you must define the preprocessor
 * symbol MEM_DEFS_ENABLE.
 *
 * These substitutions can cause some strange syntax errors under
 * certain conditions.  See AVS Developer's Guide for more details.
 *-------------------------------------------------------------------------*/

#ifndef _MEM_DEFS_defined
#define _MEM_DEFS_defined 1

#ifdef MEM_DEFS_ENABLE
#include <string.h>
#include <stdlib.h>

#ifdef strdup
#undef strdup
#endif
#ifdef strcmp
#undef strcmp
#endif
#ifdef strncmp
#undef strncmp
#endif
#ifdef strlen
#undef strlen
#endif
#ifdef strcpy
#undef strcpy
#endif
#ifdef strcat
#undef strcat
#endif

#ifdef sparc
/* to avoid include of /usr/include/malloc.h which clashes with mem_defs.h */
#define __malloc_h
#endif

#ifndef avsargs_h
#include <avs/avsargs.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

AVS_EXTERN( char *MEMmalloc, (size_t, const char*, int));
AVS_EXTERN( void MEMfree, (char *, const char*, int));
AVS_EXTERN( char *MEMrealloc, (char *, size_t, const char*, int));
AVS_EXTERN( char *MEMcalloc, (size_t, unsigned int, const char*, int));
AVS_EXTERN( char *MEMstrdup, (const char*, const char*, int));

AVS_EXTERN( void MEMinit, (const char*, int (*error_func) (char *)));
AVS_EXTERN( void MEMprint_in_use, (void));
AVS_EXTERN( void MEMexit, (void));

AVS_EXTERN( int MEMstrcmp, (const char*, const char*, const char*, int));
AVS_EXTERN( int MEMstrncmp, (const char*, const char*, size_t, const char*, int));
AVS_EXTERN( size_t MEMstrlen, (const char*, const char*, int));
AVS_EXTERN( char *MEMstrcpy, (char*, const char*, const char*, int));
AVS_EXTERN( char *MEMstrcat, (char*, const char*, const char*, int));
AVS_EXTERN( char *MEMstrchr, (char*, int, const char*, int));
AVS_EXTERN( char *MEMstrrchr, (char*,int, const char*, int));

#ifdef __cplusplus
}
#endif

#define malloc(size) MEMmalloc((size),__FILE__,__LINE__)
#define free(ptr) { MEMfree((ptr),__FILE__,__LINE__); (ptr) = (void*)0x55555555; }
#define realloc(ptr,size) MEMrealloc((ptr),(size),__FILE__,__LINE__)
#define calloc(nelem,elsize) MEMcalloc((nelem),(elsize),__FILE__,__LINE__)

#define strdup(ptr) MEMstrdup((ptr),__FILE__,__LINE__)
#define strcmp(s1,s2) MEMstrcmp((s1),(s2),__FILE__,__LINE__)
#define strncmp(s1,s2,n) MEMstrncmp((s1),(s2),(n),__FILE__,__LINE__)
#define strlen(s) MEMstrlen((s),__FILE__,__LINE__)
#define strcpy(s1,s2) MEMstrcpy((s1),(s2),__FILE__,__LINE__)
#define strcat(s1,s2) MEMstrcat((s1),(s2),__FILE__,__LINE__)
/*#define strchr(s,c) MEMstrchr((s),(c),__FILE__,__LINE__)*/
/*#define strrchr(s,c) MEMstrrchr((s),(c),__FILE__,__LINE__)*/

#else	/* ifdef MEM_DEFS_ENABLE */

/*
 * Forgeting to declare pointer-returning functions such as 
 * malloc or strdup can cause problems on some systems.
 */

#include <stdlib.h>
#include <string.h>

#endif	/* ifdef MEM_DEFS_ENABLE */

#endif 	/* ifndef _MEM_DEFS_defined */

