/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/om_att.h#1 $
*/
#ifndef OM_ATT_INCLUDED
#define OM_ATT_INCLUDED
/*
 * This file contains declarations of properties and attributes defined
 * by the object manager library.
 */

#ifdef __cplusplus
extern "C" {
#endif

/* These are flags of attributes.  They are specified when they are created */
#define OM_ATT_FLAG_NOSAVE 	1		/* don't save the element     */
#define OM_ATT_FLAG_PROPAGATE 	2		/* propagate flag to children */
#define OM_ATT_FLAG_NOCOPY	4		/* don't copy this attribute */
#define OM_ATT_FLAG_NOMATCH	8		/* don't match this attribute */
#define OM_ATT_FLAG_INTERNAL	0x20
#define OM_ATT_FLAG_NOBSAVE	0x40		/* Should we save for binary? */

#define OM_PROP_FLAG_PTRS	1
#define OM_PROP_FLAG_NOSAVE	2
/* #define OM_PROP_FLAG_NOCOPY	4 -- not implemented yet */
#define OM_PROP_FLAG_NOMATCH    8
#define OM_PROP_FLAG_DERIVED_FUNC 0x10 /* don't call set_func for derived obj */
#define OM_PROP_FLAG_INTERNAL	0x20
#define OM_PROP_FLAG_SET_ONLY   0x40   /* only call set_func when prop is set*/
#define OM_PROP_FLAG_NOBSAVE	0x80		/* Should we save for binary? */
#define OM_PROP_FLAG_NOBRESTORE 0x100
#define OM_PROP_FLAG_NO_BASE_TYPES 0x200 /* don't call set func for base types*/

/* Property and attribute group flags, specified upon creation */
#define OM_PROP_GROUP_NONE		0x0
#define OM_PROP_GROUP_NE		0x1
#define OM_PROP_GROUP_MISC		0x2
#define OM_PROP_GROUP_BUILD		0x4

#define OM_PROP_GROUP_CXX		0x8
#define OM_PROP_GROUP_UCI		0x10
#define OM_PROP_GROUP_OM		0x20

#define OM_PROP_GROUP_MODS		\
	(OM_PROP_GROUP_CXX | OM_PROP_GROUP_UCI | OM_PROP_GROUP_OM)

#define OM_PROP_GROUP_PARAM	  	0x40
#define OM_PROP_GROUP_METHOD	  	0x80
#define OM_PROP_GROUP_MODULE	  	0x100
#define OM_PROP_GROUP_LIBRARY	  	0x200
#define OM_PROP_GROUP_MACRO	  	0x400
#define OM_PROP_GROUP_GROUP		0x800
#define OM_PROP_GROUP_PROCESS		0x1000

#define OM_PROP_GROUP_TYPES (OM_PROP_GROUP_PARAM | OM_PROP_GROUP_MODULE \
			     | OM_PROP_GROUP_MACRO | OM_PROP_GROUP_LIBRARY \
			     | OM_PROP_GROUP_METHOD | OM_PROP_GROUP_GROUP \
			     | OM_PROP_GROUP_PROCESS)

#define OM_PROP_GROUP_ALL		0xffffffff


#ifdef  FUNC_PREFIX
#undef  FUNC_PREFIX
#define FUNC_PREFIX DLL_EXPORT
#endif

#ifdef OM_ATT_DECLARE
#define OM_ATT_EXTERN
#else
#ifdef XP_INTERNAL_GLOBALS
#define OM_ATT_EXTERN extern
#else
#define OM_ATT_EXTERN DLL_IMPORT
#undef  FUNC_PREFIX
#define FUNC_PREFIX DLL_IMPORT
#endif
#endif

typedef struct _OMprop_entry {
   OMobj_name prop_name;
   int flags;
   int group;
   int (*set_func) (OMobj_id, OMobj_name, OMobj_id, int);
   char *default_str;
   char *help_str;
   struct _OMprop_entry *next;
   struct _OMprop_entry *next_list;
} OMprop_entry;

/* Default attributes (represented by name) */
OM_ATT_EXTERN OMobj_name OM_att_nosave, OM_att_read, OM_att_write, 
		          OM_att_notify, OM_att_nonotify,
			  OM_att_inst, OM_att_active, OM_att_req, 
			  OM_att_virtual, OM_att_wasvirtual, OM_att_opt, 
			  OM_att_array_list, OM_att_unresolved, 
			  OM_att_nres, OM_att_copy_on_cr, OM_att_copy_on_rd,
			  OM_att_unmod, OM_att_deleted,
			  OM_att_derived, OM_att_value,
			  OM_att_byref, OM_att_trace, 
			  OM_att_procset, OM_att_user_class,
			  OM_att_noread, OM_att_nowrite, OM_att_array_memb,
			  OM_att_locked, OM_att_noevents, OM_att_needed,
			  OM_att_uneditable,OM_att_nojournal;

/* Default attributes (represented by bit pattern) */
OM_ATT_EXTERN OMatts      OM_atts_nosave, OM_atts_read, OM_atts_write, 
		          OM_atts_notify, OM_atts_nonotify,
			  OM_atts_inst, OM_atts_active, OM_atts_req, 
			  OM_atts_virtual, OM_atts_wasvirtual, OM_atts_opt, 
			  OM_atts_array_list, OM_atts_unresolved, 
			  OM_atts_nres, OM_atts_copy_on_cr, OM_atts_copy_on_rd,
			  OM_atts_unmod, OM_atts_deleted,
			  OM_atts_derived, OM_atts_value,
			  OM_atts_byref, OM_atts_trace,
			  OM_atts_procset, OM_atts_user_class,
			  OM_atts_noread, OM_atts_nowrite, OM_atts_array_memb,
			  OM_atts_locked, OM_atts_noevents, OM_atts_needed,
			  OM_atts_uneditable,OM_atts_nojournal;


/* Collections of attributes that share certain properties */
OM_ATT_EXTERN OMatts	  OM_atts_propagate, OM_atts_nocopy, OM_atts_nomatch,
			  OM_atts_need_proc, OM_atts_nobsave;

OM_ATT_EXTERN OMobj_name OM_prop_inst_func,
			  OM_prop_remote_func, OM_prop_dynamic, 
			  OM_prop_leaf, OM_prop_weight, OM_prop_buffered,
			  OM_prop_isbuffer, OM_prop_remote_proc, 
			  OM_prop_rdonly, OM_prop_saved_file,
			  OM_prop_has_func_dep,
			  OM_prop_user_library, OM_prop_islibrary,
			  OM_prop_can_have_dims, OM_prop_can_have_ref_mode,
			  OM_prop_libfile, OM_prop_libimm, OM_prop_need_dep,
			  OM_prop_user_class, OM_prop_user_name,
			  OM_prop_dictionary, OM_prop_export, 
			  OM_prop_export_all, OM_prop_export_subs,
			  OM_prop_export_cxx, OM_prop_export_cxx_class,
			  OM_prop_cxx_name, OM_prop_cxx_method_args,
			  OM_prop_cxx_class, OM_prop_cxx_class_args,
			  OM_prop_cxx_members, OM_prop_cxx_members_constr,
			  OM_prop_instanced, OM_prop_cxx_abstract,
			  OM_prop_cxx_path_name,
			  OM_prop_ui_default_shell,
			  OM_prop_fast_subs, OM_prop_journal_string;

OM_ATT_EXTERN OMobj_name OM_prop_init_code, OM_prop_pre_init_code, 
			  OM_prop_hdr_code, 
		          OM_prop_c_src_files, OM_prop_c_hdr_files,
		          OM_prop_cxx_src_files, OM_prop_cxx_hdr_files,
			  OM_prop_f_src_files,
			  OM_prop_link_files, OM_prop_libdeps, OM_prop_dynlibs,
			  OM_prop_build_dir, OM_prop_build_cmd, OM_prop_in_dll,
			  OM_prop_process, OM_prop_src_file,
			  OM_prop_use_src_file,
			  OM_prop_out_hdr_file, OM_prop_out_src_file,
			  OM_prop_compile_subs, OM_prop_need_cxx, OM_prop_lang,
			  OM_prop_inc_dirs, OM_prop_hdr_dirs,
			  OM_prop_no_main, OM_prop_compile_src,
			  OM_prop_need_f;

OM_ATT_EXTERN OMobj_name OM_prop_raw_array, OM_prop_virt_node, OM_prop_raw_obj,
			 OM_prop_in_use, OM_prop_user_destroyed, 
			 OM_prop_locked, OM_prop_val_state,
			 OM_prop_need_virtual, OM_prop_libopen,
			 OM_prop_null_dim, OM_prop_need_objs,
			 OM_prop_prop_groups, OM_prop_is_val_func,
			 OM_prop_is_ref_list, OM_prop_free_ptr;

OM_ATT_EXTERN OMobj_name OM_prop_interruptable, OM_prop_disabled,
			 OM_prop_queueable, OM_prop_notifier_arg,
			 OM_prop_notifier_func, OM_prop_status,
			 OM_prop_pending, OM_prop_no_meth_ctx,
			 OM_prop_immediate;

OM_ATT_EXTERN OMobj_name OM_prop_class_refcnt, OM_prop_no_edit_lic,
			 OM_prop_needs_edit_lic, OM_prop_edit_lic,
			 OM_prop_needs_use_lic, OM_prop_indexed;

OM_ATT_EXTERN OMobj_name OM_prop_xp_path, OM_prop_ptr_free, 
			 OM_prop_deinstanced, OM_prop_port_cache,
			 OM_prop_compiled_at, OM_prop__libdeps,
			 OM_prop_val_func_save_name,
			 OM_prop_animate, OM_prop_verbose_suppress;

OM_ATT_EXTERN OMprop_entry *OM_prop_list;

OM_ATT_EXTERN unsigned int OM_atti_inst, OM_atti_active;


/*
 * Not real properties... rather they are the text string interfaces
 * to these attributes through the prop list.
 */
OM_ATT_EXTERN OMobj_name OM_prop_dimensions, OM_prop_ref_mode;

OM_ATT_EXTERN OMobj_id OM_obj_true, OM_obj_false;

FUNC_PREFIX void OMinit_base_props (void);

FUNC_PREFIX int OMcreate_prop (OMobj_name name, unsigned int flags,
	         unsigned int group,
	         int  (*set_func) (OMobj_id, OMobj_name, OMobj_id, int),
		 char *default_str, char *help_str);

FUNC_PREFIX int OMget_obj_prop_list (OMobj_id elem_id, int *ret_nprops,
				 OMobj_name **ret_prop_list, 
				 char ***ret_val_list, int mode);

FUNC_PREFIX int OMdel_obj_prop_list (OMobj_id elem_id, int nprops,
				 OMobj_name *prop_list, int mode);

FUNC_PREFIX int OMset_obj_prop_list (OMobj_id elem_id, int nprops,
				 OMobj_name *prop_list, char **val_list,
				 int mode);
FUNC_PREFIX void OMfree_prop_list (int nprops, OMobj_name *prop_list,
			      char **val_list);

#ifdef __cplusplus
} /* End of extern "C" */
#endif


#endif
