/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/pal.h#1 $
*/

#ifndef XP_PAL_INCLUDED
#define XP_PAL_INCLUDED

/* Windowing system include files. */
#ifdef MSDOS
/* windows.h is included in om.h */
#else
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Intrinsic.h>
#endif

#include <avs/om.h>

/* Constants for use with the virtual palette. */
#include <avs/pal_def.h>

typedef int (*PALfunc)();

/* Forward references to data structure types */

typedef struct _PALvirt PALvirt;

/* Virtual palette change callback function */

typedef void (*PALchange_func) (
    PALvirt  *virtpal,
    void     *data);

/* Structure definition for a change callback */

typedef struct _PALchange_callback {
    PALchange_func  func;
    void            *data;
} PALchange_callback;

#ifdef MSDOS
typedef struct _FULLLOGPALETTE {
    WORD		palVersion;
    WORD		palNumEntries;
    PALETTEENTRY	palPalEntry[256];
} FULLLOGPALETTE;

typedef struct _FullBmpInfoT {
    BITMAPINFOHEADER	bmiHeader;
    short		bmiColors[256];
} FullBmpInfoT;
#endif

#ifndef MSDOS
typedef struct _PALmap {
   int alloced;		/* 1 if we need to free the resource */
   Colormap cmap;
   XStandardColormap std_cmap;
   int bytes_per_pixel;
   int cells_avail;		/* total cells available in colormap */
   int cells_contig;		/* largest contiguous region */
   int cells_start;		/* start of contiguous region */
   int cells_used;		/* total cells actually used */
   unsigned long cell_pixels[256];
   XColor xcolors[256];
   unsigned long colors[8][8][8];
   /* only used on systems where bytes per pixel = 4 */
   unsigned long red[256];
   unsigned long green[256];
   unsigned long blue[256];
} PALmap;
#else
typedef struct _PALmap {
   int			alloced;
   int			bytes_per_pixel;
   int			cells_avail;
   int			cells_used;

   HPALETTE		hPalette;
   FULLLOGPALETTE	LogPalette;
   HHOOK		hHook;

   int			PalStart;

   unsigned char	colors[8][8][8];

   unsigned int		red[256];
   unsigned int		green[256];
   unsigned int		blue[256];
} PALmap;
#endif

/* Structure definition for a ramp */

typedef struct _PALramp {
   int ndmaps;			/* number of associated datamaps */
   OMobj_id *dmap_ids;         /* array of datamap ids */
   int size;			/* requested size from datamap */
   int size_out;		/* actual size granted */
   int start;			/* start index into PALvirt cell_pixels */
} PALramp;

/* Structure definition for the virtual palette. */

struct _PALvirt {
   /* Public definitions for the object manager group */
		/* vclass is not expressed in X dependent
		   terms but in terms of the constants in
		   avs/pal_def.h
		*/
   int update;		/* process possible color allocation changes */
   int vclass;		/* visual class */
   unsigned long vid;	/* visual id */
   int share;		/* if 1=share colormap 0=private */
   float gamma;		/* gamma correction value */
   int cube_size;	/* size of cube. 0=no cube */
   /* Private definitions */
   int nviews;			/* number of GDviews attached to */
   GDview **views;		/* array of views attached to virtual palette */
   int nchange_callbacks;	/* number of change callbacks */
   PALchange_callback *change_callbacks; /* callbacks for palette changes */
   int valid;			/* 1 if attached to system palette */
   int installed;		/* 1 if WM has been told to install cmap */
   int use_std_cmap;		/* 1 if we are to use a standard colormap */
	/* Actual values - these may be different */
	/* than what was actually requested. */
   int vclass_out;
   unsigned long vid_out;
   int share_out;		/* if 1=share colormap 0=private */
   float inv_gamma;		/* inverse gamma correction value */
   PALmap *mapinfo;
#ifndef MSDOS
		/* At some point it will probably come up
		   as to why the display and screen are in
		   here and in the GDwinfo structure. I didn't
		   want to have the palette stuff depend on GD
		   when GD already depends on the palette stuff.
                */
   Display *disp;
   int screen;
   Visual *visual;
   unsigned long red_mask, green_mask, blue_mask;
#endif
   int depth;
   int offscreen;		/* flag for offscreen mode */
};

/* Structure for system palette. This structure should
   NOT be accessed other than through API routines.
*/
typedef struct _PALsys {
   int alloced;                 /* 1 if entry is in use */
   int nvirt_pals;              /* number of virtual palettes associated */
   PALvirt **virt_pals;         /* with this system palette. */
   int vclass;                  /* Pseudo, Direct, True color */
   unsigned long vid;           /* Visual ID */
   int share;                   /* 0=shared cmap 1=private cmap */
   int use_std_cmap;		/* 1 if we are to use a standard colormap */
   float gamma;
   int cube_size;               /* Requested size of cube in system palette */
   int cube_size_out;		/* Actual size of cube in system palette */
   int change_flags;		/* what changes have occurred in ramps */
   int nramps;			/* number of ramps in palette */
   PALramp **ramps;		/* array of ramps */
   int nnew_ramps;		/* number of new ramps in palette */
   PALramp **new_ramps;		/* array of new ramps */
   PALmap *mapinfo;             /* Info about colormap, tables, etc. */
} PALsys;

#ifdef __cplusplus
extern "C" {
#endif

/***************************************************/
/* Public function definitions for system palette. */
/***************************************************/

void	PALsys_init (void);
int	PALsys_attach_virt (PALvirt *);
void	PALsys_detach_virt (PALvirt *);
int	PALsys_match_virt  (PALvirt *);
PALsys *PALsys_lookup_virt (PALvirt *);

/****************************************************/
/* Public function definitions for virtual palette. */
/****************************************************/

/* Defined in virt.c */
PALvirt *PALvirt_create (int, unsigned int, int, int);
void	PALvirt_destroy (PALvirt *);
void	PALvirt_add_change_callback (PALvirt *, PALchange_func, void *);
void	PALvirt_detach_views (PALvirt *);
int	PALvirt_validate_pseudo (PALvirt *);
int	PALvirt_calc_req_colors (PALvirt *);
int	PALvirt_get_cube_size (PALvirt *, int *);
int	PALvirt_update_cube (PALvirt *);
int	PALvirt_alloc_colors (PALsys *, PALvirt *);

/* Defined in x_virt.c or nt_virt.c */
int	PALvirt_find_bestvis (PALvirt *);
int	PALvirt_find_visid (PALvirt *);
int	PALvirt_find_map (PALvirt *);
int	PALvirt_update_map (PALvirt *);
int	PALvirt_realloc_map (PALvirt *);
int	PALvirt_dealloc_map (PALvirt *);
int	PALvirt_alloc_8bit_colors (PALsys *, PALvirt *);
int	PALvirt_alloc_24bit_colors (PALsys *, PALvirt *);

/* Defined in x_virt.c - Unix/X based versions of the routines */
#ifndef MSDOS
void	PALvirt_set_winfo(PALvirt *, Display *, int, int);
int	PALvirt_validate (Window, PALvirt *);
void	PALvirt_install_map (Widget, Window, PALvirt *, int);
XStandardColormap *PALvirt_get_stdcmap (PALvirt *);
/* Defined in nt_virt.c - Windows based versions of the routines */
#else
int	PALvirt_validate (HWND, PALvirt *);
void	PALvirt_install_map (HWND, HDC, PALvirt *, int);
#endif

#ifdef __cplusplus
}       /* extern "C" */
#endif

#endif /* XP_PAL_INCLUDED */

