/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/rp.h#1 $
*/
#ifndef XP_RP_INCLUDED
#define XP_RP_INCLUDED

#include <avs/comm.h>
#include <avs/event.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef int  (*RPpfi)();
typedef void (*RPpfv)();

typedef struct _RPcall {
   void (*func) (int, COMMconn *, char *);
   int code;
   char *arg;
   struct _RPcall *next;
} RPcall;

typedef struct _RPcall_list {
   int hash_size;
   RPcall **hash_table;
} RPcall_list;

typedef struct _RPserver {
   COMMconn  *conn;
   RPcall_list *list;
   void (*destroy_func) (void *);
   void *destroy_arg;
   unsigned int destroyed:1;
} RPserver;

#define RP_SERVER_ARG(C)	(((RPserver *)(C)->destroy_arg)->destroy_arg)

typedef struct _RPpack_val {
   unsigned int scalar:1,type:3,sent:1;
   union {
      union {
	 int 	ival;
	 short 	sval;
	 char 	bval;
	 float 	fval;
	 double dval;
	 xp_long    lval;
      } s;
      struct _RParray {
         xp_long offset, length;
	 char *ptr;
      } a;
   } v;
} RPpack_val;

typedef struct _RPpacket {
   int err, sync;
   COMMconn  *conn;
   int nvals, nmaxvals;
   RPpack_val *vals;
} RPpacket;

#define RPinteger_array_read(C,A,L) RParray_read(C,COMM_TYPE_INT,(char **)A,L)
#define RPbyte_array_read(C,A,L)   RParray_read(C,COMM_TYPE_BYTE,A,L)
#define RPfloat_array_read(C,A,L)  RParray_read(C,COMM_TYPE_FLOAT,(char **)A,L)
#define RPdouble_array_read(C,A,L) RParray_read(C,COMM_TYPE_DOUBLE,(char **)A,L)
#define RPlong_array_read(C,A,L)   RParray_read(C,COMM_TYPE_LONG,(char **)A,L)
#define RPshort_array_read(C,A,L)  RParray_read(C,COMM_TYPE_SHORT,(char **)A,L)

#define RPinteger_read(C,A) RPprim_read(C,COMM_TYPE_INT,(char *)A)
#define RPbyte_read(C,A)    RPprim_read(C,COMM_TYPE_BYTE,A)
#define RPfloat_read(C,A)   RPprim_read(C,COMM_TYPE_FLOAT,(char *)A)
#define RPdouble_read(C,A)  RPprim_read(C,COMM_TYPE_DOUBLE,(char *)A)
#define RPlong_read(C,A)    RPprim_read(C,COMM_TYPE_LONG,(char *)A)
#define RPshort_read(C,A)   RPprim_read(C,COMM_TYPE_SHORT,(char *)A)

RPserver 	*RPinit_server_conn (COMMconn *, RPcall_list *list,
					     void (*func)(void *), void *);
void 		RPdestroy_server (RPserver *);
void		RPdispatch (char *);
void		RPinit_client_conn (COMMconn *, void (*func)(void *), void *); 
void		RPset_dispatch_hold (int val);
RPcall_list     *RPcreate_call_list (int);
void		RPdefine_handler (RPcall_list *,unsigned int,
                                  void (*)(), char *);
void		RPdestroy_call_list (RPcall_list *);
int		RPsend_packet (COMMconn *, RPpacket *, int sync);
RPpacket	*RPnew_packet (int);
void		RPfree_packet (RPpacket *);
void 		RPadd_array_packet (RPpacket *, int, char *, xp_long);
void 		RPadd_int_packet (RPpacket *, int);
void 		RPadd_float_packet (RPpacket *, float);
void 		RPadd_double_packet (RPpacket *, double);
void 		RPadd_long_packet (RPpacket *, xp_long);
void		RPadd_string_packet (RPpacket *, char *);
void		RPerror (const char *);
void		RPinternal_error (const char *);
RPcall		*RPlookup_handler (RPcall_list *, unsigned int);
int		RPprim_read (COMMconn *, int, char *);
int		RParray_read (COMMconn *, int, char **, xp_long);
int		RPstring_read (COMMconn *conn, char **str);

#ifdef __cplusplus
} /* End of extern "C" */
#endif

#endif
