/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/rp_func.h#1 $
*/

#ifndef XP_RP_FUNC_INCLUDED
#define XP_RP_FUNC_INCLUDED

#include <avs/rp.h>

#ifdef __cplusplus
extern "C" {
#endif

#define RP_MAX_ARGS 16

enum {
   RP_ARG_ARRAY, RP_ARG_ARRAY_PTR, RP_ARG_INT, RP_ARG_INT_PTR,
   RP_ARG_DOUBLE, RP_ARG_DOUBLE_PTR, RP_ARG_LONG, RP_ARG_LONG_PTR,
   RP_ARG_STRING, RP_ARG_STRING_PTR, RP_ARG_ARR_ARRAY_PTR, RP_ARG_ARR_ARRAY
};

#define RP_CLNT	0
#define RP_SRV	1

#define RP_CALL_SYNC    	0
#define RP_CALL_BUFFER 		1

#define RP_SRV_REQ_QUEUED	-2

#define RP_STAT_DELAY_REQ	-333

/*
 * Macros to allow user access to argument bits cleanly
 * These have debugging built in to try and catch type check mismatches.
 */
#define RP_ANY_ARRAY(A)  \
 ((A).type == RP_ARG_ARRAY ? ((A).val.a.ptr) : (char *)(RP_match("RP_ANY_ARRAY"),0L))

#define RP_CHAR_ARRAY(A)  \
 ((A).type == RP_ARG_ARRAY && (A).val.a.type == COMM_TYPE_CHAR ? \
    		((A).val.a.ptr) : (char *)(RP_match("RP_CHAR_ARRAY"),0L))

#define RP_CHAR_ARRAY_PTR(A)  \
 ((A).type == RP_ARG_ARRAY_PTR && (A).val.ap.type == COMM_TYPE_CHAR ? \
    		((A).val.ap.pptr) : (char **)(RP_match("RP_CHAR_ARRAY_PTR"),0L))

#define RP_ARR_ARRAY_PTR(A)  \
 ((A).type == RP_ARG_ARR_ARRAY_PTR ? \
   	((A).val.arrp.pptr) : (char **)(RP_match("RP_ARR_ARRAY_PTR"),0L))

#define RP_ARR_ARRAY(A)  \
 ((A).type == RP_ARG_ARR_ARRAY ? \
		((A).val.arr.ptr) : (char *)(RP_match("RP_ARR_ARRAY"),0L))

#define RP_INT_ARRAY(A)	\
 ((A).type == RP_ARG_ARRAY && (A).val.a.type == COMM_TYPE_INT ? \
		(int *)((A).val.a.ptr) : (RP_match("RP_INT_ARRAY"),0L))

#define RP_INT_ARRAY_PTR(A)	\
 ((A).type == RP_ARG_ARRAY_PTR && (A).val.ap.type == COMM_TYPE_INT ? \
		(int **)((A).val.ap.pptr) : (RP_match("RP_INT_ARRAY"),0L))

#define RP_FLOAT_ARRAY(A) \
 ((A).type == RP_ARG_ARRAY && (A).val.a.type == COMM_TYPE_FLOAT ? \
		(float *)((A).val.a.ptr): (RP_match("RP_FLOAT_ARRAY"),0L))

#define RP_FLOAT_ARRAY_PTR(A) \
 ((A).type == RP_ARG_ARRAY_PTr && (A).val.ap.type == COMM_TYPE_FLOAT ? \
	(float **)((A).val.ap.pptr): (RP_match("RP_FLOAT_ARRAY_PTR"),0L))

#define RP_DOUBLE_ARRAY(A) \
 ((A).type == RP_ARG_ARRAY && (A).val.a.type == COMM_TYPE_DOUBLE ? \
	(double *)((A).val.a.ptr): (RP_match("RP_DOUBLE_ARRAY"),0L))

#define RP_DOUBLE_ARRAY_PTR(A) \
 ((A).type == RP_ARG_ARRAY_PTr && (A).val.ap.type == COMM_TYPE_DOUBLE ? \
       (double **)((A).val.ap.pptr): (RP_match("RP_DOUBLE_ARRAY_PTR"),0L))

#define RP_LONG_ARRAY(A) \
 ((A).type == RP_ARG_ARRAY && (A).val.a.type == COMM_TYPE_LONG ? \
	(xp_long *)((A).val.a.ptr): (xp_long *)(RP_match("RP_LONG_ARRAY"),0L))

#define RP_LONG_ARRAY_PTR(A) \
 ((A).type == RP_ARG_ARRAY_PTR && (A).val.ap.type == COMM_TYPE_LONG ? \
       (xp_long **)((A).val.ap.pptr): (RP_match("RP_LONG_ARRAY_PTR"),0L))

#define RP_INT_PTR(A)  ((A).type == RP_ARG_INT_PTR ? \
		((A).val.ip.ptr) : (int *)(RP_match("RP_INT_PTR"),0L))

#define RP_DOUBLE_PTR(A)  ((A).type == RP_ARG_DOUBLE_PTR ? \
		((A).val.dp.ptr) : (double *)(RP_match("RP_DOUBLE_PTR"),0L))

#define RP_LONG_PTR(A)  ((A).type == RP_ARG_LONG_PTR ? \
		((A).val.lp.ptr) : (xp_long *)(RP_match("RP_LONG_PTR"),0L))

#define RP_STR(A)  ((A).type == RP_ARG_STRING ?  \
		((A).val.s.ptr) : (char *)(RP_match("RP_STR"),0L))

#define RP_STR_PTR(A)  ((A).type == RP_ARG_STRING_PTR ?  \
		((A).val.sp.pptr) : (char **)(RP_match("RP_STR_PTR"),0L))

#define RP_INT(A)  ((A).type == RP_ARG_INT ?  \
		((A).val.i.val) : (RP_match("RP_INT"),0))

#define RP_UINT(A)  ((unsigned int) RP_INT(A))

#define RP_DOUBLE(A)  ((A).type == RP_ARG_DOUBLE ?  \
		((A).val.d.val) : (RP_match("RP_DOUBLE"),0))

#define RP_LONG(A)  ((A).type == RP_ARG_LONG ?  \
		((A).val.l.val) : (RP_match("RP_LONG"),0))

/* Mode arguments for RP array ptrs... */
#define RP_ARR_ARRAY_RD		ARR_ARRAY_RD
#define RP_ARR_ARRAY_WR		ARR_ARRAY_WR
#define RP_ARR_ARRAY_RW		ARR_ARRAY_RW

#define RP_ARR_ARRAY_NOFREE	0
#define RP_ARR_ARRAY_FREE	1

#define RP_ARRAY_PTR_LEN(A)	(A).val.ap.len
#define RP_ARR_ARRAY_PTR_LEN(A)	(A).val.arrp.len
#define RP_ARR_ARRAY_PTR_TYPE(A) (A).val.arrp.type
#define RP_ARR_ARRAY_PTR_MODE(A) (A).val.arrp.mode
#define RP_ARR_ARRAY_MODE(A) (A).val.arr.mode
#define RP_ARRAY_LEN(A)		(A).val.a.len
#define RP_ARRAY_TYPE(A)	(A).val.a.type
#define RP_ARRAY_PTR_VAL(A)	(A).val.a.ptr

#define RP_STRING_VAL(A)	(A).val.s.ptr

#define RP_RETURN	1
#define RP_NO_RETURN	0

#define RP_SYNC		1
#define RP_NO_SYNC	0

#define RP_SRV_ARG_SIZE 6

typedef struct _RParray_arg {
   char *ptr;
   int  type;
   xp_long len;
} RParray_arg;

typedef struct _RParr_array_arg {
   char *ptr;
   int  type;
   xp_long len;
   int mode;
} RParr_array_arg;

typedef struct _RParray_arg_ptr {
   char **pptr;
   int  type;
   xp_long len;
   char *store;
   int mode;
} RParray_arg_ptr;

typedef struct _RParr_array_arg_ptr {
   char **pptr;
   int  type;
   xp_long len;
   char *store;
   int mode;
   int (*update) (void *, void *, int, size_t, int);
   void *upd_arg;
} RParr_array_arg_ptr;

typedef struct _RPstring_arg {
   char *ptr;
} RPstring_arg;

typedef struct _RPstring_ptr_arg {
   char **pptr; /* pointer to the pointer to the string 		  */
   char *store; /* for output only arguments - place to store the str ptr */
} RPstring_ptr_arg;

typedef struct _RPint_arg {
   int val;
} RPint_arg;

typedef struct _RPdouble_arg {
   double val;
} RPdouble_arg;

typedef struct _RPlong_arg {
   xp_long val;
} RPlong_arg;

typedef struct _RPint_ptr_arg {
   int *ptr;
   int store; /* used to store output ints temporarily */
} RPint_ptr_arg;

typedef struct _RPdouble_ptr_arg {
   double *ptr;
   double store; /* used to store output doubles temporarily */
} RPdouble_ptr_arg;

typedef struct _RPlong_ptr_arg {
   xp_long *ptr;
   xp_long store; /* used to store output doubles temporarily */
} RPlong_ptr_arg;

typedef struct _RParg {
   int type;
   unsigned int input:1,output:1;
   union {
      RPint_arg     i;
      RPdouble_arg  d;
      RPlong_arg  l;
      RPint_ptr_arg ip;
      RPdouble_ptr_arg dp;
      RPlong_ptr_arg lp;
      RParray_arg   a;
      RParray_arg_ptr ap;
      RPstring_arg  s;
      RPstring_ptr_arg sp;
      RParr_array_arg arr;
      RParr_array_arg_ptr arrp;
   } val;
} RParg;

typedef struct _RPfunc {
   int code;
   unsigned int sync:1; /* A synchronous function? */
   unsigned int may_be_delayed:1; /* this function can be put on the delay q */
   int nargs;
   int ninpackets, noutpackets;
   const char *name;
   RParg *args;
   RParg *ret_arg;
   int (*func_real)();
   /*
    * Call the function with argument list supplied
    */
   int (*call_func) (RParg *, int (*)(), COMMconn *);
   struct _RPfunc *next;
   int flags; /* application specific flags set by RPdefine_func */
} RPfunc;

typedef struct _RPfunc_list {
   int hash_size;
   RPfunc **hash_table;
   RPcall_list *call_list;
   int (*rd_func_srv)   (RPfunc *, unsigned int, COMMconn *, int *, xp_ulong *);
   int (*set_func_srv)  (RPfunc *, unsigned int, COMMconn *, int *, xp_ulong *);
   int (*post_func_srv) (RPfunc *, unsigned int, COMMconn *, RPpacket *,
                         int *, int);
   int (*pre_func_clnt) (RPfunc *, unsigned int, COMMconn *, RPpacket *,
                         int *);
   int (*post_func_clnt)(RPfunc *, unsigned int, COMMconn *, int );
} RPfunc_list;

typedef struct _RPclnt_req {
   RPfunc  *finfo;
   RPfunc_list *func_list;
   int func_arg;
   int *stat_ptr;
   COMMconn *conn;
   RParg    *arg_list;
   int stack_level;
   struct _RPclnt_req *next;
   unsigned int clnt_died;
} RPclnt_req;

typedef struct _RPsrv_req {
   RPfunc  *finfo;
   RPfunc_list *func_list;
   COMMconn *conn;
   RParg    *arg_list;
   int stack_level;
   struct _RPsrv_req *next;
   int srv_stat;
   int func_args[RP_SRV_ARG_SIZE];
   xp_ulong *elem_id;
} RPsrv_req;

RPfunc_list *RPcreate_func_list (int, RPcall_list *);
void RPset_srv_funcs (RPfunc_list *func_list,
   int (*rd_func_srv) (RPfunc *, unsigned int, COMMconn *, int*, xp_ulong *),
   int (*set_func_srv) (RPfunc *, unsigned int, COMMconn *, int*, xp_ulong *),
   int (*post_func_srv) (RPfunc *, unsigned int, COMMconn *, RPpacket *, int *, int));
void RPset_clnt_funcs (RPfunc_list *func_list,
   int (*pre_func_clnt) (RPfunc *, unsigned int, COMMconn *, RPpacket *, int*),
   int (*post_func_clnt) (RPfunc *, unsigned int, COMMconn *, int));

int  RPset_debug_fp (FILE *fp, int state);
/* NOTE: the char * name argument is used internally and should point
   to static storage */
RPfunc *RPdefine_func (RPfunc_list *, unsigned int, const char *,
                       int, int, int,
                       int (*)(),
                       int (*)(RParg *, int (*)(), COMMconn *),
                       int flags);
void RPdestroy_func_list (RPfunc_list *);
void RPdefine_arg (RPfunc *, int, int, int, int);
void RPset_array_arg_len (RPfunc *, int, xp_long);
void RPset_array_arg_type (RPfunc *, int, int);
void RPset_array_arg_mode (RPfunc *, int, int);

void RPset_array_arg_update (RPfunc *finfo, int ind,
   int (*upd_func) (void *, void *, int, size_t, int),
   void *upd_arg);

RPfunc *RPlookup_func (RPfunc_list *,unsigned int);
void  RP_delay_srv_req (RPsrv_req *srv_req);
int  RPexec_delayed_srv_req (void);
void RPset_stack_level (int stack_level);
void RPcall_clnt (RPfunc_list *, int, COMMconn *, int *stat,
                  int mode, ...);
void RPsync (void);
void RP_match (const char *);

#ifdef __cplusplus
} /* End of extern "C" */
#endif

#endif
