/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/udata.h#1 $
*/

#ifndef _UDATA_H_defined
#define _UDATA_H_defined

#define BUTTON_DOWN 	0x1
#define BUTTON_UP 	0x2
#define BUTTON_MOVING 	0x4

typedef struct _upstream_geom { 
   int flags;	        /* Button state, and selection mode */ 
   char current_obj[256];/* Object whose selection mode set (coords are in
			    the coordinate system of this object but vertices
			    are defined for "picked obj" */
   float mscoord[3];    /* Modelling space coordinates 	*/
   float wscoord[3];	/* World space coordinates 	*/
   float sscoord[3];    /* Screen space coordinates 	*/
   float objxform[4][4]; /* Object's coordinate matrix */
   float worldxform[4][4]; /* From modelling space to world space */
   float viewxform[4][4]; /* From world space to screen space */

   int x, y;		/* Button x, y		     */
   int width, height;	/* window width,height	     */
   int camera_index;	/* Index of the view selection was made */

   char picked_obj[256]; /* Name of object whose vertex was picked */
   float vertex[3];     /* nearest vertex to selection */
   int vdata;	        /* per-vertex data -- user specified */
   int odata; 		/* per-object (line,poly,sphere) data */
} upstream_geom;

typedef struct _upstream_transform {
   int flags;		/* Button state   	     */ 
   float msxform[4][4];	/* Modelling space transform */
   char object_name[256]; /* Current object	     */
   int camera_index;	/* View transformation is in */
   int button;		/* Button pressed            */
   int x, y;		/* Button x, y		     */
   int width, height;	/* window width,height	     */
} upstream_transform;

typedef struct _ucd_legend_output {
  char val_name[52];
  float hi_val, lo_val;
  int range_flag;
  } ucd_legend_output;

typedef struct _iv_pick {
  int  view_x, view_y;   /* picked point in viewspace (always valid)   */
  int  view_window_id;   /* id of iv window (always valid)             */
  char image_name[256];  /* name of picked image ("" if none picked)   */
  int  image_x, image_y; /* picked point in imagespace (-1,-1 if none) */
  int  image_window_id;  /* id of image window (-1 if none picked)     */
  char label_name[256];  /* name of picked label ("" if none picked)   */
                         /* label_name with no image indicates title   */
} iv_pick;


typedef struct _image_viewer_id {
  int  scene_id;
} image_viewer_id; 


typedef struct _mouse_info {
  char		image_name[64];
  char		func_id[64];
  int		mesh_id;
  int		nEvents;
  float  	image_x[32];
  float 	image_y[32];
  int		buttonMask[32];
} mouse_info; 

#endif /* _UDATA_H_defined */
