/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/include/avs/util.h#1 $
*/

/* Prevent the contents of this file from being included more than once */

#ifndef XP_UTIL_INCLUDED
#define XP_UTIL_INCLUDED

/*--------------------------------------------------------------------*/

#include <stdlib.h>
#include <avs/port.h>

#ifdef AVS_MEM_DEBUG
/*
 * This will re-define malloc to be a call to MEMmalloc
 * with the __FILE__ and __LINE__ macros expanded
 */
#include <avs/mem_defs.h>
#endif

#ifdef __cplusplus
extern "C" {
#endif

#ifndef XP_ERR_INCLUDED
   extern void ERRout_of_memory( const char *message );
#endif

#ifdef __cplusplus
}
#endif

/*--------------------------------------------------------------------*/
/* 
 * Allocate and initialize memory to zero.
 * All platforms now have calloc, so other options have been removed.
 * Requesting 0 or -ve bytes is bad news, caller should ensure N > 0
 */
#ifdef NDEBUG
#define ALLOCN(P,T,N,M) \
	{ size_t __UTIL_n = (N); \
	  while(1) { \
		(P) = (T *) calloc ( __UTIL_n, sizeof(T) ); \
		if ((P) != NULL) break; \
		ERRout_of_memory( M ); } \
	}	
#else
#define ALLOCN(P,T,N,M) \
	{ size_t __UTIL_n = (N); \
	  if (__UTIL_n < 1) { \
		fprintf( stderr, \
		 "Invalid memory allocation: %s line %d, %lu bytes < 1\n", \
		 __FILE__, __LINE__, (__UTIL_n*sizeof(T)) ); \
		 __UTIL_n = 1; } \
	  while(1) { \
		(P) = (T *) calloc ( __UTIL_n, sizeof(T) ); \
		if ((P) != NULL) break; \
		ERRout_of_memory( M ); } \
	}	
#endif

/*--------------------------------------------------------------------*/
/*
 * Allocate, but don't initialize the memory to zero.
 * The calling routine has the responsibility to 
 * initialize all the memory before use.
 * Requesting 0 or -ve bytes is bad news, caller should ensure N > 0
 */

#ifdef NDEBUG
#define UALLOCN(P,T,N,M) \
	{ size_t __UTIL_n_bytes = (N) * sizeof(T); \
	  while (1) { \
		(P) = (T *) malloc( __UTIL_n_bytes ); \
		if ((P) != NULL) break; \
		ERRout_of_memory( M ); } \
	}
#else
#define UALLOCN(P,T,N,M) \
	{ size_t __UTIL_n_bytes = (N) * sizeof(T); \
	  if (__UTIL_n_bytes < 1) { \
		fprintf (stderr, \
		   "Invalid memory allocation: %s line %d, %lu bytes < 1\n", \
			 __FILE__, __LINE__, __UTIL_n_bytes); \
		__UTIL_n_bytes = sizeof(int); } \
	  while (1) { \
		(P) = (T *) malloc( __UTIL_n_bytes ); \
		if ((P) != NULL) break; \
		ERRout_of_memory( M ); } \
	}
#endif

/*--------------------------------------------------------------------*/
/*
 * Reallocate, but don't zero any new memory. 
 * Requesting 0 or -ve bytes is bad news, caller should ensure N > 0
 */

#ifdef NDEBUG
#define REALLOC(P,T,N,M) \
	{ char   *__UTIL_old_ptr = (char*) (P); \
	  size_t  __UTIL_n_bytes = (N) * sizeof(T); \
	  while(1) { \
		(P) = (T *) realloc( __UTIL_old_ptr, __UTIL_n_bytes ); \
		if ((P) != NULL) break; \
		ERRout_of_memory( M ); } \
	}
#else
#define REALLOC(P,T,N,M) \
	{ char   *__UTIL_old_ptr = (char*) (P); \
	  size_t  __UTIL_n_bytes = (N) * sizeof(T); \
	  if (__UTIL_n_bytes < 1) { \
		fprintf (stderr, \
		   "Invalid memory reallocation: %s line %d, %lu bytes < 1\n", \
			 __FILE__, __LINE__, __UTIL_n_bytes); \
		__UTIL_n_bytes = sizeof(int); } \
	  while(1) { \
		(P) = (T *) realloc( __UTIL_old_ptr, __UTIL_n_bytes ); \
		if ((P) != NULL) break; \
		ERRout_of_memory( M ); } \
	}
#endif

/*--------------------------------------------------------------------*/
/* free(3) is non-ANSI compliant on SunOS 4.x */

#ifdef sol1
#define FREE(P)		free((char *) (P))
#else
#define FREE(P)		free(P)
#endif

/*--------------------------------------------------------------------*/
/* define yet another set of trivial math macros */

#define UTMIN(A,B)		((A) > (B) ? (B) : (A))
#define UTMAX(A,B)		((A) < (B) ? (B) : (A))
#define UTABS(A)		((A) < 0 ? -(A) : A)

/*--------------------------------------------------------------------*/
/* Function prototypes */

#ifdef __cplusplus
extern "C" {
#endif

void *UTILinitialize_wildcard (
    char  *wildcard);

int UTILmatch_string_to_wildcard (
    char  *string,
    void  *w);

void UTILfree_wildcard (
    void  *w);

void
TMmerge_translation (
    const char  *tag,
    const char  *translation);

const char *
TMget_translation (
    const char  *tag,
    const char  *default_value);

int
TMload_dictionary (
    const char  *filename,
    const char  *build_path);

int
UTILwrite_image(
    int *dims, void *img_data,
    const char *filename, int flip);

int
UTILwrite_image_AVSX(
    int *dims, void *img_data,
    const char *filename, int flip);

int
UTILwrite_image_PPM(
    int *dims, void *img_data,
    const char *filename, int flip);

int
UTILwrite_image_BMP(
    int *dims, void *img_data,
    const char *filename, int flip);

int
UTILread_image(
    int *dims, void **img_data_ptr,
    const char *filename, int flip);

int
UTILread_image_AVSX(
    int *dims, void **img_data_ptr,
    const char *filename, int flip);

int
UTILread_image_PPM(
    int *dims, void **img_data_ptr,
    const char *filename, int flip);

int
UTILread_image_BMP(
    int *dims, void **img_data_ptr,
    const char *filename, int flip);

#ifdef __cplusplus
}       /* extern "C" */
#endif

/*--------------------------------------------------------------------*/

#endif /* XP_UTIL_INCLUDED */
