#			Copyright (c) 1999 by
#			Advanced Visual Systems Inc.
#			All Rights Reserved
#
#	This software comprises unpublished confidential information of
#	Advanced Visual Systems Inc. and may not be used, copied or made
#	available to anyone, except in accordance with the license
#	under which it is furnished.
#
#	This file is under Perforce control
#	$Id: //depot/express/fcs70/include/linux_ia64/machinc.mk#2 $
#

ifdef INTEL_COMPILER
CPLUS		= ecpc
# 266 function declared implicitly
# 880 omission of explicit type is nonstandard ("int" assumed)
CC		= ecc -wr266,880
F77		= efc
else
CPLUS		= g++
CC		= gcc
endif #INTEL_COMPILER

ARFLAGS		= crv
LEX             = lex -l

# Mesa 4.0.4 installed here.  You can use the Mesa that comes integrated
# into XFree86 4, in which case, the path here should not do any harm.
MESA_HOME = /home/mesa/install404

# OpenMotif 2.2.2 installed in /usr/X11R6
MOTIF_HOME = /usr/X11R6

# PST: added platform dependent MPI flag
MACH_DEFINES    = -DXP_UNIX -D_XOPEN_SOURCE=500 -D_BSD_SOURCE=1 -D_REENTRANT -DMPI_NO_CPPBIND
MACH_INCLUDES	= -I$(MESA_HOME)/include -I$(MOTIF_HOME)/include
MACH_COMMON     = -fPIC
MACH_CFLAGS     = $(MACH_COMMON)

OGL_LIBS_PATH   = -L$(MESA_HOME)/lib

# Path to Motif library (libXm)
XMPATH          = $(MOTIF_HOME)/lib
# Path to X libraries
XPATH           = /usr/X11R6/lib

MACH_CLDFLAGS   = $(G) -Wl,-rpath,$(MESA_HOME)/lib:$(XMPATH):$(XPATH):$(DLLIB_RUNTIME_PATH)
MACH_CXXLDFLAGS = $(MACH_CLDFLAGS)

ifdef INTEL_COMPILER
MACH_CXXFLAGS   =  $(MACH_COMMON)
MACH_FFLAGS     = -fPIC
F77LIBS         = $(LINK_SHARED_FLAG) -lintrins -lIEPCF90 -lF90 -lPEPCF90 $(MAYBE_LINK_SHARED_FLAG)
else
# The no-deprecated flag spares us a million warnings about
# e.g. <iostream.h>
MACH_CXXFLAGS   =  $(MACH_COMMON) -Wno-deprecated
MACH_FFLAGS     = -fPIC -fno-second-underscore
F77LIBS         = $(LINK_SHARED_FLAG) -lg2c $(MAYBE_LINK_SHARED_FLAG)
endif

MACH_CXX_GFLAGS = 

# IAC/MPU: Added MPU_RENDERER to RENFLAGS
RENFLAGS        = SW_RENDERER OGL_RENDERER MPU_RENDERER \
		  AG_KIT VX_KIT PRT_RENDERER VRML_RENDERER VPS_RENDERER

GSUBLIB         = glx

# Kit config: only use this to override the defaults from stdinc.mk
# CONFIGFLAGS     = ACKIT NETCDF_KIT GIS_KIT READ_URL

LIBLMGR = 

XMLIBS.dynamic	= -L$(XMPATH) -lXm
XMLIBS.static	= -L$(XMPATH) $(LINK_STATIC_FLAG) -lXm -lXp $(MAYBE_LINK_SHARED_FLAG) -lXmu
MOTIF_LINK_MODE = dynamic
XMLIBS		= $(XMLIBS.$(MOTIF_LINK_MODE))
XLIBS		= -L$(XPATH)  -lXt -lXext -lX11

# beware of appending $(MAYBE_LINK_SHARED_FLAG) here (-lthread not found)
LASTLIBS        = $(LINK_SHARED_FLAG) -lcrypt -lm -lnsl -ldl

# MACHOSTYPE is used in the installation procedure
MACHOSTYPE	= LINUX

#
# C++ compile/link flag setting template repository/database location
#
CXXTEMPLDIR=
CXXTEMPLFLAGS=
#
######################################################################
#
#  These are the options and libraries necessary to include the
#  Oracle libraries when linking with the DB kit.
#
#  NOTE:  ORACLE_HOME must be set as an environment variable
#         when running Oracle.
#
#

ORACLE_LINK =  -L$(ORACLE_HOME)/lib -lclntsh \
      -lnetv2 -lnttcp -lnetwork -lclient -lgeneric -lcommon -lmm \
                   -lepc -lncr -lcore4 -lnlsrtl3

#
#
######################################################################
######################################################################
#

######################################################################
# Options for building shared libs
######################################################################
SHLIB_LD=$(CPLUS)
GENERATE_DLLIB_COMMAND = $(GENERATE_DLLIB_FROM_OBJS_COMMAND)
ifdef INTEL_COMPILER
DLFLAGS         = -shared -mrelax
else
DLFLAGS         = -shared --relax
endif
DLLIB_SUFFIX    = so
LINK_STATIC_FLAG = -Wl,-Bstatic
LINK_SHARED_FLAG = -Wl,-Bdynamic

# platform dependent because Alpha UNIX can't use libagx.so
MACH_AGX_DLLIB = $(XP_LIB_DIR)/libagx

######################################################################
# end of linux_ia64/machinc.mk
######################################################################

