#			Copyright (c) 1993 by
#			Advanced Visual Systems Inc.
#			All Rights Reserved
#	
#	This software comprises unpublished confidential information of
#	Advanced Visual Systems Inc. and may not be used, copied or made
#	available to anyone, except in accordance with the license
#	under which it is furnished.
#	
#	This file is under Perforce control
#	$Id: //depot/express/fcs70/include/stdrule.mk#1 $
#	
###############################################################################
#
# Standard rules for Express lib and project targets
#
###############################################################################
# 

.SUFFIXES: .a .o .cxx .m .pto .f .E
.PRECIOUS: $(LLIB) $(DLLIBNAME)

ERRORS_FILE=$(SRCDIR)/ERRORS.$(MACHINE)
FILES_FILE=$(SRCDIR)/FILES.$(MACHINE)

# This rule should not get executed; it's only here to give a sensible
# error msg if you don't define any rules in your project's Makefile.
dummy:
	echo 'Error: No rules defined in project Makefile.'; /bin/false

# Compile, remembering which files compiled and which didn't.
.c.a:
	-cd $(XP_LIB_DIR); \
	$(COMPILE_C) -c $(SRCDIR)/$<
	-@cd $(XP_LIB_DIR); \
	if [ -f $% ] ; then \
	    echo $% >> $(FILES_FILE) ; \
	else \
	    echo $% >> $(ERRORS_FILE) ; /bin/false; \
	fi

.f.a:
	-cd $(XP_LIB_DIR); \
	$(COMPILE_F77) -c $(SRCDIR)/$<
	-@cd $(XP_LIB_DIR); \
	if [ -f $% ] ; then \
	    echo $% >> $(FILES_FILE) ; \
	else \
	    echo $% >> $(ERRORS_FILE) ; /bin/false; \
	fi

.cxx.a:	
	cd $(XP_LIB_DIR) ; \
	$(COMPILE_CXX) -c $(SRCDIR)/$*.cxx
	@cd $(XP_LIB_DIR); \
	if [ -f $% ] ; then \
	    echo $% >> $(FILES_FILE) ; \
	else \
	    echo $% >> $(ERRORS_FILE) ; /bin/false; \
	fi

.cxx.o:
	cd `dirname $<`; \
	$(COMPILE_CXX) -c `basename $<`

.cxx.E:
	cd `dirname $<`; \
	$(COMPILE_CXX) -c -E `basename $<` > `basename $@`

.c.o:
	cd `dirname $<`; \
	$(COMPILE_C) -c `basename $<`

.c.E:
	cd `dirname $<`; \
	$(COMPILE_C) -c -E `basename $<` > `basename $@`

.f.o:
	cd `dirname $<`; \
	$(COMPILE_F77) -c `basename $<`

.m.c:
	m4 $? > $@

.c.pto:
	- cat $? > src.c
	- cproto  -a -e -f4 -m"PTARGS" -d -I$(XP_ROOT) $(CFLAGS) -I/usr/include src.c > $*.h.pto
	- mv src.c $(?).pto

# HFILES is the list of includes newer than the last install
$(XP_LIB_DIR)/HFILES: $(INCLUDES)
	-echo $? >> $@

install_includes: $(XP_LIB_DIR)/HFILES
	-cp `cat $(XP_LIB_DIR)/HFILES |sort -u` $(INCDIR)
	@echo > $(XP_LIB_DIR)/HFILES

$(DLLIBNAME): $(LLIB)
	@echo "building shared library $(DLLIBNAME)"
	@$(GENERATE_DLLIB_COMMAND)

clean::
	$(RM) *.o a.out core
