/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/lib_vers.c#1 $
*/

/* HPs use $SHLIB_PATH to find shared libs.
 * Other systems use LD_LIBRARY_PATH.
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>	/* time_t */
#include <avs/f_utils.h>

DLL_IMPORT int OMmajor_version;	/* found in om/om_vers.c */
DLL_IMPORT int OMminor_version;	/* ditto */

#if defined(hpux) || defined(__hpux)
#  define LIBPATH_ENV_VAR "SHLIB_PATH"
#  define DLLIB_SUFFIX "sl"
#elif defined(__APPLE__) && defined(__MACH__)
#  define LIBPATH_ENV_VAR "DYLD_LIBRARY_PATH"
#  define DLLIB_SUFFIX "dylib"
#elif defined(MSDOS) || defined(_WIN32)
#  define LIBPATH_ENV_VAR "PATH"
#  define DLLIB_SUFFIX "dll"
#else
   /* Generic Unix */
#  define LIBPATH_ENV_VAR "LD_LIBRARY_PATH"
#  define DLLIB_SUFFIX "so"
#endif

#include <avs/version.h>

/* This structure isn't used in the current version (3.0).  The current
 * version only version-checks the OM library, and it does it by the
 * executable directly looking at variables stored in the OM, rather then
 * the reverse.  Other libs should use this struct and look for the V
 * object named by lib_func (which should have subobjs named
 * "major_version" and "minor_version") and check them against these
 * compiled-in numbers.
 */

static struct {
   char *libname;
   char *lib_func;
   int major_version;
   int minor_version;
} XPlib_versions[] = {
   {
#ifdef MSDOS
    "express",
#else
    "libom",
#endif
    "", XP_LIB_MAJOR_VERSION, XP_LIB_MINOR_VERSION },
   /* end of list: all 0s */
   { (char *)0, (char *)0, 0, 0 }
};

static char *
find_lib_in_path(char *libname)
{
   char path[2048];		/* arbitrary limit, yuck */
   char filename[128];		/* another one */
   char *found_path;
   char separator;

#ifdef MSDOS
   sprintf(path, "%s", getenv(LIBPATH_ENV_VAR));
   separator = ';';
#else
   sprintf(path, "/lib:/usr/lib:%s", getenv(LIBPATH_ENV_VAR));
   separator = ':';
#endif
   sprintf(filename, "%s.%s", libname, DLLIB_SUFFIX);
   found_path = FILEpath_find(filename, path, separator);
   if (found_path)
      return found_path;
   else
      return "(can't find anywhere in lib path)";
}

void
XPprint_lib_version_warning(char *libname,
			    int libmajor, int libminor,
			    int exemajor, int exeminor)
{
   char *s;
   if (getenv("XP_SUPPRESS_VERSION_WARNINGS") != NULL)
      return;
      
   printf(
      "WARNING: this version of express is designed to use version %d.%d of\n"
#ifdef MSDOS
      "dynamic load library \"%s\", but this version is %s: it is %d.%d.\n"
#else
      "shared library \"%s\", but this version is %s: it is %d.%d.\n"
#endif
      "It is likely that this library was found in the following place:\n"
      " %s\n"
      "If this is incorrect, please edit your %s env. variable.\n\n",
      exemajor, exeminor,
      libname,
      (libmajor > exemajor || (libmajor == exemajor &&
			       libminor > exeminor)) ? "newer" : "older",
      libmajor, libminor,
      (s = find_lib_in_path(libname)),
      LIBPATH_ENV_VAR);

   /* must free result of FILEpath_find() */
   if (s && s[0] == '/') free(s);
}

int
XPcheck_om_version(void)
{
   if (OMmajor_version != XP_LIB_MAJOR_VERSION) {
      XPprint_lib_version_warning(
#ifdef MSDOS
				  "express",
#else
				  "libom",
#endif
				  OMmajor_version, OMminor_version,
				  XP_LIB_MAJOR_VERSION, XP_LIB_MINOR_VERSION);
   }
   else if (OMminor_version > XP_LIB_MINOR_VERSION) {
      /* lib more recent than executable; OK, it's probably a patch */
   }
   else if (OMminor_version < XP_LIB_MINOR_VERSION) {
      /* executable more recent than lib */
      XPprint_lib_version_warning(
#ifdef MSDOS
				  "express",
#else
				  "libom",
#endif
				  OMmajor_version, OMminor_version,
				  XP_LIB_MAJOR_VERSION, XP_LIB_MINOR_VERSION);
   }
   /* otherwise they match perfectly.  Good! */
   return 1;
}
