/*
			Copyright (c) 1993 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/axis.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/dtype.h>
#include <avs/math.h>
#include <avs/om.h>
#include <avs/fld.h>

#define ERR_RETURN(A) ERRerror("axis",1,ERR_ORIG, A); return(0);
#define MAX_NAME_SIZE 256

#define  ALLOC_SIZE 1000

typedef struct _OUTmesh {
	xp_long nnodes;
	float *xyz;
	xp_long nline;
	xp_long *line_conn;
	xp_long size;
} OUTmesh;

static int add_line (OUTmesh *h, xp_long nline, int nspace, 
                     float *xyz1, float *xyz2);

/* 64-bit porting. Only Modified Internally */
int	DVaxis_update(elem)
    OMobj_id elem;
{
	OMobj_id out, out_m, e_id, lab_id, in_lab_id;
	int type, stat, ndig, count=0;
	xp_long size, lab_size;
	float *limits; 
	double reference, tick_step, mstep, tick_y_below, tick_y_above, 
	tick_z_below, tick_z_above, mscale, y_anno, z_anno;
	OUTmesh  h, hm;
	OMobj_id cell_set;
	int  i, j, nspace, ntick1, ntick2, mticks;
	float *xyz, xyz1[3], xyz2[3], *name_xyz;
	char label[MAX_NAME_SIZE], form[MAX_NAME_SIZE], *ptr=label, *axis_name;

	out = OMfind_subobj(elem,OMstr_to_name("out"),OM_OBJ_RD);

	out_m = OMfind_subobj(elem,OMstr_to_name("out_minor"),OM_OBJ_RD);

	e_id = OMfind_subobj(elem,OMstr_to_name("limits"),OM_OBJ_RD);
	type = OM_TYPE_FLOAT;
	size = 2;
	limits = (float *)NULL;
	stat = OMget_array_sz(e_id, &type, (char **)(&limits), &size, OM_GET_ARRAY_RD);
	if (stat != 1) {
		ERR_RETURN("cannot get axis limits");
	}

	if (OMget_name_real_val(elem, OMstr_to_name("reference"), &reference) != 1) {
		ERR_RETURN("cannot get axis reference");
	}
	if (OMget_name_real_val(elem, OMstr_to_name("tick_step"), &tick_step) != 1) {
		ERR_RETURN("cannot get axis step");
	}
	if (OMget_name_real_val(elem, OMstr_to_name("tick_y_below"), &tick_y_below) != 1) {
		ERR_RETURN("cannot get axis tick_y_below");
	}
	if (OMget_name_real_val(elem, OMstr_to_name("tick_y_above"), &tick_y_above) != 1) {
		ERR_RETURN("cannot get axis tick_y_above");
	}
	if (OMget_name_real_val(elem, OMstr_to_name("tick_z_below"), &tick_z_below) != 1) {
		ERR_RETURN("cannot get axis tick_z_below");
	}
	if (OMget_name_real_val(elem, OMstr_to_name("tick_z_above"), &tick_z_above) != 1) {
		ERR_RETURN("cannot get axis tick_z_above");
	}
	if (OMget_name_int_val(elem, OMstr_to_name("ndig"), &ndig) != 1) {
		ERR_RETURN("cannot get axis ndig");
	}
	if (OMget_name_int_val(elem, OMstr_to_name("minor_ticks"), &mticks) != 1) {
		ERR_RETURN("cannot get axis minor_ticks");
	}
	if (OMget_name_real_val(elem, OMstr_to_name("minor_scale"), &mscale) != 1) {
		ERR_RETURN("cannot get axis minor_scale");
	}
	if (OMget_name_real_val(elem, OMstr_to_name("y_anno"), &y_anno) != 1) {
		ERR_RETURN("cannot get axis y_anno");
	}
	if (OMget_name_real_val(elem, OMstr_to_name("z_anno"), &z_anno) != 1) {
		ERR_RETURN("cannot get axis z_anno");
	}

	if (OMget_name_str_val(elem, OMstr_to_name("axis_name"), &axis_name, 0) != 1)
		axis_name = strdup(" ");

	if (OMset_name_str_val(elem, OMstr_to_name("name"), axis_name) != 1) {
		ERR_RETURN("cannot set axis name");
	}
	if (axis_name)
		free(axis_name);

	in_lab_id = OMfind_subobj(elem, OMstr_to_name("axis_labels"), OM_OBJ_RD);
	if (OMget_array_size(in_lab_id, &lab_size) != 1 || lab_size == 0)
		lab_size = 0;

	lab_id = OMfind_subobj(elem, OMstr_to_name("labels"), OM_OBJ_RW);

	/********************************/
	/*   Free pre-allocated arrays  */
	/********************************/
	if (FLDset_ncell_sets (out, 0) != 1) {
		ERR_RETURN("Error setting ncell_sets");
	}
	if (FLDset_nnodes (out, 0) != 1) {
		ERR_RETURN("Error setting nnodes");
	}
	h.xyz = NULL;
	if (FLDset_coord(out, h.xyz, 0, OM_SET_ARRAY_FREE) != 1) {
		ERR_RETURN("Error setting coord");
	}
	if (FLDset_ncell_sets (out_m, 0) != 1) {
		ERR_RETURN("Error setting ncell_sets");
	}
	if (FLDset_nnodes (out_m, 0) != 1) {
		ERR_RETURN("Error setting nnodes");
	}
	hm.xyz = NULL;
	if (FLDset_coord(out_m, hm.xyz, 0, OM_SET_ARRAY_FREE) != 1) {
		ERR_RETURN("Error setting coord");
	}
	/****
	if (limits[0] == limits[1]) {
		ARRfree(limits);
		return(0);
	}
	***/

	if (lab_size) {
		if (lab_size == 1) {
			tick_step = 0;
			ntick1 = 1;
			ntick2 = 0;
		}
		else {
			tick_step = (limits[1]-limits[0])/(lab_size-1);
			if (tick_step != 0.0)
				ntick1 = (limits[1]-reference)/tick_step+1;
			else
				ntick1 = 0;
			if (ntick1 <= 1) 
				ntick1 = 0;
			ntick2 = (int)lab_size - ntick1;
			if (ntick2 <= 1) {
				ntick2 = 0;
				ntick1 = (int)lab_size;
			}
		}
	}
	else {
		if (tick_step != 0.0)
			ntick1 = (limits[1]-reference)/tick_step+1;
		else
			ntick1 = 0;
		if (ntick1 <= 1) 
			ntick1 = 0;
		if (tick_step != 0.0)
			ntick2 = (reference-limits[0])/tick_step+1;
		else
			ntick2 = 0;
		if (ntick2 <= 1) 
			ntick2 = 0;
	}
	OMset_name_int_val(elem, OMstr_to_name("ntick"), ntick1+ntick2);
	
	nspace = 3;

	h.nnodes = 0;
	h.nline = 0;
	h.size = ALLOC_SIZE;
	h.xyz = (float *)ARRalloc(NULL, DTYPE_FLOAT, nspace*h.size, NULL);
	h.line_conn = (xp_long *)ARRalloc(NULL, DTYPE_LONG, h.size, NULL);

	if (mticks) {
		mstep = tick_step/(mticks+1);
		hm.nnodes = 0;
		hm.nline = 0;
		hm.size = ALLOC_SIZE;
		hm.xyz = (float *)ARRalloc(NULL, DTYPE_FLOAT, nspace*h.size, NULL);
		hm.line_conn = (xp_long *)ARRalloc(NULL, DTYPE_LONG, h.size, NULL);
	}

	/* draw line for axis */
	xyz1[0] = limits[0];
	xyz1[1] = 0.0;
	xyz1[2] = 0.0;
	xyz2[0] = limits[1];
	xyz2[1] = 0.0;
	xyz2[2] = 0.0;
	stat = add_line (&h, 1, nspace, xyz1, xyz2);
	if (stat !=1) {
		ERR_RETURN("cannot create axis");
	}

	name_xyz = (float *)OMret_name_array_ptr(elem, OMstr_to_name("name_xyz"),
						 OM_GET_ARRAY_RW, &size, NULL);	
	name_xyz[0] = 0.5*(limits[0]+limits[1]);
	name_xyz[1] = 3*y_anno;
	name_xyz[2] = 3*z_anno;

	/* draw ticks in + direction */

	e_id = OMfind_subobj(elem,OMstr_to_name("xyz"),OM_OBJ_RW);
	type = OM_TYPE_FLOAT;
	size = 0;
	xyz = (float *)NULL;
	OMget_array_sz(e_id, &type, (char **)(&xyz), &size, OM_GET_ARRAY_RW);

	sprintf(form, "%1s%d%1s", "%.",ndig,"f");
	for (i=0; i< ntick1; i++) {
		xyz1[0] = reference+i*tick_step;
		xyz1[1] = (-1)*tick_y_below;
		xyz1[2] = 0;
		xyz2[0] = xyz1[0];
		xyz2[1] = tick_y_above;
		xyz2[2] = 0;
		stat = add_line (&h, 1, nspace, xyz1, xyz2);
		if (stat !=1) {
			ERR_RETURN("cannot create tick");
		}
		xyz1[1] = 0;
		xyz1[2] = (-1)*tick_z_below;
		xyz2[1] = 0;
		xyz2[2] = tick_z_above;
		stat = add_line (&h, 1, nspace, xyz1, xyz2);
		if (stat !=1) {
			ERR_RETURN("cannot create tick");
		}
		if (lab_size) {
			if (OMget_str_array_val(in_lab_id, count, &ptr, MAX_NAME_SIZE) != 1) {
				ERR_RETURN("cannot get axis_labels\n");
			}
		}
		else
			sprintf(label,form,xyz1[0]);

		if ((stat = OMset_str_array_val(lab_id, count, label)) != 1) {
			ERR_RETURN("cannot set labels");
		}
		xyz[count*3] = xyz1[0];
		xyz[count*3+1] = y_anno;
		xyz[count*3+2] = z_anno;
		count++;

		if (mticks && i<ntick1-1) {
			for (j=0; j<mticks; j++) {
				xyz1[0] = reference+i*tick_step+(j+1)*mstep;
				xyz1[1] = (-1)*mscale*tick_y_below;
				xyz1[2] = 0;
				xyz2[0] = xyz1[0];
				xyz2[1] = mscale*tick_y_above;
				xyz2[2] = 0;
				stat = add_line (&hm, 1, nspace, xyz1, xyz2);
				if (stat !=1) {
					ERR_RETURN("cannot create tick");
				}
				xyz1[1] = 0;
				xyz1[2] = (-1)*mscale*tick_z_below;
				xyz2[1] = 0;
				xyz2[2] = mscale*tick_z_above;
				stat = add_line (&hm, 1, nspace, xyz1, xyz2);
				if (stat !=1) {
					ERR_RETURN("cannot create tick");
				}
			}
		}
			
	}
	/* draw ticks in - direction */

	for (i=0; i< ntick2; i++) {
		xyz1[0] = reference-i*tick_step;
		xyz1[1] = (-1)*tick_y_below;
		xyz1[2] = 0;
		xyz2[0] = xyz1[0];
		xyz2[1] = tick_y_above;
		xyz2[2] = 0;
		stat = add_line (&h, 1, nspace, xyz1, xyz2);
		if (stat !=1) {
			ERR_RETURN("cannot create tick");
		}
		xyz1[1] = 0;
		xyz1[2] = (-1)*tick_z_below;
		xyz2[1] = 0;
		xyz2[2] = tick_z_above;
		stat = add_line (&h, 1, nspace, xyz1, xyz2);
		if (stat !=1) {
			ERR_RETURN("cannot create tick");
		}
			
		if (lab_size) {
			if (OMget_str_array_val(in_lab_id, count, &ptr, MAX_NAME_SIZE) != 1) {
				ERR_RETURN("cannot get axis_labels\n");
			}
		}
		else
			sprintf(label,form,xyz1[0]);

		if ((stat = OMset_str_array_val(lab_id, count, label)) != 1) {
			ERR_RETURN("cannot set labels");
		}
		xyz[count*3] = xyz1[0];
		xyz[count*3+1] = y_anno;
		xyz[count*3+2] = z_anno;
		count++;

		if (mticks && i<ntick2-1) {
			for (j=0; j<mticks; j++) {
				xyz1[0] = reference-i*tick_step-(j+1)*mstep;
				xyz1[1] = (-1)*mscale*tick_y_below;
				xyz1[2] = 0;
				xyz2[0] = xyz1[0];
				xyz2[1] = mscale*tick_y_above;
				xyz2[2] = 0;
				stat = add_line (&hm, 1, nspace, xyz1, xyz2);
				if (stat !=1) {
					ERR_RETURN("cannot create tick");
				}
				xyz1[1] = 0;
				xyz1[2] = (-1)*mscale*tick_z_below;
				xyz2[1] = 0;
				xyz2[2] = mscale*tick_z_above;
				stat = add_line (&hm, 1, nspace, xyz1, xyz2);
				if (stat !=1) {
					ERR_RETURN("cannot create tick");
				}
			}
		}
			
	}
		
	if (FLDset_nspace (out, nspace) != 1) {
		ERR_RETURN("Error setting nspace");
	}
	if (FLDset_nnodes (out, h.nnodes) != 1) {
		ERR_RETURN("Error setting nnodes");
	}
	if (h.nnodes) {
		if (FLDset_coord(out, h.xyz, nspace*h.nnodes, OM_SET_ARRAY_FREE) != 1) {
			ERR_RETURN("Error setting coord");
		}
		if (FLDset_ncell_sets (out, 0) != 1) {
			ERR_RETURN("Error setting ncell_sets");
		}
		if (FLDadd_cell_set(out, "Line") != 1) {
			ERR_RETURN("Error setting cell type");
		}
		if (FLDget_cell_set(out, 0, &cell_set) != 1) {
			ERR_RETURN("Error getting cell set");
		}
		if (FLDset_ncells(cell_set, h.nline) != 1) {
			ERR_RETURN("Error setting ncells");
		}
		if (FLDset_node_connect(cell_set, h.line_conn, 2*h.nline,
					OM_SET_ARRAY_FREE) != 1) {
			ERR_RETURN("Error setting cell connect list");
		}
	}
	else {
		ARRfree(h.line_conn);
		ARRfree(h.xyz);
	}
	if (mticks) {
		if (FLDset_nspace (out_m, nspace) != 1) {
			ERR_RETURN("Error setting nspace");
		}
		if (FLDset_nnodes (out_m, hm.nnodes) != 1) {
			ERR_RETURN("Error setting nnodes");
		}
		if (hm.nnodes) {
			if (FLDset_coord(out_m, hm.xyz, nspace*hm.nnodes, OM_SET_ARRAY_FREE) != 1) {
				ERR_RETURN("Error setting coord");
			}
			if (FLDset_ncell_sets (out_m, 0) != 1) {
				ERR_RETURN("Error setting ncell_sets");
			}
			if (FLDadd_cell_set(out_m, "Line") != 1) {
				ERR_RETURN("Error setting cell type");
			}
			if (FLDget_cell_set(out_m, 0, &cell_set) != 1) {
				ERR_RETURN("Error getting cell set");
			}
			if (FLDset_ncells(cell_set, hm.nline) != 1) {
				ERR_RETURN("Error setting ncells");
			}
			if (FLDset_node_connect(cell_set, hm.line_conn, 2*hm.nline,
						OM_SET_ARRAY_FREE) != 1) {
				ERR_RETURN("Error setting cell connect list");
			}
		}
		else {
			ARRfree(hm.line_conn);
			ARRfree(hm.xyz);
		}
	}
	if (xyz)
		ARRfree(xyz);
	if (name_xyz)
		ARRfree(name_xyz);
	if (limits)
		ARRfree(limits);
	return(1);
}

/* 64-bit porting. Directly Modified */
static int add_line (h, nline, nspace, xyz1, xyz2)
    OUTmesh *h;
    xp_long nline;
    int nspace;
    float *xyz1, *xyz2;
{
	xp_long  i;

	if (h->nnodes+2*nline >= h->size) {
		i = 2*nline/ALLOC_SIZE+1;
		h->size += i*ALLOC_SIZE;
		h->xyz = (float *)ARRrealloc(h->xyz, DTYPE_FLOAT, nspace*h->size, NULL);
		h->line_conn = (xp_long *)ARRrealloc(h->line_conn, DTYPE_LONG, h->size, NULL);
		if (h->xyz == NULL || h->line_conn == NULL)
			return(0);
	}
	memcpy(h->xyz+h->nnodes*nspace, xyz1, nspace*nline*sizeof(float));
	memcpy(h->xyz+(h->nnodes+nline)*nspace, xyz2, nspace*nline*sizeof(float));
	for (i=0; i<nline; i++) {
		h->line_conn[2*h->nline+2*i] = h->nnodes+i;
		h->line_conn[2*h->nline+2*i+1] = h->nnodes+nline+i;
	}
	h->nnodes += 2*nline;
	h->nline += nline;
	return(1);
}

