/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/cellnode.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/fld.h>
#include <avs/arr.h>
#include <avs/dv_util.h>

#define ERR_RETURN(A) ERRerror("cell_to_node", 0, ERR_ORIG, A); return(0);

#define MAX_LABEL_SIZE  1024

int FUNCcell_to_node(OMobj_id in, int ncomp, int *comps, int order,
                     OMobj_id out);

/* 64-bit porting. Only Modified Internally */
int DVcell_to_node_update(OMobj_id elem_id)
{
	OMobj_id in, out, tmp;
	int stat, type, *comps, order;
	xp_long ncomp;

	in = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
	if (OMis_null_obj(in)) {
		ERR_RETURN("cannot get in");
	}
	out = OMfind_subobj(elem_id, OMstr_to_name("out_nd"), OM_OBJ_RW);
	if (OMis_null_obj(out)) {
		ERR_RETURN("cannot get out");
	}
	tmp = OMfind_subobj(elem_id, OMstr_to_name("order"), OM_OBJ_RD);
	if (OMis_null_obj(tmp)) {
		ERR_RETURN("cannot get order");
	}
	stat = OMget_int_val(tmp, &order);
	if (stat < 0) {
		ERR_RETURN("cannot get order value");
	}
	else if (stat == 0)
		order = 0;

	tmp = OMfind_subobj(elem_id, OMstr_to_name("comps"), OM_OBJ_RD);
	type = OM_TYPE_INT;
	ncomp = 0;
	comps = (int *)NULL;
	stat = OMget_array_sz(tmp, &type, (char **)(&comps), &ncomp, OM_GET_ARRAY_RD);
	if (stat != 1) {
		ERR_RETURN("cannot get value of components");
	}

	stat = FUNCcell_to_node(in, (int)ncomp, comps, order, out);
	ARRfree(comps);
	return(stat);
}

/* 64-bit porting. Only Modified Internally */
int FUNCcell_to_node(OMobj_id in, int ncomp, int *comps, int order,
                     OMobj_id out)
{
	int    stat, cs, comp, cell_ncomp, dtype, null_flag, rnull_flag, nsets, veclen;
	xp_long size, nnodes;
	char   label[MAX_LABEL_SIZE], units[MAX_LABEL_SIZE];
	char   *mesh_info, *cell_data, *node_data, *ptr1, *ptr2;
	double null_value, rnull_value, min, max;
	OMobj_id cell_set;

	if (FLDget_nnodes(in, &nnodes) != 1) {
		return(0);
	}
	if (nnodes == 0) {
		if (FLDset_node_data_ncomp (out, 0) != 1) {
			ERR_RETURN("Error setting nnode_data");
		}
		return(1);
	}
	if (FLDget_ncell_sets(in, &nsets) != 1) {
		return(0);
	}
	stat = FLDget_mesh_info(in, &mesh_info);
	if (!stat) {
		ERR_RETURN("cannot create field info");
	}
	if (FLDset_node_data_ncomp (out, ncomp) != 1) {
		ERR_RETURN("Error setting nnode_data");
	}
	rnull_flag=0;
	rnull_value=0;
	for (comp=0; comp<ncomp; comp++) {
		if (FLDget_cell_data_minmax_total(in, comps[comp],
						  (char *)&min, (char *)&max) != 1) {
			ERR_RETURN("Error getting cell minmax");
		}
		node_data = NULL;
		for (cs=0; cs<nsets; cs++) {
			if (FLDget_cell_set(in, cs, &cell_set) != 1) {
				ERR_RETURN("cannot get cell set");
			}
			if (FLDget_cell_data_ncomp(cell_set, &cell_ncomp) != 1) {
				ERR_RETURN("Error getting ncomp");
			}
			if (comps[comp] >= cell_ncomp) {
				sprintf(label,"cell set %d has no data component %d, skipping", 
					cs, comps[comp]);
				ERRerror("cell_to_node",1,ERR_ORIG,label);
				continue;
			}
			if (FLDget_cell_data(cell_set, comps[comp], &dtype, &cell_data, 
					     &size, OM_GET_ARRAY_RD) != 1) {
				ERR_RETURN("Error setting cell data");
			}
			if (rnull_flag == 0) {
				if (FLDget_cell_null_data(cell_set, comps[comp], &null_flag, (char *)&null_value) != 1) {
					ERR_RETURN("cannot get null data");
				}
				if (null_flag) {
					rnull_flag = 1;
					memcpy(&rnull_value, &null_value, sizeof(double));
				}
			}
			if (cs == 0) {
				stat = FLDget_cell_data_label(cell_set, comps[comp], label, MAX_LABEL_SIZE);
				if (stat < 0)
					return(stat);
				else if (stat == 0)
					strcpy(label, "Cell to Node");
				stat = FLDget_cell_data_units(cell_set, comps[comp], units, MAX_LABEL_SIZE);
				if (stat < 0)
					return(stat);
				else if (stat == 0)
					strcpy(units, "");
				if (FLDget_cell_data_veclen(cell_set, comps[comp], &veclen) != 1) {
					ERR_RETURN("Error getting cell veclen");
				}
				if (FLDset_node_data_comp (out, comp, veclen, label, units) != 1) {
					ERR_RETURN("Error setting mode data component");
				}
				if (FLDget_node_data(out, comp, &dtype, &node_data, &size, OM_GET_ARRAY_WR) != 1) {
					ERR_RETURN("Error getting node data");
				}
				if (null_flag) {
					if (FLDset_node_null_data(out, comp, (char *)&null_value, dtype) != 1) {
						ERR_RETURN("Error setting null value");
					}
				}
				else {
					if (FLDset_node_null_flag(out, comp, 0) != 1) {
						ERR_RETURN("Error setting null flag");
					}
				}

			}
			stat = UTILcell_to_node(mesh_info, cs, dtype, cell_data, veclen, 
						rnull_flag, (char *)&rnull_value, order, node_data, &ptr1, &ptr2);
			if(stat != 1) {
				ERR_RETURN("Error computing cell to node data");
			}
			ARRfree(cell_data);

		}
		if (node_data)
			ARRfree(node_data);
		if (FLDset_node_data_minmax(out, comp, (char *)&min, (char *)&max, dtype) != 1) {
			ERR_RETURN("Error setting node minmax");
		}
	}
	FLDfree_mesh_info(mesh_info);
	return(1);
}



