/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/clamp.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/dtype.h>
#include <avs/fld.h>
#include <avs/arr.h>
#include <avs/dv_util.h>

#define ERR_RETURN(A) ERRerror("clamp",1,ERR_ORIG, A); return(0);
#define MAX_NAME_SIZE 1024

int FUNCclamp (OMobj_id in, int comp, int below, double min_val, int above, 
               double max_val, int reset, OMobj_id out);

int DVclamp_update(OMobj_id elem_id)
{
	OMobj_id in, out,e_id;
	int  comp;
	int  below, above, reset;
	double min_val, max_val;

	in = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
	out = OMfind_subobj(elem_id, OMstr_to_name("out"), OM_OBJ_RW);
	e_id = OMfind_subobj(elem_id, OMstr_to_name("component"),
				 OM_OBJ_RD);
	OMget_int_val(e_id, &comp);
	e_id = OMfind_subobj(elem_id, OMstr_to_name("below"),
				 OM_OBJ_RD);
	OMget_int_val(e_id, &below);
	e_id = OMfind_subobj(elem_id, OMstr_to_name("above"),
				 OM_OBJ_RD);
	OMget_int_val(e_id, &above);
	e_id = OMfind_subobj(elem_id, OMstr_to_name("min_value"),
				 OM_OBJ_RD);
	OMget_real_val(e_id, &min_val);
	e_id = OMfind_subobj(elem_id, OMstr_to_name("max_value"),
				 OM_OBJ_RD);
	OMget_real_val(e_id, &max_val);
	e_id = OMfind_subobj(elem_id, OMstr_to_name("reset_minmax"),
				 OM_OBJ_RD);
	OMget_int_val(e_id, &reset);

	if (FUNCclamp(in, comp, below, min_val, above, max_val, reset, out)) {
		return(1);
	}
	else return(0);
}

/* 64-bit porting. Only Modified Internally */
int FUNCclamp (OMobj_id in, int comp, int below, double min_val, int above,
               double max_val, int reset, OMobj_id out)
{
	xp_long nnodes, size;
	int   data_type, veclen, null_flag, data_id;
	char   *in_node_data, *out_node_data;
	double null_value;
	char  label[MAX_NAME_SIZE], units[MAX_NAME_SIZE];

	if (FLDget_nnodes(in, &nnodes) != 1) {
		ERR_RETURN("cannot get nnodes");
	}

	if (FLDset_nnodes (out, nnodes) != 1) {
		ERR_RETURN("Error setting nnodes");
	}
	if (FLDset_node_data_ncomp (out, 1) != 1) {
		ERR_RETURN("Error setting nnode_data");
	}
	if (FLDget_node_data_veclen(in, 0, &veclen) != 1) {
		ERR_RETURN("Error getting veclen");
	}
	if (comp >= veclen) {
		ERRerror("clamp", 0, ERR_ORIG,
                         "component is out of range, assume 0-th");
		comp = 0;
	}

	if (FLDget_node_data_label(in, 0, label, MAX_NAME_SIZE) != 1) {
		strcpy(label, "clamped_data");
	}
	if (FLDget_node_data_units(in, 0, units, MAX_NAME_SIZE) != 1) {
		strcpy(units, "");
	}
	if (FLDset_node_data_comp (out, 0, veclen, label, units) != 1) {
		ERR_RETURN("Error setting node component");
	}
	if (FLDget_node_data_id(in, 0, &data_id) == 1)
		FLDset_node_data_id(out, 0, data_id);

	if (FLDget_node_data(in, 0, &data_type, &in_node_data,
			     &size, OM_GET_ARRAY_RD) != 1) {
		ERR_RETURN("cannot get node data");
	}
	if (FLDget_node_null_data(in, 0, &null_flag, (char *)&null_value) != 1) {
		ERR_RETURN("cannot get null data");
	}
	if (FLDget_node_data(out, 0, &data_type, &out_node_data,
			     &size, OM_GET_ARRAY_WR) != 1) {
		ERR_RETURN("Error setting node data");
	}

	/* UTILclamp does _not_ copy over unclamped values */
	memcpy(out_node_data, in_node_data,
	       (size_t)nnodes*veclen*DTYPEtype_size[data_type]);

	UTILclamp(nnodes, in_node_data, veclen, comp, data_type,
		  null_flag, (char *)&null_value,
		  below, min_val, above, max_val, out_node_data);
	if (null_flag) {
		if (FLDset_node_null_data(out, 0, (char *)&null_value, data_type) != 1) {
			ERR_RETURN("Error setting null value");
		}
	}
	else {
		if (FLDset_node_null_flag(out, 0, 0) != 1) {
			ERR_RETURN("Error setting null flag");
		}
	}
	if (reset) {
		if (FLDreset_node_minmax(out, 0) != 1) {
			ERR_RETURN("Error resetting node minmax");
		}
		if (FLDreset_node_minmax_vec(out, 0) != 1) {
			ERR_RETURN("Error resetting node minmax vec");
		}
	}
	else {
		if (FLDcopy_node_minmax(in, out, 0, 0) != 1) {
			ERR_RETURN("Error copying node minmax");
		}
		if (FLDcopy_node_minmax_vec(in, out, 0, 0) != 1) {
			ERR_RETURN("Error copying node minmax vec");
		}
	}
	ARRfree(in_node_data);
	ARRfree(out_node_data);
	return(1);
}
