/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/cmp_ext.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/math.h>
#include <avs/om.h>
#include <avs/fld.h>
#include <avs/arr.h>
#include <avs/dv_util.h>

#define ERR_RETURN(A) ERRerror("compute_extent",1,ERR_ORIG, A); return(0);

int DVcompute_extent_update(OMobj_id elem_id)
{
	OMobj_id in, out, elem_min, elem_max;
	int nspace, stat;
	char *field;
	float min_ext[3], max_ext[3];

	in = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
	out = OMfind_subobj(elem_id, OMstr_to_name("tmp_coord"), OM_OBJ_RD);

	stat = FLDget_mesh_info(in, &field);
	if (!stat) {
		ERR_RETURN("cannot create cell table");
	}
	if (FLDget_nspace (in, &nspace) != 1) {
		ERR_RETURN("Error getting nspace");
	}

	UTILfield_extent(field, min_ext, max_ext);

	elem_min = OMfind_subobj(out, OMstr_to_name("min_vec"),
				 OM_OBJ_RW);
	if (OMis_null_obj(elem_min)) {
		ERR_RETURN("Cannot find min extent");
	}
	elem_max = OMfind_subobj(out, OMstr_to_name("max_vec"),
				 OM_OBJ_RW);
	if (OMis_null_obj(elem_max)) {
		ERR_RETURN("Cannot find max extent");
	}
	stat = OMset_array(elem_min, DTYPE_FLOAT, (char *)min_ext,
			   nspace, OM_SET_ARRAY_COPY);
	if (stat != 1) {
		ERR_RETURN("Error setting min extent");
	}
	stat = OMset_array(elem_max, DTYPE_FLOAT, (char *)max_ext,
			   nspace, OM_SET_ARRAY_COPY);
	if (stat != 1) {
		ERR_RETURN("Error setting max extent");
	}

	FLDfree_mesh_info (field);
	return(1);
}

int DVmesh_extent_update(OMobj_id elem_id)
{
	OMobj_id in, min_id, max_id;
	int i, stat;
	float min[3], max[3], xform[4][4];
	double ext;

	in = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
	min_id = OMfind_subobj(elem_id, OMstr_to_name("min_ext"), OM_OBJ_RW);
	max_id = OMfind_subobj(elem_id, OMstr_to_name("max_ext"), OM_OBJ_RW);

	for (i=0; i<3; i++) {
		min[i]=0;
		max[i]=0;
	}
	if (FLDget_coord_extent(in, min, max) != 1) {
		ERR_RETURN("cannot get extents");
	}
	stat = FLDget_xform(in, (float *)xform);
	if (stat < 0) {
		ERR_RETURN("cannot get xform for in");
	}
	else if (stat == 1 && !MATmat_is_identity((float *)xform, 4)) {
		MATvec3_mat4_multiply(min, (Matr4 *)xform);
		MATvec3_mat4_multiply(max, (Matr4 *)xform);
	}

	stat = OMset_array(min_id, DTYPE_FLOAT, (char *)min, 3, OM_SET_ARRAY_COPY);
	if (stat != 1) {
		ERR_RETURN("Error setting min extent");
	}
	stat = OMset_array(max_id, DTYPE_FLOAT, (char *)max, 3, OM_SET_ARRAY_COPY);
	if (stat != 1) {
		ERR_RETURN("Error setting max extent");
	}
	for (ext=0.0,i=0; i<3; i++)
		ext += (max[i]-min[i])*(max[i]-min[i]);
	ext = sqrt(ext);

	OMset_name_real_val(elem_id, OMstr_to_name("extent"), ext);

	return(1);
}
