/*
			Copyright (c) 1996 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/crd_math.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>

#define ERR_RETURN(A) ERRerror("coord_math", 0, ERR_ORIG, A); return(0);

static char form[256]="in%d.coordinates.values[][%d]";

int DVcoord_math_update(OMobj_id elem_id)
{
	OMobj_id op_id, id, nspace_id;
	char  *oper, *p, sym, *str, num[2], string[1024];
	int nspace, coord, stat, n, len;

	nspace_id = OMfind_subobj(elem_id, OMstr_to_name("nspace"), OM_OBJ_RD);
	if (OMis_null_obj(nspace_id))
		return(0);

	stat = OMget_int_val(nspace_id, &nspace);
	if (stat != 1)
		return(0);

	/*
	 *  Y coordinate
	 */
	if (nspace <= 0)
		return(0);
	op_id = OMfind_subobj(elem_id, OMstr_to_name("operation_x"), OM_OBJ_RD);
	if (OMis_null_obj(op_id))
		return(0);
	oper = NULL;
	stat = OMget_str_val(op_id, &oper, 0);
	if (stat != 1 || oper == NULL)
		return(0);

	sym = '#';
	p = oper;
	str = string;
	strcpy(str,"cache(");
	len = 6;
	while (*p) {
		if (*p == sym) {
			p++;
			strncpy(num, p, 1);
			num[1] = 0;
			sscanf(num, "%d", &n);
			if (n<1 || n>4) {
				ERR_RETURN("Bad port index must be [1-4]");
			}
			p++;
			if (*p == 'x' || *p == 'X')
				coord = 0;
			else if (*p == 'y' || *p == 'Y')
				coord = 1;
			else if (*p == 'z' || *p == 'Z')
				coord = 2;
			else {
				ERR_RETURN("Bad coordinate,  must be x, y or z");
			}

			sprintf(str+len, form, n, coord);
			len = len + (int)strlen(form)-2;
		}
		else
			str[len++] = *p;
		p++;
	}
	str[len]= *p;
	strcat(str,")");

	id = OMfind_subobj (elem_id, OMstr_to_name("x_coord"),
			    OM_OBJ_RW);
	if (OMis_null_obj(id))
		return(0);

	stat = OMparse_obj_ref(id,string);
	if (stat != 1)
		return(stat);
	if (oper)
		free(oper);

	/*
	 *  Y coordinate
	 */
	if (nspace <= 1)
		return(1);
	op_id = OMfind_subobj(elem_id, OMstr_to_name("operation_y"), OM_OBJ_RD);
	if (OMis_null_obj(op_id))
		return(0);
	oper = NULL;
	stat = OMget_str_val(op_id, &oper, 0);
	if (stat != 1 || oper == NULL)
		return(0);

	sym = '#';
	p = oper;
	str = string;
	strcpy(str,"cache(");
	len = 6;
	while (*p) {
		if (*p == sym) {
			p++;
			strncpy(num, p, 1);
			num[1] = 0;
			sscanf(num, "%d", &n);
			if (n<1 || n>4) {
				ERR_RETURN("Bad port index must be [1-4]");
			}
			p++;
			if (*p == 'x' || *p == 'X')
				coord = 0;
			else if (*p == 'y' || *p == 'Y')
				coord = 1;
			else if (*p == 'z' || *p == 'Z')
				coord = 2;
			else {
				ERR_RETURN("Bad coordinate,  must be x, y or z");
			}

			sprintf(str+len, form, n, coord);
			len = len + (int)strlen(form)-2;
		}
		else
			str[len++] = *p;
		p++;
	}
	str[len]= *p;
	strcat(str,")");

	id = OMfind_subobj (elem_id, OMstr_to_name("y_coord"),
			    OM_OBJ_RW);
	if (OMis_null_obj(id))
		return(0);

	stat = OMparse_obj_ref(id,string);
	if (stat != 1)
		return(stat);
	if (oper)
		free(oper);

	/*
	 *  Z coordinate
	 */
	if (nspace <= 2)
		return(1);
	op_id = OMfind_subobj(elem_id, OMstr_to_name("operation_z"), OM_OBJ_RD);
	if (OMis_null_obj(op_id))
		return(0);
	oper = NULL;
	stat = OMget_str_val(op_id, &oper, 0);
	if (stat != 1 || oper == NULL)
		return(0);

	sym = '#';
	p = oper;
	str = string;
	strcpy(str,"cache(");
	len = 6;
	while (*p) {
		if (*p == sym) {
			p++;
			strncpy(num, p, 1);
			num[1] = 0;
			sscanf(num, "%d", &n);
			if (n<1 || n>4) {
				ERR_RETURN("Bad port index must be [1-4]");
			}
			p++;
			if (*p == 'x' || *p == 'X')
				coord = 0;
			else if (*p == 'y' || *p == 'Y')
				coord = 1;
			else if (*p == 'z' || *p == 'Z')
				coord = 2;
			else {
				ERR_RETURN("Bad coordinate,  must be x, y or z");
			}

			sprintf(str+len, form, n, coord);
			len = len + (int)strlen(form)-2;
		}
		else
			str[len++] = *p;
		p++;
	}
	str[len]= *p;
	strcat(str,")");

	id = OMfind_subobj (elem_id, OMstr_to_name("z_coord"),
			    OM_OBJ_RW);
	if (OMis_null_obj(id))
		return(0);

	stat = OMparse_obj_ref(id,string);
	if (stat != 1)
		return(stat);
	if (oper)
		free(oper);

	return(1);
}

