/*
			Copyright (c) 1997 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/edges.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/fld.h>
#include <avs/arr.h>
#include <avs/dv_util.h>

#define METHOD_SUCCESS 1
#define METHOD_FAILURE 0

#define ERR_RETURN(A) {ERRerror("edges", 0, ERR_ORIG, A); \
                       return METHOD_FAILURE;}

int FUNCedges (OMobj_id in, OMobj_id out_sets, OMobj_id out);

int DVedges_update(OMobj_id elem_id)
{
    OMobj_id in, out, out_sets;
    in = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
    out = OMfind_subobj(elem_id, OMstr_to_name("out_cells"), OM_OBJ_RW);
    out_sets = OMfind_subobj(elem_id, OMstr_to_name("out_sets"), OM_OBJ_RW);

    if (FUNCedges(in, out_sets, out) == METHOD_SUCCESS) {
        return METHOD_SUCCESS;
    }
    else return METHOD_FAILURE;
}


/* 64-bit porting. Only Modified Internally */
int
DV_ARRedges_update(OMobj_id elem_id, OMevent_mask event_mask, int seq_num)
{
    OMobj_id in_arr, out_cells_arr, out_sets_arr;
    xp_long i, num_fields;

    OMobj_id in, out_cells, out_sets;
    int stat;

    in_arr = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);

    out_sets_arr  = OMfind_subobj(elem_id, OMstr_to_name("out_sets"),  OM_OBJ_RW);
    out_cells_arr = OMfind_subobj(elem_id, OMstr_to_name("out_cells"), OM_OBJ_RW);

    stat = OMget_array_size( in_arr, &num_fields );
    if( stat != OM_STAT_SUCCESS ) return METHOD_FAILURE;

    stat = OMset_array_size( out_sets_arr,  num_fields );
    if( stat != OM_STAT_SUCCESS ) return METHOD_FAILURE;
    stat = OMset_array_size( out_cells_arr, num_fields );
    if( stat != OM_STAT_SUCCESS ) return METHOD_FAILURE;

    for( i = 0; i < num_fields; ++i ) {
        stat = OMget_array_val( in_arr, i, &in, OM_OBJ_RD );
        if( stat != OM_STAT_SUCCESS ) continue;

        stat = OMget_array_val( out_sets_arr, i, &out_sets, OM_OBJ_RW );
        if( stat != OM_STAT_SUCCESS ) continue;
        stat = OMget_array_val( out_cells_arr, i, &out_cells, OM_OBJ_RW );
        if( stat != OM_STAT_SUCCESS ) continue;

        stat = FUNCedges( in, out_sets, out_cells );
#if 0
        if( stat != METHOD_SUCCESS ) {
            ERRerror( "edges", 1, ERR_ORIG,
                      "Error while processing field: %d", i );
        }
#endif
    }

    return METHOD_SUCCESS;
}


/* 64-bit porting. Only Modified Internally */
int FUNCedges (OMobj_id in, OMobj_id out_sets, OMobj_id out)
{
	int   cs, nc, nsets, cell_nnodes, stat;
	xp_long ncells, nnodes;
	int   ndim, cell_nfaces, fnl_size;
	xp_long size, *node_list;
	xp_long *face_node_list;
	int   *face_nnodes, *face_corner_nnodes, cell_corner_nnodes;
	xp_long out_ncells, *out_node_list;
	OMobj_id   cell_set, sets_id, out_set;

	if (FLDset_ncell_sets (out_sets, 0) != 1) {
		ERR_RETURN("Error setting ncell_sets");
	}

	sets_id = OMfind_subobj(out, OMstr_to_name("cell_set"), OM_OBJ_RW);
	if (OMis_null_obj(sets_id)) {
		ERR_RETURN("cannot get cell sets");
	}
	OMset_obj_ref(sets_id, OMnull_obj, 0);

	if (FLDget_nnodes(in, &nnodes) != 1 || nnodes == 0) {
		return(0);
	}
	if (FLDget_ncell_sets(in, &nsets) != 1) {
		ERR_RETURN("cannot get nsets");
	}

	nc=0;

	for (cs=0; cs<nsets; cs++) {
		if (FLDget_cell_set(in, cs, &cell_set) != 1) {
			ERR_RETURN("cannot get cell set");
		}
		if (FLDget_cell_ndim(cell_set, &ndim) != 1) {
			ERR_RETURN("cannot get ndim");
		}

		if (ndim < 2) {
			stat = OMadd_obj_ref(sets_id, cell_set, 0);
			if (stat != 1) {
				ERR_RETURN("cannot reference cell set");
			}
			continue;
		}
		if (FLDget_ncells(cell_set, &ncells) != 1) {
			ERR_RETURN("cannot get ncells");
		}

		if (FLDget_cell_set_nnodes(cell_set,  &cell_nnodes) != 1) {
			ERR_RETURN("cannot get cell nnodes");
		}

		if (FLDget_node_connect(cell_set, &node_list, 
					&size, OM_GET_ARRAY_RD) != 1) {
			ERR_RETURN("cannot get cell connectivity");
		}

		OMpush_status_range((int)(cs*100/nsets),
				    (int)((cs+1)*100/nsets));
		if (ndim == 2) {
			if (FLDget_cell_corner_nnodes(cell_set,  &cell_corner_nnodes) != 1) {
				ERR_RETURN("cannot get cell nnodes");
			}
			stat = UTILedges_2D (nnodes, ncells, cell_nnodes, node_list, cell_corner_nnodes, 
					     &out_ncells, &out_node_list);
			OMpop_status_range();
			if (stat != 1) {
				ARRfree(node_list);
				if (FLDset_ncell_sets (out_sets, 0) != 1) {
					ERR_RETURN("Error setting ncell_sets");
				}
				ERR_RETURN("edges are not extracted");
			}

			ARRfree(node_list);
		}
		else if (ndim == 3){
			if (FLDget_cell_faces(cell_set, &cell_nfaces, &face_nnodes, 
					      &face_corner_nnodes, &face_node_list, &fnl_size) != 1) {
				ERR_RETURN("cannot get cell nfaces");
			}
			stat =  UTILedges_3D (nnodes, ncells, cell_nnodes, node_list, 
					      cell_nfaces, face_nnodes, face_corner_nnodes, face_node_list,
					      &out_ncells, &out_node_list);
			OMpop_status_range();
			if (stat != 1) {
				ARRfree(node_list);
				ARRfree(face_nnodes);
				ARRfree(face_corner_nnodes);
				ARRfree(face_node_list);
				if (FLDset_ncell_sets (out_sets, 0) != 1) {
					ERR_RETURN("Error setting ncell_sets");
				}
				ERR_RETURN("edges are not extracted");
			}

			ARRfree(node_list);
			ARRfree(face_nnodes);
			ARRfree(face_corner_nnodes);
			ARRfree(face_node_list);
		}
		else 
			continue;
		/*-----------------------------------*/
		/*  ADD new Line cell set            */
		/*-----------------------------------*/
		if (out_ncells == 0 || !out_node_list) {
			continue;
		}
		if (FLDadd_cell_set(out_sets, "Line") != 1) {
			ERR_RETURN("Error setting cell type");
		}
		if (FLDget_cell_set(out_sets, nc, &out_set) != 1) {
			ERR_RETURN("Error getting cell set");
		}
		if (FLDget_cell_set(out_sets, nc++, &out_set) != 1) {
			ERR_RETURN("Error getting cell set");
		}
		if (FLDset_ncells(out_set, out_ncells) != 1) {
			ERR_RETURN("Error setting ncells");
		}

		if (FLDset_node_connect(out_set, out_node_list, 2*out_ncells,
					OM_SET_ARRAY_FREE) != 1) {
			ERR_RETURN("Error setting cell connect list");
		}
		stat = OMadd_obj_ref(sets_id, out_set, 0);
		if (stat != 1) {
			ERR_RETURN("cannot reference cell set");
		}
	}
	return(1);
}

