/*
			Copyright (c) 2000 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/extr_comp.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/err.h>
#include <avs/om.h>
#include <avs/fld.h>

#define METHOD_SUCCESS 1
#define METHOD_FAILURE 0

#define ERR_RETURN(A) {ERRerror("extract_comp", 0, ERR_ORIG, A); \
                       return METHOD_FAILURE;}

int FUNCextract_comp (OMobj_id in, int comp, OMobj_id out);

/* 64-bit porting. Only Modified Internally */
int
DV_ARRextract_comp_update(OMobj_id elem_id, OMevent_mask event_mask, int seq_num)
{
    OMobj_id in_arr, out_arr;
    xp_long i, num_fields;
    int stat;
    OMobj_id in, out,comp_id;
    int comp;

    in_arr  = OMfind_subobj(elem_id, OMstr_to_name("in"),  OM_OBJ_RD);
    out_arr = OMfind_subobj(elem_id, OMstr_to_name("out_nd"), OM_OBJ_RW);

    stat = OMget_array_size( in_arr, &num_fields );
    if( stat != OM_STAT_SUCCESS ) return METHOD_FAILURE;

    comp_id = OMfind_subobj(elem_id, OMstr_to_name("component"), OM_OBJ_RD);

    OMget_int_val(comp_id, &comp);

    stat = OMset_array_size( out_arr, num_fields );
    if( stat != OM_STAT_SUCCESS ) return METHOD_FAILURE;

    for( i = 0; i < num_fields; ++i ) {
        stat = OMget_array_val( in_arr, i, &in, OM_OBJ_RD );
        if( stat != OM_STAT_SUCCESS ) continue;
        stat = OMget_array_val( out_arr, i, &out, OM_OBJ_RW );
        if( stat != OM_STAT_SUCCESS ) continue;

        stat = FUNCextract_comp(in, comp, out);
#if 0
        if( stat != METHOD_SUCCESS ) {
            ERRerror( "extract_comp", 1, ERR_ORIG,
                      "Error while processing field: %d", i );
        }
#endif
    }

    return METHOD_SUCCESS;
}


/* 64-bit porting. Only Modified Internally */
int FUNCextract_comp (OMobj_id in, int comp, OMobj_id out)
{
    xp_long nnodes;
    int ncomp;

    if (FLDget_nnodes(in, &nnodes) != 1) {
        ERR_RETURN("cannot get nnodes");
    }
    if (nnodes < 0) nnodes = 0;

    if (FLDget_node_data_ncomp(in, &ncomp) != 1) {
        ERR_RETURN("cannot get ncomp (nnode_data)");
    }

    /********************************/
    /*   Free pre-allocated arrays  */
    /********************************/
    if (FLDset_nnodes (out, 0) != 1) {
        ERR_RETURN("Error setting nnodes");
    }
    if (FLDset_node_data_ncomp (out, 0) != 1) {
        ERR_RETURN("Error setting nnode_data");
    }

    /*** OUTPUT FIELD ***/

    if (FLDset_nnodes (out, nnodes) != 1) {
        ERR_RETURN("Error setting nnodes");
    }
    if( nnodes > 0 ) {
        OMobj_id in_node_data, in_node_data_comp, out_node_data;
        int ref_mode;
        int stat;

        if (FLDset_node_data_ncomp (out, 1) != OM_STAT_SUCCESS) {
           ERR_RETURN("Error setting nnode_data");
        }

        in_node_data  = OMfind_subobj(in,  OMstr_to_name("node_data"), OM_OBJ_RD);
        out_node_data = OMfind_subobj(out, OMstr_to_name("node_data"), OM_OBJ_RW);

        /* Probably already done in V */
        OMget_obj_ref_mode( out_node_data, &ref_mode );
        if( ref_mode != OM_OBJ_REF )
            OMset_obj_ref_mode( out_node_data, OM_OBJ_REF );

        stat = OMget_array_val( in_node_data, comp, &in_node_data_comp, OM_OBJ_RD );
        if( stat != OM_STAT_SUCCESS ) {
            ERR_RETURN("Error getting nnode_data");
        }

/*
        if( OMset_obj_ref( out_node_data, OMnull_obj, 0 ) != 1 ) {
           ERR_RETURN("Error clearing nnode_data references");
        }
*/

        /* I thought that OMadd_obj_ref was more logical, but noooo */
        if( OMset_obj_ref( out_node_data, in_node_data_comp, 0 ) != 1 ) {
           ERR_RETURN("Error setting nnode_data reference");
        }
    }
    else {
        OMobj_id out_node_data;
        int ref_mode;

        /* redundant? */
        if (FLDset_node_data_ncomp (out, 0) != 1) {
           ERR_RETURN("Error setting nnode_data");
        }

        out_node_data = OMfind_subobj(out, OMstr_to_name("node_data"), OM_OBJ_RW);

        /* Probably already done in V */
        OMget_obj_ref_mode( out_node_data, &ref_mode );
        if( ref_mode != OM_OBJ_REF )
            OMset_obj_ref_mode( out_node_data, OM_OBJ_REF );

        OMset_obj_ref( out_node_data, OMnull_obj, 0 );
    }

    return METHOD_SUCCESS;
}
