/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/extr_scl.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/fld.h>
#include <avs/arr.h>
#include <avs/dv_util.h>

#define METHOD_SUCCESS 1
#define METHOD_FAILURE 0

#define ERR_RETURN(A) {ERRerror("extr_scalar", 0, ERR_ORIG, A); \
                       return METHOD_FAILURE;}

#define MAX_NAME_SIZE 1024

int FUNCextr_scalar (OMobj_id in, int comp, OMobj_id out);

int DVextr_scalar_update(OMobj_id elem_id)
{
    OMobj_id in, out,comp_id;
    int comp;

    in = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
    out = OMfind_subobj(elem_id, OMstr_to_name("out"), OM_OBJ_RW);
    comp_id = OMfind_subobj(elem_id, OMstr_to_name("component"),
                            OM_OBJ_RW);

    OMget_int_val(comp_id, &comp);

    if (FUNCextr_scalar(in, comp, out) == METHOD_SUCCESS ) {
        return METHOD_SUCCESS;
    }
    else return METHOD_FAILURE;
}


/* 64-bit porting. Only Modified Internally */
int
DV_ARRextr_scalar_update(OMobj_id elem_id, OMevent_mask event_mask, int seq_num)
{
    OMobj_id in_arr, out_arr;
    xp_long i, num_fields;
    int stat;
    OMobj_id in, out,comp_id;
    int comp;

    in_arr  = OMfind_subobj(elem_id, OMstr_to_name("in"),  OM_OBJ_RD);
    out_arr = OMfind_subobj(elem_id, OMstr_to_name("out"), OM_OBJ_RW);

    stat = OMget_array_size( in_arr, &num_fields );
    if( stat != OM_STAT_SUCCESS ) return METHOD_FAILURE;

    comp_id = OMfind_subobj(elem_id, OMstr_to_name("component"), OM_OBJ_RD);

    OMget_int_val(comp_id, &comp);

    stat = OMset_array_size( out_arr, num_fields );
    if( stat != OM_STAT_SUCCESS ) return METHOD_FAILURE;

    for( i = 0; i < num_fields; ++i ) {
        stat = OMget_array_val( in_arr, i, &in, OM_OBJ_RD );
        if( stat != OM_STAT_SUCCESS ) continue;
        stat = OMget_array_val( out_arr, i, &out, OM_OBJ_RW );
        if( stat != OM_STAT_SUCCESS ) continue;

        stat = FUNCextr_scalar(in, comp, out);
#if 0
        if( stat != METHOD_SUCCESS ) {
            ERRerror( "extr_scalar", 1, ERR_ORIG,
                      "Error while processing field: %d", i );
        }
#endif
    }

    return METHOD_SUCCESS;
}


/* 64-bit porting. Only Modified Internally */
int FUNCextr_scalar (OMobj_id in, int comp, OMobj_id out)
{
	xp_long nnodes, size;
	int   veclen, ncomp;
	int   data_type, null_flag;
	char   *node_data, *out_node_data;
	double null_value;
	char  label[MAX_NAME_SIZE], tmp[32];

	if (FLDget_node_data_ncomp (in, &ncomp) != 1) {
		ERR_RETURN("cannot get node data ncomp");
	}
	if (ncomp < 1)
		return(0);

	if (FLDget_nnodes(in, &nnodes) != 1) {
		ERR_RETURN("cannot get nnodes");
	}

	if (FLDset_nnodes (out, nnodes) != 1) {
		ERR_RETURN("Error setting nnodes");
	}

	if (FLDget_node_data_veclen(in, 0, &veclen) != 1) {
		ERR_RETURN("Error getting veclen");
	}
	if (comp >= veclen) {
		if (FLDset_node_data_ncomp (out, 0) != 1) {
			ERR_RETURN("Error setting nnode_data");
		}
		ERR_RETURN("requested component does not exist, scalar is not created");
	}

	if (FLDset_node_data_ncomp (out, 1) != 1) {
		ERR_RETURN("Error setting nnode_data");
	}

	if (FLDget_node_data_label(in, 0, label, MAX_NAME_SIZE) != 1) {
		strcpy(label, "extract scalar");
	}
	else if (veclen > 1) {
		sprintf(tmp,"[%d]",comp);
		strcat(label, tmp);
	}

	if (FLDset_node_data_comp (out, 0, 1, label, "") != 1) {
		ERR_RETURN("Error setting node component");
	}

	if (FLDget_node_data(in, 0, &data_type, &node_data, 
			     &size, OM_GET_ARRAY_RD) != 1) {
		ERR_RETURN("cannot get node data");
	}
	if (FLDget_node_null_data(in, 0, &null_flag, (char *)&null_value) != 1) {
		ERR_RETURN("cannot get null data");
	}
	if (FLDget_node_data(out, 0, &data_type, &out_node_data, 
			     &size, OM_GET_ARRAY_WR) != 1) {
		ERR_RETURN("Error setting node data");
	}

	UTILextract_scalar(nnodes, veclen, node_data, data_type,
			   comp, out_node_data);
	if (null_flag) {
		if (FLDset_node_null_data(out, 0, (char *)&null_value, data_type) != 1) {
			ERR_RETURN("Error setting null value");
		}
	}
	else {
		if (FLDset_node_null_flag(out, 0, 0) != 1) {
			ERR_RETURN("Error setting null flag");
		}
	}
	ARRfree(node_data);
	ARRfree(out_node_data);
	return(1);
}
