/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/extr_vec.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/fld.h>
#include <avs/arr.h>
#include <avs/dv_util.h>

#define METHOD_SUCCESS 1
#define METHOD_FAILURE 0

#define ERR_RETURN(A) {ERRerror("extr_vec", 0, ERR_ORIG, A); \
                       return METHOD_FAILURE;}

int FUNCextr_vector (OMobj_id in, int *in_comp, int *in_subcomp,
                     int out_veclen, OMobj_id out);

/* 64-bit porting. Only Modified Internally */
int DVextr_vector_update(OMobj_id elem_id)
{
    OMobj_id in, out,comp_id, sub_comp_id, veclen_id;
    int *comp, *sub_comp, veclen;
    int type, stat;
    xp_long size;

    in = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
    out = OMfind_subobj(elem_id, OMstr_to_name("out"), OM_OBJ_RW);
    veclen_id = OMfind_subobj(elem_id, OMstr_to_name("veclen"), OM_OBJ_RW);
    comp_id = OMfind_subobj(elem_id, OMstr_to_name("components"), OM_OBJ_RW);
    sub_comp_id = OMfind_subobj(elem_id, OMstr_to_name("sub_components"),
                                OM_OBJ_RW);

    stat = OMget_int_val(veclen_id, &veclen);
    if (stat != OM_STAT_SUCCESS)
        return METHOD_FAILURE;
    type = OM_TYPE_INT;
    size = 0;
    comp = (int *)NULL;
    stat = OMget_array_sz(comp_id, &type, (char **)(&comp), &size, OM_GET_ARRAY_RD);
    if (stat != OM_STAT_SUCCESS || comp == NULL || (int)size != veclen) {
        if (FLDset_nnodes (out, 0) != OM_STAT_SUCCESS) {
            ERR_RETURN("Error setting nnodes");
        }
        if (FLDset_node_data_ncomp (out, 0) != OM_STAT_SUCCESS) {
            ERR_RETURN("Error setting nnode_data");
        }
        ERR_RETURN("cannot get component array, vector is not created");
    }
    type = OM_TYPE_INT;
    size = 0;
    sub_comp = (int *)NULL;
    stat = OMget_array_sz(sub_comp_id, &type, (char **)(&sub_comp), &size, OM_GET_ARRAY_RD);
    if (stat != OM_STAT_SUCCESS || sub_comp == NULL || (int)size != veclen) {
        if (FLDset_nnodes (out, 0) != OM_STAT_SUCCESS) {
            ERR_RETURN("Error setting nnodes");
        }
        if (FLDset_node_data_ncomp (out, 0) != OM_STAT_SUCCESS) {
            ERR_RETURN("Error setting nnode_data");
        }
        ERR_RETURN("cannot get sub-component array, vector is not created");
    }
    stat = FUNCextr_vector(in, comp, sub_comp, veclen, out);

    ARRfree(comp);
    ARRfree(sub_comp);
    return stat;
}

/* 64-bit porting. Only Modified Internally */
int
DV_ARRextr_vector_update(OMobj_id elem_id, OMevent_mask event_mask, int seq_num)
{
    OMobj_id in_arr, out_arr;
    xp_long i, num_fields;
    OMobj_id in, out, comp_id, sub_comp_id, veclen_id;
    int *comp, *sub_comp, veclen;
    int type, stat;
    xp_long size;

    in_arr  = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
    out_arr = OMfind_subobj(elem_id, OMstr_to_name("out"), OM_OBJ_RW);

    stat = OMget_array_size( in_arr, &num_fields );
    if( stat != OM_STAT_SUCCESS ) return METHOD_FAILURE;

    stat = OMset_array_size( out_arr, num_fields );
    if( stat != OM_STAT_SUCCESS ) return METHOD_FAILURE;

    veclen_id = OMfind_subobj(elem_id, OMstr_to_name("veclen"), OM_OBJ_RW);
    comp_id = OMfind_subobj(elem_id, OMstr_to_name("components"), OM_OBJ_RW);
    sub_comp_id = OMfind_subobj(elem_id, OMstr_to_name("sub_components"), OM_OBJ_RW);

    stat = OMget_int_val(veclen_id, &veclen);
    if (stat != OM_STAT_SUCCESS)
        return METHOD_FAILURE;
    type = OM_TYPE_INT;
    size = 0;
    comp = (int *)NULL;
    stat = OMget_array_sz(comp_id, &type, (char **)(&comp), &size, OM_GET_ARRAY_RD);
    if (stat != OM_STAT_SUCCESS || comp == NULL || (int)size != veclen) {
        for( i = 0; i < num_fields; ++i ) {
            stat = OMget_array_val( out_arr, i, &out, OM_OBJ_RW );
            if( stat != OM_STAT_SUCCESS ) continue;

            if (FLDset_nnodes (out, 0) != OM_STAT_SUCCESS) {
                ERR_RETURN("Error setting nnodes");
            }
            if (FLDset_node_data_ncomp (out, 0) != OM_STAT_SUCCESS) {
                ERR_RETURN("Error setting nnode_data");
            }
        }
        ERR_RETURN("cannot get component array, vector is not created");
    }

    type = OM_TYPE_INT;
    size = 0;
    sub_comp = (int *)NULL;
    stat = OMget_array_sz(sub_comp_id, &type, (char **)(&sub_comp), &size, OM_GET_ARRAY_RD);
    if (stat != OM_STAT_SUCCESS || sub_comp == NULL || (int)size != veclen) {
        for( i = 0; i < num_fields; ++i ) {
            stat = OMget_array_val( out_arr, i, &out, OM_OBJ_RW );
            if( stat != OM_STAT_SUCCESS ) continue;

            if (FLDset_nnodes (out, 0) != OM_STAT_SUCCESS) {
                ERR_RETURN("Error setting nnodes");
            }
            if (FLDset_node_data_ncomp (out, 0) != OM_STAT_SUCCESS) {
                ERR_RETURN("Error setting nnode_data");
            }
        }
        ERR_RETURN("cannot get sub-component array, vector is not created");
    }

    for( i = 0; i < num_fields; ++i ) {
        stat = OMget_array_val( in_arr, i, &in, OM_OBJ_RD );
        if( stat != OM_STAT_SUCCESS ) continue;
        stat = OMget_array_val( out_arr, i, &out, OM_OBJ_RW );
        if( stat != OM_STAT_SUCCESS ) continue;

        stat = FUNCextr_vector( in, comp, sub_comp, veclen, out );
#if 0
        if( stat != METHOD_SUCCESS ) {
            ERRerror( "extr_vec", 1, ERR_ORIG,
                      "Error while processing field: %d", i );
        }
#endif
    }

    ARRfree(comp);
    ARRfree(sub_comp);
    return METHOD_SUCCESS;
}


/* 64-bit porting. Only Modified Internally */
int FUNCextr_vector (OMobj_id in, int *in_comp, int *in_subcomp,
                     int out_veclen, OMobj_id out)
{
	int   i, count, *veclen, ncomp;
	xp_long nnodes, size;
	int   comp, data_type, null_flag, out_null_flag;
	char   **node_data, *out_node_data;
	double null_value, out_null_value;

	if (FLDget_nnodes(in, &nnodes) != 1) {
		ERR_RETURN("cannot get nnodes");
	}

	if (FLDset_nnodes (out, nnodes) != 1) {
		ERR_RETURN("Error setting nnodes");
	}
	if (FLDget_node_data_ncomp(in, &ncomp) != 1) {
		ERR_RETURN("Error getting ncomp");
	}
	for (i=0; i<out_veclen; i++) {
		comp = in_comp[i];
		if (comp >= ncomp) {
			if (FLDset_node_data_ncomp (out, 0) != 1) {
				ERR_RETURN("Error setting nnode_data");
			}
			ERR_RETURN("requested component does not exist, vector is not created");
		}
	}
	if (FLDset_node_data_ncomp (out, 1) != 1) {
		ERR_RETURN("Error setting nnode_data");
	}
	if (FLDset_node_data_comp (out, 0, out_veclen, "combine_vector", "") != 1) {
		ERR_RETURN("Error setting node component");
	}
	veclen = (int *)malloc(out_veclen*sizeof(int));
	node_data = (char **)malloc(out_veclen*sizeof(char *));
	out_null_flag = 0;

	for (count=0, i=0; i<out_veclen; i++) {
		comp = in_comp[i];
		if (FLDget_node_data(in, comp, &data_type, &(node_data[count]),
				     &size, OM_GET_ARRAY_RD) != 1) {
			ERR_RETURN("cannot get node data");
		}
		if (FLDget_node_data_veclen(in, comp, veclen+count) != 1) {
			ERR_RETURN("Error getting veclen");
		}
		if (FLDget_node_null_data(in, comp, &null_flag, (char *)&null_value) != 1) {
			ERR_RETURN("cannot get null data");
		}
		if (null_flag) {
			out_null_flag = 1;
			out_null_value = null_value;
		}
		count++;
	}
	if (FLDget_node_data(out, 0, &data_type, &out_node_data, 
			     &size, OM_GET_ARRAY_WR) != 1) {
		ERR_RETURN("Error setting node data");
	}

	UTILextract_vector(nnodes, veclen, node_data, data_type,
			   out_veclen, in_subcomp, out_node_data);
	if (out_null_flag) {
		if (FLDset_node_null_data(out, 0, (char *)&out_null_value, data_type) != 1) {
			ERR_RETURN("Error setting null value");
		}
	}
	else {
		if (FLDset_node_null_flag(out, 0, 0) != 1) {
			ERR_RETURN("Error setting null flag");
		}
	}
	ARRfree(out_node_data);
	free(veclen);

	for (i=0; i<out_veclen; i++) {
	   if (node_data[i] != NULL)
	      ARRfree(node_data[i]);
	}
	free(node_data);

	return(1);
}
