C--------------------------------------------------------
C     This is an example of using FORTRAN API (FLDF)
C     to set information in  a mesh so that it will contain
C     one cell set of type 'Tri' with one cell and 3 nodes
C     and one scalar node data component.
C
C  V-template for this module looks like:
C  
C    module set_fld_gen {
C	Mesh+Node_Data+Oparam mesh;
C	fmethod+notify_inst+notify_val update = "set_fld_gen";
C    };
C
C---------------------------------------------------------
C
C  Source for fortran function set_fld_gen
C
      INTEGER function set_fld_gen
     .     (set_fld_gen_id, event_mask, seq_num)
C     This line may need to be changed to:
C     include 'avs/omf.inc' for some platforms
C     include 'avs/fldf.inc' for some platforms

C     Use the new wide API introduced in AVS/Express 7.
C     Some variables that were previously 32-bits wide are now
C     64-bits wide when on a 64-bit platform.
C
C     Note that when on a 64-bit platform, memory pointers/offsets
C     are 64-bits wide even in AVS/Express versions prior to 7.
#define XP_WIDE_API

#include "avs/omf.inc"
#include "avs/fldf.inc"
      integer set_fld_gen_id(OIDSIZ), event_mask, seq_num
C     
C     Declare variables  
C     
      INTEGER id(OIDSIZ)
      XP_LONG_INT nnodes, size
      INTEGER nspace
      XP_LONG_INT ncells
      INTEGER nsets, set, cell_nnodes
#ifdef WORDLENGTH_64
C     These are memory pointers or memory offsets and
C     thus must be 64-bits wide on a 64-bit machine.
      INTEGER*8 coord, node_connect
      INTEGER*8 crd_off, con_off
#else
      INTEGER coord, node_connect
      INTEGER crd_off, con_off
#endif
      XP_LONG_INT con_base(1)
      REAL crd_base(1)
      CHARACTER*32 cell_name
      INTEGER cell_set(OIDSIZ)
      INTEGER ncomp, comp, veclen
      INTEGER data_type, ndata
#ifdef WORDLENGTH_64
C     These are memory pointers or memory offsets and
C     thus must be 64-bits wide on a 64-bit machine.
      INTEGER*8 data, data_offset
#else
      INTEGER data, data_offset
#endif
C     !!! The type of the data_base array should be changed
C     to the type of node data
      REAL data_base(1)
      
C     Set mesh
C     Get mesh id
      IF (OMFfind_subobj(set_fld_gen_id, OMFstr_to_name('mesh'),
     .     OM_OBJ_RW, id) .NE. 1) THEN
         PRINT*,'Error getting mesh'
         set_fld_gen = 0
         return
      ENDIF
      
C     Set mesh nspace, nspace can be 1,2 or 3
      nspace = 2 
      IF (FLDFset_nspace (id, nspace) .NE. 1) THEN
         PRINT*,'Error getting nspace' 
         set_fld_gen = 0
         return
      ENDIF
      
C  Set mesh nodes
      nnodes = 3
      IF (FLDFset_nnodes (id, nnodes) .NE. 1) THEN
         PRINT*,'Error getting nnodes' 
         set_fld_gen = 0
         return
      ENDIF
      
C     Now, that nspace and nnodes are set, 
C     just get pointer to coordinate array
      IF (FLDFget_coord(id, coord, 
     .     nnodes, OM_GET_ARRAY_RW) .NE. 1) THEN
         PRINT*,'Error getting coordinates'
         set_fld_gen = 0
         return
      ENDIF
      
      crd_off = ARRFoffset(coord,
     .     crd_base,DTYPE_FLOAT)
C     Fill in cnt_base array with coordinates x,y,z,x,y,z....
C     starting with cnt_base(1+offset)
C     
      crd_base(crd_off+1) = 0.0
      crd_base(crd_off+2) = 0.0
      crd_base(crd_off+3) = 2.0
      crd_base(crd_off+4) = 0.0
      crd_base(crd_off+5) = 2.0
      crd_base(crd_off+6) = 2.0
      
C     Set number of cell sets nsets variable
      nsets = 1
      IF (FLDFset_ncell_sets(id, nsets) .NE. 1) THEN
         PRINT*,'Error getting ncell sets' 
         set_fld_gen = 0
         return
      ENDIF
      
C     For each cell_set set information  about cells 
C     do it for each set from 0 to nsets-1
      set = 0
      IF (FLDFget_cell_set(id, set, 
     .     cell_set) .NE. 1) THEN
         PRINT*,'Error getting cell set' 
         set_fld_gen = 0
         return
      ENDIF
      
C     Set cell set to say, Tri
      cell_name = 'Tri'
      IF (FLDFset_cell_set(cell_set, 
     .     cell_name) .NE. 1) THEN
         PRINT*,'Error setting cell set'
         set_fld_gen = 0
         return
      ENDIF
      
C     Set number of cells
      ncells = 1
      IF (FLDFset_ncells(cell_set, ncells)
     .     .NE. 1) THEN
         PRINT*,'Error getting ncells' 
         set_fld_gen = 0
         return
      ENDIF
      
C     Get node connectivity list
      IF (FLDFget_node_connect(cell_set, 
     .     node_connect,size,OM_GET_ARRAY_RW)
     .     .NE. 1) THEN
         PRINT*,'Error getting node connectivity'
         set_fld_gen = 0
         return
      ENDIF
      
      con_off = ARRFoffset(node_connect,
     .     con_base,DTYPE_LONG)
C     Fill in  con_base array with node indecies for each cell
C     starting with con_base(1+con_off)
C
      con_base(1+con_off) = 0
      con_base(2+con_off) = 1
      con_base(3+con_off) = 2

C     Set mesh's node data
C     Get field id
      IF (OMFfind_subobj(set_fld_gen_id, 
     .     OMFstr_to_name('mesh'),
     .     OM_OBJ_RW, id) .NE. 1) THEN
         PRINT*,'Error getting data'
         set_fld_gen = 0
         return
      ENDIF
      
C     Get number of node data components
      ncomp = 1
      IF (FLDFset_node_data_ncomp (id, ncomp) .NE. 1) THEN
         PRINT*,'Error setting ndata comp'
         set_fld_gen = 0
         return
      ENDIF
      
C     For each node data component set veclen, type and data arry itself
C     do it for each comp from 0 to ncomp-1
      comp = 0
C     Set veclen 
      veclen = 1
      IF (FLDFset_node_data_veclen (id, 
     .   comp, veclen) .NE. 1) THEN
         PRINT*,'Error setting data veclen'
         set_fld_gen = 0
         return
      ENDIF

C     Set data array and data_type which is one of the following: 
C     DTYPE_BYTE, DTYPE_CHAR, DTYPE_SHORT, 
C     DTYPE_INT, DTYPE_FLOAT, DTYPE_DOUBLE 
      data_type = DTYPE_FLOAT
      IF (FLDFget_node_data (id, comp, 
     .     data_type, data,
     .     ndata, OM_GET_ARRAY_WR) .NE. 1) THEN
         PRINT*,'Error setting data'
         set_fld_gen = 0
         return
      ENDIF

      data_offset = ARRFoffset(data,
     .     data_base,data_type)
C     Fill in data_base array with values
C     starting with data_base(1+data_offset)
      data_base(1+data_offset) = 10
      data_base(2+data_offset) = 11
      data_base(3+data_offset) = 12
C     
C     Free output variables 
C     
      CALL ARRFfree(coord)
      CALL ARRFfree(node_connect)
      CALL ARRFfree(data)
C     
      set_fld_gen = 1
      return
      end

C--------------------------------------------------------
C     This is an example of using FORTRAN API (FLDF)
C     to get information out of a mesh containing one
C     cell set of type 'Tri' with one cell and 3 nodes
C     and one scalar node data component.
C     
C     V-template for this module looks like:
C     
C    module get_fld_gen {
C	Mesh+Node_Data+Iparam &mesh;
C	fmethod+notify_inst+notify_val update = "get_fld_gen";
C    };
C
C---------------------------------------------------------
      INTEGER function get_fld_gen
     .        (get_fld_gen_id, event_mask, seq_num)
C
C   This line may need to be changed to:
C     include 'avs/omf.inc' for some platforms
C     include 'avs/fldf.inc' for some platforms
#include "avs/omf.inc"
#include "avs/fldf.inc"
      integer get_fld_gen_id(OIDSIZ), event_mask, seq_num
C
C    Declare variables  
C
      INTEGER id(OIDSIZ)
      XP_LONG_INT nnodes, size
      INTEGER nspace
      XP_LONG_INT ncells
      INTEGER nsets, set, ncells, cell_nnodes
#ifdef WORDLENGTH_64
C     These are memory pointers or memory offsets and
C     thus must be 64-bits wide on a 64-bit machine.
      INTEGER*8 coord, node_connect
      INTEGER*8 crd_off, con_off
#else
      INTEGER coord, node_connect
      INTEGER crd_off, con_off
#endif
      XP_LONG_INT con_base(1)
      REAL crd_base(1)
      INTEGER cell_set(OIDSIZ)
      INTEGER ncomp, comp, veclen
      INTEGER data_type, ndata
#ifdef WORDLENGTH_64
C     These are memory pointers or memory offsets and
C     thus must be 64-bits wide on a 64-bit machine.
      INTEGER*8 data, data_offset
#else
      INTEGER data, data_offset
#endif
C  The type of the data_base array should be change to 
C  the type of node data
      REAL data_base(1)
C
C  Get input values   
C
C   Get mesh id
      IF (OMFfind_subobj(get_fld_gen_id, 
     .     OMFstr_to_name('mesh'),
     .     OM_OBJ_RD, id) .NE. 1) THEN
         PRINT*,'Error getting mesh'
         get_fld_gen = 0
         return
      ENDIF

C   Get mesh nnodes
      IF (FLDFget_nnodes(id, nnodes) 
     .     .NE. 1) THEN
         PRINT*,'Error getting nnodes'
         get_fld_gen = 0
         return
      ENDIF

      PRINT*, 'nnodes=', nnodes

C   Get mesh nspace
      IF (FLDFget_nspace(id, nspace)
     .     .NE. 1) THEN
         PRINT*,'Error getting nspce'
         get_fld_gen = 0
         return
      ENDIF

      PRINT*, 'nspace=', nspace
      
C   Get mesh coordinates
      IF (FLDFget_coord(id, coord, 
     .     nnodes, OM_GET_ARRAY_RD) .NE. 1) THEN
         PRINT*,'Error getting coordinates'
         get_fld_gen = 0
         return
      ENDIF
      
      crd_off = ARRFoffset(coord,
     .     crd_base,DTYPE_FLOAT)

      PRINT*, 'coordinates'
      PRINT*, (crd_base(i+crd_off),i=1,6)

C     Get number of cell sets
      IF (FLDFget_ncell_sets(id, nsets) .NE. 1) THEN
         PRINT*,'Error getting ncell sets'
         get_fld_gen = 0
         return
      ENDIF

      PRINT*, 'ncell_sets=', nsets
 
C     For each cell_set get information  about cells 
C     do it for each set from 0 to nsets-1

      set = 0
C     Get cell set id
      IF (FLDFget_cell_set(id,set, cell_set) .NE. 1) THEN
         PRINT*,'Error getting cell set'
         get_fld_gen = 0
         return
      ENDIF

C     Get number of cells
      IF (FLDFget_ncells(cell_set, ncells) .NE. 1) THEN
         PRINT*,'Error getting ncells'
         get_fld_gen = 0
         return
      ENDIF

      PRINT*, 'ncells=', ncells

C     Get number of nodes in each cell
      IF (FLDFget_cell_set_nnodes(cell_set, 
     .     cell_nnodes) .NE. 1) THEN
         PRINT*,'Error getting cell nnodes'
         get_fld_gen = 0
         return
      ENDIF
      
      PRINT*, 'cell_nnodes=', cell_nnodes
      
C     Get node connectivity list
      IF (FLDFget_node_connect(cell_set, 
     .     node_connect,size,OM_GET_ARRAY_RD)
     .     .NE. 1) THEN
         PRINT*,'Error getting node connectivity'
         get_fld_gen = 0
         return
      ENDIF
      
      con_off = ARRFoffset(node_connect,
     .     con_base,DTYPE_LONG)
      
      PRINT*, 'connectivity'
      PRINT*, (con_base(i+con_off),i=1,3)
C     
C     
C     Get mesh's node data
C     Get field id
      IF (OMFfind_subobj(get_fld_gen_id, 
     .     OMFstr_to_name('mesh'),
     .     OM_OBJ_RD, id) .NE. 1) THEN
         PRINT*,'Error getting data' 
         get_fld_gen = 0
         return
      ENDIF

C     Get number of node data components
      IF (FLDFget_node_data_ncomp (id, ncomp) .NE. 1) THEN
         PRINT*,'Error getting ndata comp' 
         get_fld_gen = 0
         return
      ENDIF
      
      PRINT*, 'ndata=', ncomp

C     For each node data component get veclen, type and data arry itself
C     do it for each comp from 0 to ncomp-1
      comp = 0
C     Get veclen
      IF (FLDFget_node_data_veclen (id, comp, 
     .     veclen) .NE. 1) THEN
         PRINT*,'Error getting data veclen'
         get_fld_gen = 0
         return
      ENDIF

      PRINT*, 'veclen=', veclen

C  Get data array and data_type which is one of the following: 
C         DTYPE_BYTE, DTYPE_CHAR, DTYPE_SHORT, 
C         DTYPE_INT, DTYPE_FLOAT, DTYPE_DOUBLE 
      IF (FLDFget_node_data (id, comp, 
     .   data_type, data,
     .   ndata, OM_GET_ARRAY_RD) .NE. 1) THEN
         PRINT*,'Error getting data type' 
         get_fld_unif = 0
         return 
      ENDIF

      data_offset = ARRFoffset(data,
     .   data_base,data_type)

      PRINT*, 'data values'
      PRINT*, (data_base(i+data_offset),i=1,3)
      
C
C  Free input variables

      CALL ARRFfree(coord)
      CALL ARRFfree(node_connect)
      CALL ARRFfree(data)
C     
      get_fld_gen = 1
      return
      end


