/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/gen_fld.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/fld.h>
#include <avs/dv_util.h>
#include <avs/data_utils.h>

#define ERR_RETURN(str) {ERRerror(str, 0, ERR_CHAIN, "generate field:"); return(0);}
#define UNSTRUCT  0
#define STRUCTURED  1
#define UNIFORM 2
#define RECTILINEAR 3

static int ncoeff[3] = {3,6,10};

/* 64-bit porting. Only Modified Internally */
int DVgen_fld_update(OMobj_id elem_id)
{
	OMobj_id  elem, out, temp, cell_set;
	int fld_type, ndim, nspace, veclen, stat;
	xp_long nnodes, ncells, size;
	xp_long dims[3], size_w;
	int comp, data_type, null_flag;
	int i, j, n;
	xp_long *conn_list;
	xp_long i_w, j_w, k, count, i1, i2, i3, pdim, hex[10];
	xp_long  r_dims[3], min_rng[3], max_rng[3];
	float ext[6], *xyz, *coord, dx, dy, dz, coeff[10];
	char *cell_type, *node_data;
	double null_value, type_value;
	
	elem = OMfind_subobj(elem_id, OMstr_to_name("fld_type"), OM_OBJ_RW);
	OMget_int_val(elem, &fld_type);

	if (fld_type == UNIFORM)
		out = FLDcreate(elem_id, "Field_Unif", "Output_Field");
	else if (fld_type == RECTILINEAR)
		out = FLDcreate(elem_id, "Field_Rect", "Output_Field");
	else if (fld_type == STRUCTURED)
		out = FLDcreate(elem_id, "Field_Struct", "Output_Field");
	else if (fld_type == UNSTRUCT)
		out = FLDcreate(elem_id, "Field", "Output_Field");
	else {
		ERR_RETURN("Unknown grid type");
	}
	elem = OMfind_subobj(elem_id, OMstr_to_name("ndim"), OM_OBJ_RW);
	stat = OMget_int_val(elem, &ndim);
	if (stat != 1) {
		ERR_RETURN("Error getting ndim");
	}
	elem = OMfind_subobj(elem_id, OMstr_to_name("dims"), OM_OBJ_RW);
	r_dims[0] = ndim;
	min_rng[0] = 0;
	max_rng[0] = ndim;
	stat = OMget_sub_larray(elem, 1, r_dims, min_rng, max_rng,
				(void *)dims);
	if (stat != 1) {
		ERR_RETURN("Error getting dims");
	}
	if (fld_type > UNSTRUCT) {
		if (FLDset_ndim (out, ndim) != 1) {
			ERR_RETURN("Error setting ndim");
		}
		if (FLDset_dims (out, dims) != 1) {
			ERR_RETURN("Error setting dims");
		}
	}
	nnodes = dims[0];
	for (i=1; i<ndim; i++)
		nnodes *= dims[i];
	if (fld_type == UNSTRUCT) {
		if (FLDset_nnodes (out, nnodes) != 1) {
			ERR_RETURN("Error setting nnodes");
		}
	}
	elem = OMfind_subobj(elem_id, OMstr_to_name("nspace"), OM_OBJ_RW);
	stat = OMget_int_val(elem, &nspace);
	if (stat != 1) {
		ERR_RETURN("Error getting nspace");
	}
	elem = OMfind_subobj(elem_id, OMstr_to_name("extents"), OM_OBJ_RW);
	r_dims[0] = nspace;
	r_dims[1] = 2;
	min_rng[0] = 0;
	max_rng[0] = nspace;
	min_rng[1] = 0;
	max_rng[1] = 2;
	stat = OMget_sub_farray(elem, 2, r_dims, min_rng, max_rng,
				(void *)ext);
	if (stat != 1) {
		ERR_RETURN("Error getting extents");
	}
	if (FLDset_nspace (out, nspace) != 1) {
		ERR_RETURN("Error setting nspace");
	}
	switch (fld_type) {
	      case UNIFORM:
		if (FLDget_points (out, &xyz, &size, OM_GET_ARRAY_WR) != 1) {
			ERR_RETURN("Error getting points");
		}
		for (i=0; i<nspace; i++) {
			xyz[i] = ext[i];
			xyz[i+nspace] = ext[i+nspace];
		}
		break;

	      case RECTILINEAR:
		if (FLDget_points (out, &xyz, &size, OM_GET_ARRAY_WR) != 1) {
			ERR_RETURN("Error getting points");
		}
		for (i_w=0; i_w<dims[0]; i_w++) {
			xyz[i_w*nspace] = ext[0]+i_w*(ext[0+nspace]-ext[0])/
				(dims[0]-1);
			for (j=1; j<nspace; j++)
				xyz[i_w*nspace+j] = ext[j];
		}
		if (ndim > 1)
			for (i_w=0; i_w<dims[1]; i_w++) {
				xyz[(dims[0]+i_w)*nspace+1] = ext[1]+i_w*
					(ext[1+nspace]-ext[1])/(dims[1]-1);
				xyz[(dims[0]+i_w)*nspace+0] = ext[0];
				if (nspace > 2)
					xyz[(dims[0]+i_w)*nspace+2] = ext[2];
			}

		if (ndim > 2)
			for (i_w=0; i_w<dims[2]; i_w++) {
				xyz[(dims[0]+dims[1]+i_w)*nspace+2] = ext[2]+i_w*
					(ext[2+nspace]-ext[2])/(dims[2]-1);
				xyz[(dims[0]+dims[1]+i_w)*nspace+0] = ext[0];
				xyz[(dims[0]+dims[1]+i_w)*nspace+1] = ext[1];
			}
		break;

	      case STRUCTURED:
	      case UNSTRUCT:
		if (FLDget_coord (out, &xyz, &size_w, OM_GET_ARRAY_WR) != 1) {
			ERR_RETURN("Error getting coordinates");
		}
		switch (ndim) {
		      case 1:
			for (i_w=0; i_w<dims[0]; i_w++)
				xyz[i_w*nspace] = ext[0]+i_w*(ext[0+nspace]-ext[0])/
				(dims[0]-1);
			for (j=1; j<nspace; j++)
				xyz[i_w*nspace+j] = ext[j];
			break;

		      case 2:
			for (j_w=0; j_w<dims[1]; j_w++) {
				dy = ext[1]+j_w*(ext[1+nspace]-ext[1])/
					(dims[1]-1);
				for (i_w=0; i_w<dims[0]; i_w++)
					xyz[(j_w*dims[0]+i_w)*nspace+1] = dy;
			}
			for (j_w=0; j_w<dims[0]; j_w++) {
				dx = ext[0]+j_w*(ext[0+nspace]-ext[0])/
					(dims[0]-1);
				for (i_w=0; i_w<dims[1]; i_w++)
					xyz[(i_w*dims[0]+j_w)*nspace+0] = dx;
			}
			if (nspace > 2)
				for (j_w=0; j_w<dims[1]; j_w++)
					for (i_w=0; i_w<dims[0]; i_w++)
						xyz[(j_w*dims[0]+i_w)*nspace+2] = ext[2];
			break;

		      case 3:
			count = 0;
			for (k=0; k<dims[2]; k++) {
				dz = ext[2]+k*(ext[2+nspace]-ext[2])/
					(dims[2]-1);
				for (j_w=0; j_w<dims[1]; j_w++) {
					dy = ext[1]+j_w*(ext[1+nspace]-ext[1])/
						(dims[1]-1);
					for (i_w=0; i_w<dims[0]; i_w++) {
						dx = ext[0]+i_w*(ext[0+nspace]-ext[0])/
							(dims[0]-1);
						xyz[count++] = dx;
						xyz[count++] = dy;
						xyz[count++] = dz;
					}
				}
			}
			break;

		      default:
			ERR_RETURN("Unknown dimensionality");
		}
		break;
	      default:
		ERR_RETURN("Unknown grid type");
	}
	if (fld_type == UNSTRUCT) {
		elem = OMfind_subobj(elem_id, OMstr_to_name("cell_type"), OM_OBJ_RW);
		stat = OMget_str_val(elem, &cell_type, 0);
		if (stat != 1) {
			ERR_RETURN("Error getting cell_type");
		}
		if (FLDset_ncell_sets (out, 1) != 1) {
			ERR_RETURN("Error setting ncell_sets");
		}
		if (FLDget_cell_set(out, 0, &cell_set) != 1) {
			ERR_RETURN("Error getting cell set");
		}
		if (FLDset_cell_set(cell_set, cell_type) != 1) {
			ERR_RETURN("Error setting cell type");
		}
		if (strcmp(cell_type, "Point") == 0) {
			ncells = nnodes;
			if (FLDset_ncells(cell_set, ncells) != 1) {
				ERR_RETURN("Error setting ncells");
			}
			if (FLDget_node_connect(cell_set, &conn_list,
						&size_w, OM_GET_ARRAY_WR) !=1) {
				ERR_RETURN("Error getting connect list");
			}
			for (i_w=0; i_w<ncells; i_w++)
				conn_list[i_w] = i_w;
		}
		else if (strcmp(cell_type, "Line") == 0) {
			ncells = (nnodes-1);
			if (FLDset_ncells(cell_set, ncells) != 1) {
				ERR_RETURN("Error setting ncells");
			}
			if (FLDget_node_connect(cell_set, &conn_list,
						&size_w, OM_GET_ARRAY_WR) !=1) {
				ERR_RETURN("Error getting connect list");
			}
			for (i_w=0; i_w<ncells; i_w++) {
				conn_list[2*i_w] = i_w;
				conn_list[2*i_w+1] = i_w+1;
			}
		}
		else if (strcmp(cell_type, "Polyline") == 0) {
			ncells = 1;
			if (FLDset_ncells(cell_set, ncells) != 1) {
				ERR_RETURN("Error setting ncells");
			}
			if (FLDget_node_connect(cell_set, &conn_list,
						&size_w, OM_GET_ARRAY_WR) !=1) {
				ERR_RETURN("Error getting connect list");
			}
			conn_list[0] = 0;
			conn_list[1] = nnodes-1;
		}
		else if (strcmp(cell_type, "Tri") == 0) {
			if (ndim < 2) {
				ERR_RETURN("Invalid dim for tri cell");
			}
			ncells = 2*(dims[0]-1)*(dims[1]-1);
			if (FLDset_ncells(cell_set, ncells) != 1) {
				ERR_RETURN("Error setting ncells");
			}
			if (FLDget_node_connect(cell_set, &conn_list,
						&size_w, OM_GET_ARRAY_WR) !=1) {
				ERR_RETURN("Error getting connect list");
			}
			n = 6;
			for (j_w=0,i_w=0; i_w<ncells/2; i_w++) {
				i2 = i_w/(dims[0]-1);
				i1 = i_w-i2*(dims[0]-1);
				conn_list[j_w] = i2*dims[0]+i1;
				conn_list[j_w+1] = conn_list[j_w]+1;
				conn_list[j_w+2] = conn_list[j_w+1]+dims[0];

				conn_list[j_w+3] = conn_list[j_w+1]+dims[0];
				conn_list[j_w+4] = conn_list[j_w+2]-1;
				conn_list[j_w+5] = conn_list[j_w];
				j_w+=n;
			}
		}
		else if (strcmp(cell_type, "Quad") == 0) {
			if (ndim < 2) {
				ERR_RETURN("Invalid dim for quad cell");
			}
			ncells = (dims[0]-1)*(dims[1]-1);
			if (FLDset_ncells(cell_set, ncells) != 1) {
				ERR_RETURN("Error setting ncells");
			}
			if (FLDget_node_connect(cell_set, &conn_list,
						&size_w, OM_GET_ARRAY_WR) !=1) {
				ERR_RETURN("Error getting connect list");
			}
			n = 4;
			for (j_w=0,i_w=0; i_w<ncells; i_w++) {
				i2 = i_w/(dims[0]-1);
				i1 = i_w-i2*(dims[0]-1);
				conn_list[j_w] = i2*dims[0]+i1;
				conn_list[j_w+1] = conn_list[j_w]+1;
				conn_list[j_w+2] = conn_list[j_w+1]+dims[0];
				conn_list[j_w+3] = conn_list[j_w+2]-1;
				j_w+=n;
			}
		}
		else if (strcmp(cell_type, "Tet") == 0) {
			if (ndim < 3) {
				ERR_RETURN("Invalid dim for tet cell");
			}
			ncells = 5*(dims[0]-1)*(dims[1]-1)*(dims[2]-1);
			if (FLDset_ncells(cell_set, ncells) != 1) {
				ERR_RETURN("Error setting ncells");
			}
			if (FLDget_node_connect(cell_set, &conn_list,
						&size_w, OM_GET_ARRAY_WR) !=1) {
				ERR_RETURN("Error getting connect list");
			}
			n = 20;
			pdim = (dims[0]-1)*(dims[1]-1);
			for (j_w=0,i_w=0; i_w<ncells/5; i_w++) {
				i3 = i_w/pdim;
				i2 = (i_w-i3*pdim)/(dims[0]-1);
				i1 = i_w-i3*pdim-i2*(dims[0]-1);
				hex[0] = i3*dims[0]*dims[1]+i2*dims[0]+i1;
				hex[3] = hex[0]+1;
				hex[2] = hex[3]+dims[0];
				hex[1] = hex[2]-1;
				hex[4] = hex[0]+dims[0]*dims[1];
				hex[7] = hex[4]+1;
				hex[6] = hex[7]+dims[0];
				hex[5] = hex[6]-1;
				conn_list[0] = hex[6];
				conn_list[j_w+1] = hex[2];
				conn_list[j_w+2] = hex[1];
				conn_list[j_w+3] = hex[3];

				conn_list[j_w+4] = hex[4];
				conn_list[j_w+5] = hex[1];
				conn_list[j_w+6] = hex[3];
				conn_list[j_w+7] = hex[6];

				conn_list[j_w+8] = hex[1];
				conn_list[j_w+9] = hex[4];
				conn_list[j_w+10] = hex[3];
				conn_list[j_w+11] = hex[0];

				conn_list[j_w+12] = hex[1];
				conn_list[j_w+13] = hex[6];
				conn_list[j_w+14] = hex[4];
				conn_list[j_w+15] = hex[5];

				conn_list[j_w+16] = hex[4];
				conn_list[j_w+17] = hex[3];
				conn_list[j_w+18] = hex[7];
				conn_list[j_w+19] = hex[6];
				j_w+=n;
			}
		}
		else if (strcmp(cell_type, "Hex") == 0) {
			if (ndim < 3) {
				ERR_RETURN("Invalid dim for hex cell");
			}
			ncells = (dims[0]-1)*(dims[1]-1)*(dims[2]-1);
			if (FLDset_ncells(cell_set, ncells) != 1) {
				ERR_RETURN("Error setting ncells");
			}
			if (FLDget_node_connect(cell_set, &conn_list,
						&size_w, OM_GET_ARRAY_WR) !=1) {
				ERR_RETURN("Error getting connect list");
			}
			n = 8;
			pdim = (dims[0]-1)*(dims[1]-1);
			for (j_w=0,i_w=0; i_w<ncells; i_w++) {
				i3 = i_w/pdim;
				i2 = (i_w-i3*pdim)/(dims[0]-1);
				i1 = i_w-i3*pdim-i2*(dims[0]-1);
				conn_list[j_w] = i3*dims[0]*dims[1]+i2*dims[0]+i1;
				conn_list[j_w+3] = conn_list[j_w]+1;
				conn_list[j_w+2] = conn_list[j_w+3]+dims[0];
				conn_list[j_w+1] = conn_list[j_w+2]-1;

				conn_list[j_w+4] = conn_list[j_w]+dims[0]*dims[1];
				conn_list[j_w+7] = conn_list[j_w+4]+1;
				conn_list[j_w+6] = conn_list[j_w+7]+dims[0];
				conn_list[j_w+5] = conn_list[j_w+6]-1;
				j_w+=n;
			}
		}
		else if (strcmp(cell_type, "Prism") == 0) {
			if (ndim < 3) {
				ERR_RETURN("Invalid dim for tet cell");
			}
			ncells = 2*(dims[0]-1)*(dims[1]-1)*(dims[2]-1);
			if (FLDset_ncells(cell_set, ncells) != 1) {
				ERR_RETURN("Error setting ncells");
			}
			if (FLDget_node_connect(cell_set, &conn_list,
						&size_w, OM_GET_ARRAY_WR) !=1) {
				ERR_RETURN("Error getting connect list");
			}
			n = 12;
			pdim = (dims[0]-1)*(dims[1]-1);
			for (j_w=0,i_w=0; i_w<ncells/2; i_w++) {
				i3 = i_w/pdim;
				i2 = (i_w-i3*pdim)/(dims[0]-1);
				i1 = i_w-i3*pdim-i2*(dims[0]-1);
				hex[0] = i3*dims[0]*dims[1]+i2*dims[0]+i1;
				hex[3] = hex[0]+1;
				hex[2] = hex[3]+dims[0];
				hex[1] = hex[2]-1;
				hex[4] = hex[0]+dims[0]*dims[1];
				hex[7] = hex[4]+1;
				hex[6] = hex[7]+dims[0];
				hex[5] = hex[6]-1;
				conn_list[j_w+0] = hex[0];
				conn_list[j_w+1] = hex[1];
				conn_list[j_w+2] = hex[2];
				conn_list[j_w+3] = hex[4];
				conn_list[j_w+4] = hex[5];
				conn_list[j_w+5] = hex[6];

				conn_list[j_w+6] = hex[0];
				conn_list[j_w+7] = hex[2];
				conn_list[j_w+8] = hex[3];
				conn_list[j_w+9] = hex[4];
				conn_list[j_w+10] = hex[6];
				conn_list[j_w+11] = hex[7];
				j_w+=n;
			}
		}
		else {
			ERR_RETURN("Unknown cell type");
		}
		free(cell_type);
	}
	elem = OMfind_subobj(elem_id, OMstr_to_name("ndata_veclen"), OM_OBJ_RW);
	stat = OMget_int_val(elem, &veclen);
	if (stat != 1) {
		ERR_RETURN("Error getting veclen");
	}
	if (veclen > 0) {
		if (!(fld_type == UNIFORM || fld_type == RECTILINEAR)
		    || nnodes < 100000) {
			if (FLDget_coord (out, &coord, &size_w, OM_GET_ARRAY_RD) != 1) {
				ERR_RETURN("Error getting coordinates");
			}
		}
		else coord = NULL;
		elem = OMfind_subobj(elem_id, OMstr_to_name("ndata_coeff"), OM_OBJ_RW);
		r_dims[0] = 10;
		min_rng[0] = 0;
		max_rng[0] = ncoeff[nspace-1];
		stat = OMget_sub_farray(elem, 1, r_dims, min_rng, max_rng,
					(void *)coeff);
		if (stat != 1) {
			ERR_RETURN("Error getting node coeff");
		}

		elem = OMfind_subobj(elem_id, OMstr_to_name("ndata_type"), OM_OBJ_RW);
		stat = OMget_int_val(elem, &data_type);
		if (stat != 1) {
			ERR_RETURN("Error getting data_type");
		}

		elem = OMfind_subobj(elem_id, OMstr_to_name("null_flag"), OM_OBJ_RW);
		stat = OMget_int_val(elem, &null_flag);
		if (stat <0) {
			ERR_RETURN("Error getting null_flag");
		}
		else if (stat == 0)
			null_flag = 0;

		if (FLDset_node_data_ncomp (out, 1) != 1) {
			ERR_RETURN("Error setting nnode_data");
		}
		if (FLDset_node_data_comp (out, 0, veclen, "figovina", "shtuk na rilo") != 1) {
			ERR_RETURN("Error setting node component");
		}
				
		if (null_flag) {
			elem = OMfind_subobj(elem_id, OMstr_to_name("null_value"), OM_OBJ_RW);
			stat = OMget_real_val(elem, &null_value);
			if (stat != 1) {
				ERR_RETURN("Error getting null_value");
			}
			UTILdouble_to_type(&type_value, null_value, data_type);
			if (FLDset_node_null_data(out, 0, (char *)&type_value, data_type) != 1) {
				ERR_RETURN("Error setting null value");
			}
		}
		else {
			null_value = 0.0;
			if (FLDset_node_null_flag(out, 0, 0) != 1) {
				ERR_RETURN("Error setting null flag");
			}
		}
		if (FLDget_node_data(out, 0, &data_type, &node_data,
				     &size_w, OM_GET_ARRAY_WR) != 1) {
			ERR_RETURN("cannot get node data");
		}
		for (comp = 0; comp<veclen; comp++)
			UTILgen_data(nnodes, veclen, comp, data_type, node_data,
				     nspace, coord, coeff, null_flag, null_value);
		ARRfree(node_data);
		if (coord != NULL) ARRfree(coord);
	}
	temp = OMfind_subobj(elem_id, OMstr_to_name("out"), OM_OBJ_RW);
	stat = OMset_obj_ref(temp, out, 0);
	ARRfree(xyz);
	if (fld_type == UNSTRUCT) {
		ARRfree(conn_list);
	}
	return(1);
}
