/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/glyph.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/gd_def.h>
#include <avs/fld.h>
#include <avs/arr.h>
#include <avs/mat.h>
#include <avs/dtype.h>
#include <avs/dv_util.h>

#define METHOD_SUCCESS 1
#define METHOD_FAILURE 0

#define ERR_RETURN(A) {ERRerror("glyph", 0, ERR_ORIG, A); \
                       return METHOD_FAILURE;}

#define MAX_NAME_SIZE 1024

int FUNCglyph (OMobj_id in, OMobj_id glyph, int vec_flag, int norm,
               double scale, int comp, int map_comp, int scale_comp,
               int scale_x, int scale_y, int scale_z, OMobj_id out);

int DVglyph_update(OMobj_id elem_id)
{
    OMobj_id in, out, glyph, scale_id, norm_id, vec_id, data_id, tmp;
    int norm, vec, comp, map_comp, scale_comp, scale_x, scale_y, scale_z;
    double scale;

    in = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
    glyph = OMfind_subobj(elem_id, OMstr_to_name("glyph"), OM_OBJ_RD);
    out = OMfind_subobj(elem_id, OMstr_to_name("out"), OM_OBJ_RW);
    scale_id = OMfind_subobj(elem_id, OMstr_to_name("scale"), OM_OBJ_RD);
    OMget_real_val(scale_id, &scale);
    norm_id = OMfind_subobj(elem_id, OMstr_to_name("normalize"), OM_OBJ_RD);
    OMget_int_val(norm_id, &norm);
    vec_id = OMfind_subobj(elem_id, OMstr_to_name("vector"), OM_OBJ_RD);
    OMget_int_val(vec_id, &vec);
    data_id = OMfind_subobj(elem_id, OMstr_to_name("glyph_comp"), OM_OBJ_RD);
    OMget_int_val(data_id, &comp);
    data_id = OMfind_subobj(elem_id, OMstr_to_name("map_comp"), OM_OBJ_RD);
    OMget_int_val(data_id, &map_comp);
    data_id = OMfind_subobj(elem_id, OMstr_to_name("scale_comp"), OM_OBJ_RD);
    OMget_int_val(data_id, &scale_comp);
    tmp = OMfind_subobj(elem_id, OMstr_to_name("scale_x"), OM_OBJ_RD);
    OMget_int_val(tmp, &scale_x);
    tmp = OMfind_subobj(elem_id, OMstr_to_name("scale_y"), OM_OBJ_RD);
    OMget_int_val(tmp, &scale_y);
    tmp = OMfind_subobj(elem_id, OMstr_to_name("scale_z"), OM_OBJ_RD);
    OMget_int_val(tmp, &scale_z);
    if (FUNCglyph(in, glyph, vec, norm, scale, comp, map_comp,
                  scale_comp, scale_x, scale_y, scale_z, out) == METHOD_SUCCESS ) {
        return METHOD_SUCCESS;
    }
    else return METHOD_FAILURE;
}


/* 64-bit porting. Only Modified Internally */
int
DV_ARRglyph_update(OMobj_id elem_id, OMevent_mask event_mask, int seq_num)
{
    OMobj_id in_arr, out_arr;
    xp_long i, num_fields;
    OMobj_id in, out, glyph, scale_id, norm_id, vec_id, data_id, tmp;
    int norm, vec, comp, map_comp, scale_comp, scale_x, scale_y, scale_z;
    double scale;
    int stat;

    in_arr  = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
    out_arr = OMfind_subobj(elem_id, OMstr_to_name("out"), OM_OBJ_RW);

    stat = OMget_array_size( in_arr, &num_fields );
    if( stat != OM_STAT_SUCCESS ) return METHOD_FAILURE;

    stat = OMset_array_size( out_arr, num_fields );
    if( stat != OM_STAT_SUCCESS ) return METHOD_FAILURE;

    glyph = OMfind_subobj(elem_id, OMstr_to_name("glyph"), OM_OBJ_RD);
    scale_id = OMfind_subobj(elem_id, OMstr_to_name("scale"), OM_OBJ_RD);
    OMget_real_val(scale_id, &scale);
    norm_id = OMfind_subobj(elem_id, OMstr_to_name("normalize"), OM_OBJ_RD);
    OMget_int_val(norm_id, &norm);
    vec_id = OMfind_subobj(elem_id, OMstr_to_name("vector"), OM_OBJ_RD);
    OMget_int_val(vec_id, &vec);
    data_id = OMfind_subobj(elem_id, OMstr_to_name("glyph_comp"), OM_OBJ_RD);
    OMget_int_val(data_id, &comp);
    data_id = OMfind_subobj(elem_id, OMstr_to_name("map_comp"), OM_OBJ_RD);
    OMget_int_val(data_id, &map_comp);
    data_id = OMfind_subobj(elem_id, OMstr_to_name("scale_comp"), OM_OBJ_RD);
    OMget_int_val(data_id, &scale_comp);
    tmp = OMfind_subobj(elem_id, OMstr_to_name("scale_x"), OM_OBJ_RD);
    OMget_int_val(tmp, &scale_x);
    tmp = OMfind_subobj(elem_id, OMstr_to_name("scale_y"), OM_OBJ_RD);
    OMget_int_val(tmp, &scale_y);
    tmp = OMfind_subobj(elem_id, OMstr_to_name("scale_z"), OM_OBJ_RD);
    OMget_int_val(tmp, &scale_z);

    for( i = 0; i < num_fields; ++i ) {
        stat = OMget_array_val( in_arr, i, &in, OM_OBJ_RD );
        if( stat != OM_STAT_SUCCESS ) continue;
        stat = OMget_array_val( out_arr, i, &out, OM_OBJ_RW );
        if( stat != OM_STAT_SUCCESS ) continue;

        FUNCglyph(in, glyph, vec, norm, scale, comp, map_comp,
                  scale_comp, scale_x, scale_y, scale_z, out);
    }

    return METHOD_SUCCESS;
}


/* 64-bit porting. Only Modified Internally */
int FUNCglyph (OMobj_id in, OMobj_id glyph, int vec_flag, int norm,
               double scale, int comp, int map_comp, int scale_comp,
               int scale_x, int scale_y, int scale_z, OMobj_id out)
{
	xp_long nnodes, nnodes_g, count, size;
	int   data_type, map_data_type, scale_data_type;
	int   poly_flag, *poly_nnodes, *out_poly_nnodes;
	xp_long polyhedron, npoly, *poly_conn, *out_poly_conn;
	int   veclen, map_veclen, scale_veclen,  ncomp;
	xp_long *node_list, *out_node_list, ncells, *pick_data;
	int   nsets, cs, cell_nnodes;
	int   null_flag, map_null_flag, scale_null_flag, nspace, nspace_g, nspace_out, comp_flag;
	int   stat, scale_xyz[3];
	xp_long i, j, k, n, m;
	char  units[MAX_NAME_SIZE], label[MAX_NAME_SIZE], name[MAX_NAME_SIZE];
	float  *coord_g, *out_coord, *xfm, xform[4][4], *in_xfm, in_xform[4][4];
	char   *mesh_info, *node_data, *map_data, *scale_data, *out_data;
	double null_value, map_null_value, scale_null_value;
	OMobj_id   cell_set, out_cell_set;

	/********************************/
	/*   Free pre-allocated arrays  */
	/********************************/
	if (FLDset_nnodes (out, 0) != 1) {
		ERR_RETURN("Error setting nnodes");
	}
	if (FLDset_node_data_ncomp (out, 0) != 1) {
		ERR_RETURN("Error setting nnode_data");
	}
	if (FLDset_ncell_sets(out, 0) != 1) {
		ERR_RETURN("cannot get nsets");
	}
	out_coord = NULL;
	if (FLDset_coord(out, out_coord, 0, OM_SET_ARRAY_FREE) != 1) {
		ERR_RETURN("Error setting out_coord");
	}

	if (FLDget_nnodes(in, &nnodes) != 1) {
		return 0;
	}
	if (FLDget_nnodes(glyph, &nnodes_g) != 1) {
		return 0;
	}

	if (FLDget_node_data_ncomp(in, &ncomp) != 1) {
		ERR_RETURN("Error getting ncomp");
	}
	if (nnodes == 0 || nnodes_g == 0 || ncomp == 0) {
		if (ncomp == 0) {
			ERR_RETURN("no data component in the input field, glyph is not created");
		}
		return(1);
	}

	stat = FLDget_mesh_info(in, &mesh_info);
	if (!stat) {
		ERR_RETURN("cannot create cell table");
	}

	if (FLDget_node_data_veclen(in, comp, &veclen) !=1) {
		ERR_RETURN("Error getting veclen");
	}
	if (veclen > 3) {
		ERR_RETURN("data veclen > 3, glyph is not created");
	}
	if (FLDget_node_data(in, comp, &data_type, &node_data, &size, OM_GET_ARRAY_RD) != 1) {
		return(0);
	}
	if (FLDget_node_null_data(in, comp, &null_flag, (char *)&null_value) != 1) {
		ERR_RETURN("cannot get null data");
	}

	if (comp != map_comp) {
		if (FLDget_node_data_veclen(in, map_comp, &map_veclen) !=1) {
			ERR_RETURN("Error getting veclen");
		}
		if (map_veclen > 3) {
			ERR_RETURN("data veclen > 3, glyph is not created");
		}
		if (FLDget_node_data(in, map_comp, &map_data_type, &map_data, &size, OM_GET_ARRAY_RD) != 1) {
			ERR_RETURN("cannot get node data");
		}
		if (data_type != map_data_type) {
			ERR_RETURN("Glyph component and map component must be of the same type");
		}
		if (FLDget_node_null_data(in, map_comp, &map_null_flag, (char *)&map_null_value) != 1) {
			ERR_RETURN("cannot get null data");
		}
	}
	else {
		map_veclen = veclen;
		map_data = node_data;
		map_null_flag = null_flag;
		memcpy((char *)&map_null_value, (char *)&null_value, sizeof(double));
	}
	if (comp != scale_comp) {
		if (FLDget_node_data_veclen(in, scale_comp, &scale_veclen) !=1) {
			ERR_RETURN("Error getting veclen");
		}
		if (scale_veclen > 3) {
			ERR_RETURN("data veclen > 3, glyph is not created");
		}
		if (FLDget_node_data(in, scale_comp, &scale_data_type, &scale_data, &size, OM_GET_ARRAY_RD) != 1) {
			ERR_RETURN("cannot get node data");
		}
		if (data_type != scale_data_type) {
			ERR_RETURN("Glyph component and scale component must be of the same type");
		}
		if (FLDget_node_null_data(in, scale_comp, &scale_null_flag, (char *)&scale_null_value) != 1) {
			ERR_RETURN("cannot get null data");
		}
	}
	else {
		scale_veclen = veclen;
		scale_data = node_data;
		scale_null_flag = null_flag;
		memcpy((char *)&scale_null_value, (char *)&null_value, sizeof(double));
	}
	if (FLDget_nspace(in, &nspace) != 1) {
		ERR_RETURN("cannot get nspace");
	}
	if (FLDget_nnodes(glyph, &nnodes_g) != 1) {
		ERR_RETURN("cannot get nnodes");
	}
	if (FLDget_coord(glyph, &coord_g, &size, OM_GET_ARRAY_RD) != 1) {
		ERR_RETURN("cannot get coordinates");
	}
	if (FLDget_nspace(glyph, &nspace_g) != 1) {
		ERR_RETURN("cannot get nspace");
	}
	stat = FLDget_xform(glyph, (float *)xform);
	if (stat < 0) {
		ERR_RETURN("cannot get xform for probe");
	}
	else if (stat == 0) {
		xfm = (float *)0;
	}
	else if (MATmat_is_identity((float *)xform, 4))
		xfm = (float *)0;
	else
		xfm = (float *)xform;
	stat = FLDget_xform(in, (float *)in_xform);
	if (stat < 0) {
		ERR_RETURN("cannot get xform for field");
	}
	else if (stat == 0) {
		in_xfm = (float *)0;
	}
	else if (MATmat_is_identity((float *)in_xform, 4))
		in_xfm = (float *)0;
	else {
		in_xfm = (float *)in_xform;
	}

	/*** OUTPUT GRID ***/
	nspace_out = (nspace > nspace_g) ? nspace : nspace_g;
	if (nspace_out == 2 && in_xfm)
		MATmat4_xform_dim(in_xfm, &nspace_out);


	if (FLDget_coord_units(in, units, MAX_NAME_SIZE) == 1) {
		if (FLDset_coord_units (out, units) != 1) {
			ERR_RETURN("Error setting units");
		}
	}
	if (FLDset_nspace (out, nspace_out) != 1) {
		ERR_RETURN("Error setting nspace");
	}
	if (FLDset_nnodes (out, nnodes*nnodes_g) != 1) {
		ERR_RETURN("Error setting nnodes");
	}
	if (FLDget_coord(out, &out_coord, &size, OM_GET_ARRAY_WR) != 1) {
		ERR_RETURN("Error setting coordinate array");
	}

	if (FLDset_node_data_ncomp (out, 2) != 1) {
		ERR_RETURN("Error setting nnode_data");
	}
	if (FLDget_node_data_units(in, map_comp, units, MAX_NAME_SIZE) != 1) {
		strcpy(units, "");
	}
	if (FLDget_node_data_label(in, map_comp, label, MAX_NAME_SIZE) != 1) {
		strcpy(label, "");
	}
	if (FLDset_node_data_comp (out, 0, 1, label, units) != 1) {
		ERR_RETURN("Error setting node component");
	}
	if (FLDget_node_data(out, 0, &data_type, &out_data,
			     &size, OM_GET_ARRAY_WR) != 1) {
		ERR_RETURN("cannot get node data");
	}
	if (FLDcopy_node_minmax(in, out, map_comp, 0) != 1) {
		ERR_RETURN("Error copying node minmax");
	}
	/***
	if (FLDcopy_node_minmax_vec(in, out, map_comp, 0) != 1) {
		ERR_RETURN("Error copying node minmax");
	}
	***/
	if (map_null_flag) {
		if (FLDset_node_null_data(out, 0, (char *)&map_null_value, data_type) != 1) {
			ERR_RETURN("cannot set null data");
		}
	}
	else {
		if (FLDset_node_null_flag(out, 0, 0) != 1) {
			ERR_RETURN("Error setting null flag");
		}
	}

	if (vec_flag == 0) {
		vec_flag = 0;
		comp_flag = 0;
	}
	else if (vec_flag == 1) {
		vec_flag = 1;
		comp_flag = 0;
	}
	else if (vec_flag == 2) {
		vec_flag = 0;
		comp_flag = 1;
	}

	if (FLDset_ncell_sets(out, 0) != 1) {
		ERR_RETURN("cannot get nsets");
	}
	scale_xyz[0] = scale_x;
	scale_xyz[1] = scale_y;
	scale_xyz[2] = scale_z;

	stat = UTILglyph_func(mesh_info, data_type, veclen, node_data,
			      null_flag, (char *)&null_value, scale_veclen, map_veclen,
			      scale_data, map_data,
			      vec_flag, comp_flag, norm, scale, scale_xyz, in_xfm, nnodes_g, nspace_g, coord_g,
			      xfm, nspace_out, out_coord, out_data);
	if (stat != 1) {
		if (FLDset_nnodes (out, 0) != 1) {
			ERR_RETURN("Error setting nnodes");
		}
		if (FLDset_node_data_ncomp (out, 0) != 1) {
			ERR_RETURN("Error setting nnode_data");
		}

		FLDfree_mesh_info(mesh_info);
		if (map_data != node_data)
			ARRfree(map_data);
		if (scale_data != node_data)
			ARRfree(scale_data);
		ARRfree(node_data);
		ARRfree(coord_g);
		ARRfree(out_coord);
		ARRfree(out_data);
		ERR_RETURN("glyphs are not created");
	}
	/*---------------*/
	/*   OUT CELLS   */
	/*---------------*/
	if (FLDget_ncell_sets(glyph, &nsets) != 1) {
		ERR_RETURN("cannot get nsets");
	}
	for (cs=0; cs<nsets; cs++) {
		if (FLDget_cell_set(glyph, cs, &cell_set) != 1) {
			ERR_RETURN("cannot get cell set");
		}
		if (FLDget_cell_set_name(cell_set, name, MAX_NAME_SIZE) != 1) {
			ERR_RETURN("cannot get cell set name");
		}
		if (FLDadd_cell_set(out, name) != 1) {
			ERR_RETURN("Error setting cell type");
		}
		if (FLDget_cell_set(out, cs, &out_cell_set) != 1) {
			ERR_RETURN("Error getting cell set");
		}
		if (FLDget_poly_flag(cell_set, &poly_flag) != 1) {
			poly_flag = 0;
		}
		if (poly_flag == 0) {
			if (FLDget_cell_set_nnodes(cell_set,  &cell_nnodes) != 1) {
				ERR_RETURN("cannot get cell nnodes");
			}
			if (FLDget_ncells(cell_set, &ncells) != 1) {
				ERR_RETURN("cannot get ncells");
			}
			if (FLDset_ncells(out_cell_set, ncells*nnodes) != 1) {
				ERR_RETURN("Error setting ncells");
			}
			if (FLDget_node_connect(cell_set, &node_list,
						&size, OM_GET_ARRAY_RD) != 1) {
				ERR_RETURN("cannot get cell connectivity");
			}
			if (FLDget_node_connect(out_cell_set, &out_node_list,
						&size, OM_GET_ARRAY_WR) != 1) {
				ERR_RETURN("cannot get cell connectivity");
			}
			m = cell_nnodes*ncells;
			for (i=0; i<nnodes; i++) {
				k = i*m;
				n = i*nnodes_g;
				for (j=0; j<m; j++)
					out_node_list[k+j] = node_list[j] + n;
			}
			ARRfree(node_list);
			ARRfree(out_node_list);
		}
		else {
			if (FLDget_npolys(cell_set, &npoly) != 1) {
				ERR_RETURN("cannot get ncells");
			}
			if (FLDset_npolys(out_cell_set, npoly*nnodes) != 1) {
				ERR_RETURN("cannot get ncells");
			}
			if (FLDget_poly_nnodes(cell_set, &poly_nnodes, &size, OM_GET_ARRAY_RD) != 1) {
				ERR_RETURN("cannot get poly_nnodes");
			}
			if (FLDget_poly_connect(cell_set, &poly_conn, &size, OM_GET_ARRAY_RD) != 1) {
				ERR_RETURN("cannot get poly connectivity");
			}
			if (FLDget_poly_nnodes(out_cell_set, &out_poly_nnodes, &size, OM_GET_ARRAY_RW) != 1) {
				ERR_RETURN("cannot get poly_nnodes");
			}
			for (m=0,polyhedron=0,i=0; i<npoly; i++) {
				m += poly_nnodes[i];
				if (poly_nnodes[i] != 2)
					polyhedron=1;
			}
			if (polyhedron == 0) {
				if (FLDget_poly_connect(out_cell_set, &out_poly_conn, &size, OM_GET_ARRAY_RW) != 1) {
					ERR_RETURN("cannot get poly connectivity");
				}
				m = 2*npoly;
				for (i=0; i<nnodes; i++) {
					k = i*m;
					n = i*nnodes_g;
					for (j=0; j<m; j++)
						out_poly_conn[k+j] = poly_conn[j] + n;
				}
				ARRfree(out_poly_conn);
			}
			else {
				out_poly_conn = (xp_long *)ARRalloc(NULL, DTYPE_LONG, m*nnodes, NULL);
				for (count=0, i=0; i<nnodes; i++) {
					for (j=0; j<npoly; j++)
						out_poly_nnodes[count++] = poly_nnodes[j];
					k = i*m;
					n = i*nnodes_g;
					for (j=0; j<m; j++)
						out_poly_conn[k+j] = poly_conn[j] + n;
				}
				if (FLDset_poly_connect(out_cell_set, out_poly_conn, m*nnodes, OM_SET_ARRAY_FREE) != 1) {
					ERR_RETURN("cannot get poly connectivity");
				}
			}
			ARRfree(poly_conn);
			ARRfree(poly_nnodes);
			ARRfree(out_poly_nnodes);
		}
	}

	/* set pick data */
	if (FLDget_nnodes(in, &nnodes) != 1) {
		ERR_RETURN("cannot get nnodes");
	}
	if (FLDset_node_data_veclen(out, 1, 1) !=1) {
		ERR_RETURN("Error setting veclen");
	}
	if (FLDset_node_data_id(out, 1, GD_PICK_DATA_ID) != 1) {
		ERR_RETURN("Error setting data id");
	}
	data_type = DTYPE_LONG;
	if (FLDget_node_data(out, 1, &data_type, (char **)&pick_data, &size, OM_GET_ARRAY_WR) != 1) {
		ERR_RETURN("cannot get node data");
	}
	for (k=0,i=0; i<nnodes; i++)
		for (j=0; j<nnodes_g; j++)
			pick_data[k++]=i;
	ARRfree(pick_data);

	FLDfree_mesh_info(mesh_info);
	if (map_data != node_data)
		ARRfree(map_data);
	if (scale_data != node_data)
		ARRfree(scale_data);
	ARRfree(node_data);
	ARRfree(coord_g);
	ARRfree(out_coord);
	ARRfree(out_data);
	return(1);
}
