/*
			Copyright (c) 1996 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/image.h#1 $
*/

#ifndef XP_DV_IMAGE_H
#define XP_DV_IMAGE_H 1

/* file formats */
#define DV_IMAGE_FORMAT_NOFILE  -1
#define DV_IMAGE_FORMAT_UNKNOWN -2
#define DV_IMAGE_FORMAT_MISMATCH -3

#define DV_IMAGE_FORMAT_AUTO    0

#define DV_IMAGE_FORMAT_AVSX    1
#define DV_IMAGE_FORMAT_BMP     2
#define DV_IMAGE_FORMAT_GIF     3
#define DV_IMAGE_FORMAT_JPEG    4
#define DV_IMAGE_FORMAT_PBM     5
#define DV_IMAGE_FORMAT_SGIRGB  6
#define DV_IMAGE_FORMAT_SUNRAS  7
#define DV_IMAGE_FORMAT_TIFF    8

#define DV_IMAGE_FORMAT_PS      9
#define DV_IMAGE_FORMAT_UTAH   10
#define DV_IMAGE_FORMAT_Z      11
#define DV_IMAGE_FORMAT_GZIP   12

/* file access types (bitfield) */
#define DV_IMAGE_FILE_ACCESS_UNSET      0
#define DV_IMAGE_FILE_ACCESS_READ       1
#define DV_IMAGE_FILE_ACCESS_WRITE      2
#define DV_IMAGE_FILE_ACCESS_READ_WRITE 3

/* file types (for output)
 * these *must* match the UI radiobox values
 */
#define DV_IMAGE_FILE_TYPE_BINARY 0
#define DV_IMAGE_FILE_TYPE_ASCII  1
#define DV_IMAGE_FILE_TYPE_MAX    1

/* depth (bits per pixel) for output
 * *must* match the UI radiobox value order...
 */
#define DV_IMAGE_DEPTH_NA  0	/* not applicable */
#define DV_IMAGE_DEPTH_1   1
#define DV_IMAGE_DEPTH_4   2
#define DV_IMAGE_DEPTH_8   3
#define DV_IMAGE_DEPTH_16  4
#define DV_IMAGE_DEPTH_24  5
#define DV_IMAGE_DEPTH_32  6
#define DV_IMAGE_DEPTH_MAX 6

/* color type (related to depth but not 1:1) (for output)
 * *must* match the UI radiobox value order...
 */
#define DV_IMAGE_COLORTYPE_RGB  0
#define DV_IMAGE_COLORTYPE_GREY 1
#define DV_IMAGE_COLORTYPE_BW   2
#define DV_IMAGE_COLORTYPE_MAX  2

/* compression method (for output)
 * *must* match the UI radiobox value order...
 */
#define DV_IMAGE_COMPRESS_NONE   0
#define DV_IMAGE_COMPRESS_RLE    1
#define DV_IMAGE_COMPRESS_LZW    2
#define DV_IMAGE_COMPRESS_JPEG   3
#define DV_IMAGE_COMPRESS_CCITT3 4
#define DV_IMAGE_COMPRESS_CCITT4 5
#define DV_IMAGE_COMPRESS_MAX    5

/* RGB to 8 bit color reduction (a.k.a. quantization) method (for output)
 * *must* match the UI radiobox value order
 */
#define DV_IMAGE_QUANTIZE_NA  0	/* not applicable */
#define DV_IMAGE_QUANTIZE_ES  1	/* exhaustive search */
#define DV_IMAGE_QUANTIZE_PH  2	/* Heckbert Median Cut */
#define DV_IMAGE_QUANTIZE_POP 3	/* histogram popularity */
#define DV_IMAGE_QUANTIZE_FS  4	/* Floyd-Steinberg dither */
#define DV_IMAGE_QUANTIZE_OCT 5 /* octree */
#define DV_IMAGE_QUANTIZE_VAR 6 /* variance-based */
#define DV_IMAGE_QUANTIZE_LK  7 /* local k-means */
#define DV_IMAGE_QUANTIZE_NEU 8	/* neural net */
#define DV_IMAGE_QUANTIZE_MAX 8


#ifdef NO_DL_LOAD
/* for bound-at-link-time ("NO_DL_LOAD") libraries, make and use a function
 * table as the interface to FUNCread_image()
 */

typedef struct _rd_funcs_t
{
  void *(*Open)();
  void (*Close)();
  int  (*GetWidth)();
  int  (*GetHeight)();
  int  (*GetARGBImage)();
} rd_funcs_t;
#endif

typedef struct _read_map {
  int     dv_val;
#ifndef NO_DL_LOAD
  const char **info;
#else
  rd_funcs_t *info;
#endif
} DV_image_read_map_t;

#define DV_IMAGE_READERS_COUNT 8
extern DV_image_read_map_t FUNCimage_readers_map[DV_IMAGE_READERS_COUNT];


/* protos for interface funcs */
void *avsOpen (char *, int);
void avsClose (void *);
int avsGetWidth (void *, int *);
int avsGetHeight (void *, int *);
int avsGetARGBImage (void *, unsigned char **);
int avsSetWidth (void *, int);
int avsSetHeight (void *, int);
int avsSetFileType (void *, int);
int avsSetDepth (void *, int);
int avsSetColorType (void *, int);
int avsSetCompressionType (void *, int, int);
int avsSetReductionType (void *, int);
int avsSetARGBImage (void *, unsigned char *, int);

void *GIFOpen (char *, int);
void GIFClose (void *);
int GIFGetWidth (void *, int *);
int GIFGetHeight (void *, int *);
int GIFGetARGBImage (void *, unsigned char **);
int GIFSetWidth (void *, int);
int GIFSetHeight (void *, int);
int GIFSetFileType (void *, int);
int GIFSetDepth (void *, int);
int GIFSetColorType (void *, int);
int GIFSetCompressionType (void *, int, int);
int GIFSetReductionType (void *, int);
int GIFSetARGBImage (void *, unsigned char *, int);

void *bmpOpen (char *, int);
void bmpClose (void *);
int bmpGetWidth (void *, int *);
int bmpGetHeight (void *, int *);
int bmpGetARGBImage (void *, unsigned char **);
int bmpSetWidth (void *, int);
int bmpSetHeight (void *, int);
int bmpSetFileType (void *, int);
int bmpSetDepth (void *, int);
int bmpSetColorType (void *, int);
int bmpSetCompressionType (void *, int, int);
int bmpSetReductionType (void *, int);
int bmpSetARGBImage (void *, unsigned char *, int);

void *jpegOpen (char *, int);
void jpegClose (void *);
int jpegGetWidth (void *, int *);
int jpegGetHeight (void *, int *);
int jpegGetARGBImage (void *, unsigned char **);
int jpegSetWidth (void *, int);
int jpegSetHeight (void *, int);
int jpegSetFileType (void *, int);
int jpegSetDepth (void *, int);
int jpegSetColorType (void *, int);
int jpegSetCompressionType (void *, int, int);
int jpegSetReductionType (void *, int);
int jpegSetARGBImage (void *, unsigned char *, int);

void *pbmOpen (char *, int);
void pbmClose (void *);
int pbmGetWidth (void *, int *);
int pbmGetHeight (void *, int *);
int pbmGetARGBImage (void *, unsigned char **);
int pbmSetWidth (void *, int);
int pbmSetHeight (void *, int);
int pbmSetFileType (void *, int);
int pbmSetDepth (void *, int);
int pbmSetColorType (void *, int);
int pbmSetCompressionType (void *, int, int);
int pbmSetReductionType (void *, int);
int pbmSetARGBImage (void *, unsigned char *, int);

void *sgiRGBOpen (char *, int);
void sgiRGBClose (void *);
int sgiRGBGetWidth (void *, int *);
int sgiRGBGetHeight (void *, int *);
int sgiRGBGetARGBImage (void *, unsigned char **);
int sgiRGBSetWidth (void *, int);
int sgiRGBSetHeight (void *, int);
int sgiRGBSetFileType (void *, int);
int sgiRGBSetDepth (void *, int);
int sgiRGBSetColorType (void *, int);
int sgiRGBSetCompressionType (void *, int, int);
int sgiRGBSetReductionType (void *, int);
int sgiRGBSetARGBImage (void *, unsigned char *, int);

void *SunRasOpen (char *, int);
void SunRasClose (void *);
int SunRasGetWidth (void *, int *);
int SunRasGetHeight (void *, int *);
int SunRasGetARGBImage (void *, unsigned char **);
int SunRasSetWidth (void *, int);
int SunRasSetHeight (void *, int);
int SunRasSetFileType (void *, int);
int SunRasSetDepth (void *, int);
int SunRasSetColorType (void *, int);
int SunRasSetCompressionType (void *, int, int);
int SunRasSetReductionType (void *, int);
int SunRasSetARGBImage (void *, unsigned char *, int);

void *TIFFBegin (char *, int);
void TIFFEnd (void *);
int TIFFGetWidth (void *, int *);
int TIFFGetHeight (void *, int *);
int TIFFGetARGBImage (void *, unsigned char **);
int TIFFSetWidth (void *, int);
int TIFFSetHeight (void *, int);
int TIFFSetFileType (void *, int);
int TIFFSetDepth (void *, int);
int TIFFSetColorType (void *, int);
int TIFFSetCompressionType (void *, int, int);
int TIFFSetReductionType (void *, int);
int TIFFSetARGBImage (void *, unsigned char *, int);

/* public utilities */

int FUNCget_image_format (const char *filename);
int FUNCget_image_format_name (int, char *);

int UTILreduce_32to8(unsigned char *, int, unsigned char *,
			     int, int, int, int *,
			     unsigned char *,
			     unsigned char *,
			     unsigned char *);

#endif
