/*
                        Copyright (c) 1996 by
                        Advanced Visual Systems Inc.
                        All Rights Reserved
         
        This software comprises unpublished confidential information of
        Advanced Visual Systems Inc. and may not be used, copied or made
        available to anyone, except in accordance with the license
        under which it is furnished.
         
        This file is under Perforce control
        $Id: //depot/express/fcs70/modules/image/libpbm/pbm.h#1 $
*/
#ifndef PBM_H
#define PBM_H   1

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>  /* time_t */

#include <avs/port.h>
#include <avs/f_utils.h>
#include <avs/err.h>
#include "../../image.h"

#define pbmSUCCESS 1
#define pbmFAILURE 0

#define pbmBYTE unsigned char

/* caller interface struct */
typedef struct _pbm_t
{
  FILE    *fp;
  int     access;		/* read and/or write */
  int     flip;
  int     type;			/* binary or ascii */
  int     width, height;
  int     colortype;		/* RGB, grey or BW */
  int     maxval;
  pbmBYTE *image, *argb_data;
} pbm_t;

int ReadpbmHeader(pbm_t *pbm);
int ReadpbmImage(pbm_t *pbm);
int Writepnm(pbm_t *pbm);

#endif
