/*
			Copyright (c) 2000 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/iso_nmap.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/fld.h>
#include <avs/arr.h>
#include <avs/dv_util.h>
#include <avs/data_utils.h>

#define METHOD_SUCCESS 1
#define METHOD_FAILURE 0

#define ERR_RETURN(A) {ERRerror("iso_nmap", 0, ERR_ORIG, A); \
                       return METHOD_FAILURE;}

/* iso.c */
int FUNCiso (OMobj_id in_mesh, OMobj_id in, int comp, double level,
             OMobj_id out, OMobj_id param,
             int ncell_data, int *cell_data);

/* nmap.c */
int FUNCnmap (OMobj_id in, OMobj_id param, int nmap_comp, int *map_comp,
              int iso_comp, double iso_val, OMobj_id out);

/* 64-bit porting. Only Modified Internally */
int
DV_ARRiso_nmap_update(OMobj_id elem_id, OMevent_mask event_mask, int seq_num)
{
    OMobj_id in_arr, out_arr;
    xp_long i, num_fields;
    OMobj_id in, out, level_id, param;
    double level;
    int comp;
    int stat, *cell_data;
    xp_long size;

    /* nMap variables */
    OMobj_id out_comp_id;
    xp_long out_ncomp;
    int *out_comp;
    int type, iso_comp;
    double iso_val;

    OMobj_id in_xform, out_xform;
    OMobj_name xform_name = OMstr_to_name("xform");

    in_arr  = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
    out_arr = OMfind_subobj(elem_id, OMstr_to_name("out"), OM_OBJ_RW);

    stat = OMget_array_size( in_arr, &num_fields );
    if( stat != OM_STAT_SUCCESS ) {
        if( !OMis_null_obj( out_arr ) ) OMset_array_size( out_arr, 0 );
        return METHOD_FAILURE;
    }
    else if( num_fields == 0 ) {
        if( !OMis_null_obj( out_arr ) ) OMset_array_size( out_arr, 0 );
        return METHOD_SUCCESS;
    }

    /* Just a single NodeParam, not an array */
    param = OMfind_subobj(elem_id, OMstr_to_name("nparam"), OM_OBJ_RW);

    /* Isosurface parameters */

    level_id = OMfind_subobj(elem_id, OMstr_to_name("level"), OM_OBJ_RD);
    OMget_real_val(level_id, &level);

    cell_data = (int *)OMret_name_array_ptr(elem_id, OMstr_to_name("cell_data"),
                                            OM_GET_ARRAY_RD, &size, NULL);
    if (size == 0) cell_data = NULL;
    if (cell_data == NULL) size = 0;

    /* OK if unset, default to component 0 */
    stat = OMget_name_int_val(elem_id, OMstr_to_name("component"), &comp);
    if (stat != OM_STAT_SUCCESS) comp = 0;

    /* Node Map parameters */

    out_comp_id = OMfind_subobj(elem_id, OMstr_to_name("map_comp"), OM_OBJ_RD);

    type = OM_TYPE_INT;
    out_ncomp = 0;
    out_comp = (int *)NULL;
    stat = OMget_array_sz(out_comp_id, &type, (char **)(&out_comp),
                          &out_ncomp, OM_GET_ARRAY_RD);
    if (stat != OM_STAT_SUCCESS) {
        out_ncomp = 0;
        out_comp = NULL;
    }
    /* Should this be different from "component", above? */
    stat = OMget_name_int_val(elem_id, OMstr_to_name("iso_comp"), &iso_comp);
    if (stat != OM_STAT_SUCCESS) {
        iso_comp = -1;
    }
    /* Should this be different from "level", above? */
    stat = OMget_name_real_val(elem_id, OMstr_to_name("iso_val"), &iso_val);
    if (stat != OM_STAT_SUCCESS) {
        iso_val = 0.0;
    }

    /*  */

    stat = OMset_array_size( out_arr, num_fields );
    if( stat != OM_STAT_SUCCESS ) return METHOD_FAILURE;

    for( i = 0; i < num_fields; ++i ) {
        stat = OMget_array_val( in_arr, i, &in, OM_OBJ_RD );
        if( stat != OM_STAT_SUCCESS ) continue;

        stat = OMget_array_val( out_arr, i, &out, OM_OBJ_RW );
        if( stat != OM_STAT_SUCCESS ) continue;

        stat = FUNCiso(in, in, comp, level, out, param,  (int)size, cell_data);

        if( stat == METHOD_SUCCESS )
            stat = FUNCnmap(in, param, (int)out_ncomp, out_comp, iso_comp, iso_val, out);

#if 0
        if( stat != METHOD_SUCCESS ) {
            ERRerror( "iso_nmap", 1, ERR_ORIG,
                      "Error while processing field: %d", i );
        }
#endif

       /* This can be done easily in V, but its faster in C. */
       in_xform  = OMfind_subobj(in,  xform_name, OM_OBJ_RD);
       out_xform = OMfind_subobj(out, xform_name, OM_OBJ_RW);
       OMset_obj_ref( out_xform, in_xform, 0 );
    }

    if (cell_data)
        ARRfree(cell_data);
    if (out_comp)
        ARRfree(out_comp);
    return METHOD_SUCCESS;
}
