/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/isol_trc.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/fld.h>
#include <avs/arr.h>
#include <avs/dv_util.h>
#include <avs/mat.h>
#include <avs/data_utils.h>

#define ERR_RETURN(A) ERRerror("isoline_trace", 0, ERR_ORIG, A); return(0);
#define MAX_NAME_SIZE 1024


int FUNCisoline_trace (OMobj_id in, OMobj_id probe, int comp, int color,
                       double *level, OMobj_id out);

int DVisoline_trace_update(OMobj_id elem_id)
{
	OMobj_id in, out, level_id, xyz_id, col_id, comp_id;
	double  level;
	int comp, color;

	in = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
	out = OMfind_subobj(elem_id, OMstr_to_name("out"), OM_OBJ_RW);
	xyz_id = OMfind_subobj(elem_id, OMstr_to_name("probe"), OM_OBJ_RD);
	level_id = OMfind_subobj(elem_id, OMstr_to_name("level"), OM_OBJ_RD);
	col_id = OMfind_subobj(elem_id, OMstr_to_name("color"), OM_OBJ_RD);
	comp_id = OMfind_subobj(elem_id, OMstr_to_name("component"), OM_OBJ_RD);
	OMget_int_val(comp_id, &comp);
	OMget_int_val(col_id, &color);

	if (FUNCisoline_trace(in, xyz_id, comp, color, &level, out)) {
		OMset_real_val(level_id, level);
		return(1);
	}
	else return(0);
}

/* 64-bit porting. Only Modified Internally */
int FUNCisoline_trace (OMobj_id in, OMobj_id probe, int comp, int color,
                       double *level, OMobj_id out)
{
	xp_long nnodes, out_ncells, out_nnodes;
	int   nspace, probe_nspace, data_type;
	xp_long size, conn_size;
	int   veclen, ncomp, data_id;
	xp_long *out_nlist, *min_node_list, *max_node_list;
	int   null_flag, stat;
	char  label[MAX_NAME_SIZE], units[MAX_NAME_SIZE];
	float  *out_coord, *t, point[3];
	char   *node_data, *out_node_data;
	char   *mesh_info, *block_table;
	double  null_value;
	OMobj_id   cell_set;
	float      *xyz, xform[4][4], *xfm, in_xform[4][4], *in_xfm, t_xform[4][4];


	/*   Free pre-allocated arrays */
	if (FLDset_nnodes (out, 0) != 1) {
		ERR_RETURN("Error setting nnodes");
	}
	if (FLDset_ncell_sets(out, 0) != 1) {
		ERR_RETURN("cannot set nsets");
	}
	if (FLDset_node_data_ncomp (out, 0) != 1) {
		ERR_RETURN("Error setting nnode_data");
	}

	/* Check the input */
	if (FLDget_nnodes(in, &nnodes) != 1) {
		ERR_RETURN("Error getting ncomp");
	}
	if (FLDget_node_data_ncomp(in, &ncomp) != 1) {
		ERR_RETURN("Error getting ncomp");
	}
	if (nnodes == 0 || ncomp == 0) {
		return(1);
	}


	stat = FLDget_mesh_info(in, &mesh_info);
	if (!stat) {
		ERR_RETURN("cannot create cell table");
	}
	stat = FLDinterp_init(in, mesh_info, &block_table);
	if (stat != 1) {
		FLDfree_mesh_info(mesh_info);
		ERR_RETURN("no block table created");
	}

	out_nnodes = 0;

	if (FLDget_nspace(probe, &probe_nspace) != 1) {
		ERR_RETURN("cannot get nspace for probe");
	}
	stat = FLDget_xform(probe, (float *)xform);
	if (stat < 0) {
		ERR_RETURN("cannot get xform for probe");
	}
	else if (stat == 0) {
		xfm = (float *)0;
	}
	else if (MATmat_is_identity((float *)xform, 4))
		xfm = (float *)0;
	else
		xfm = (float *)xform;
	stat = FLDget_xform(in, (float *)in_xform);
	if (stat < 0) {
		ERR_RETURN("cannot get xform for field");
	}
	else if (stat == 0) {
		in_xfm = (float *)0;
	}
	else if (MATmat_is_identity((float *)in_xform, 4))
		in_xfm = (float *)0;
	else
		in_xfm = (float *)in_xform;
	if (in_xfm) {
		MATmat4_inverse(t_xform, (Matr4 *)in_xfm);
		if (xfm)
			MATmat4_multiply((Matr4 *)xfm, t_xform, (Matr4 *)xfm);
	}
	if (FLDget_node_data_veclen(in, comp, &veclen) !=1) {
		ERR_RETURN("Error getting veclen");
	}

	if (veclen != 1) {
		if (FLDset_nnodes(out, 0) != 1) {
			ERR_RETURN("cannot set nnodes");
		}
		if (FLDset_ncell_sets(out, 0) != 1) {
			ERR_RETURN("cannot set nsets");
		}
		if (FLDset_node_data_ncomp (out, 0) != 1) {
			ERR_RETURN("Error setting nnode_data");
		}
		ERR_RETURN("component is not scalar, isotrace is not performed");
	}
	if (FLDget_nspace(in, &nspace) != 1) {
		ERR_RETURN("cannot get nspace");
	}
	if (FLDget_node_data(in, comp, &data_type, &node_data,
			      &size, OM_GET_ARRAY_RD) != 1) {
		ERR_RETURN("cannot get node data");
	}
	if (FLDget_node_null_data(in, comp, &null_flag, (char *)&null_value) != 1) {
		ERR_RETURN("cannot get null data");
	}

	point[0]=point[1]=point[2]=0.0;
	if (FLDget_coord(probe, &xyz, &size, OM_GET_ARRAY_RD) != 1) {
		ERR_RETURN("Error getting coordinate array");
	}
	memcpy(point, xyz, probe_nspace*sizeof(float));
	ARRfree(xyz);
	if (xfm)
		MATvec3_mat4_multiply(point, (Matr4 *)xfm);

	if (FLDset_ncell_sets (out, 0) != 1) {
		ERR_RETURN("Error setting ncell_sets");
	}
	UTILisoline_trace(mesh_info, block_table, node_data, data_type,
			  null_flag, (char *)&null_value, point, level,
			  &out_nnodes, &min_node_list, &max_node_list,
			  &out_ncells, &out_nlist, &conn_size);

	/*** OUTPUT FIELD ***/

	if (out_nnodes) {
		if (FLDget_coord_units(in, units, MAX_NAME_SIZE) == 1) {
			if (FLDset_coord_units (out, units) != 1) {
				ERR_RETURN("Error setting units");
			}
		}
		if (FLDset_nspace (out, nspace) != 1) {
			ERR_RETURN("Error setting nspace");
		}
		if (FLDset_nnodes (out, out_nnodes) != 1) {
			ERR_RETURN("Error setting nnodes");
		}
		if (FLDset_ncell_sets (out, 1) != 1) {
			ERR_RETURN("Error setting ncell_sets");
		}
		if (FLDget_cell_set(out, 0, &cell_set) != 1) {
			ERR_RETURN("Error getting cell set");
		}
		if (FLDset_cell_set(cell_set, "Line") != 1) {
			ERR_RETURN("Error setting cell type");
		}
		if (FLDset_ncells(cell_set, out_ncells) != 1) {
			ERR_RETURN("Error setting ncells");
		}
		if (FLDget_coord(out, &out_coord, &size, OM_GET_ARRAY_WR) != 1) {
			ERR_RETURN("Error setting coordinate array");
		}
		if (FLDset_node_connect(cell_set, out_nlist, conn_size,
					    OM_SET_ARRAY_FREE) != 1) {
			ERR_RETURN("Error setting cell connect list");
		}
		t = (float *)malloc(out_nnodes*sizeof(float));
		if (t==NULL) {
			ERR_RETURN("Error allocating t parameter");
		}
		UTILget_param(out_nnodes, data_type, node_data,
			      *level, min_node_list, max_node_list, t);
		UTILeval_coord(mesh_info, out_nnodes,
			       min_node_list, max_node_list, t, out_coord);
		free(t);
		if (color) {
			if (FLDset_node_data_ncomp (out, 1) != 1) {
				ERR_RETURN("Error setting nnode_data");
			}
			if (FLDget_node_data_units(in, comp, units, MAX_NAME_SIZE) != 1) {
				strcpy(units, "");
			}
			if (FLDget_node_data_label(in, comp, label, MAX_NAME_SIZE) != 1) {
				strcpy(label, "");
			}
			if (FLDset_node_data_comp (out, 0, 1, label, units) != 1) {
				ERR_RETURN("Error setting node component");
			}

			if (FLDget_node_data_id(in, comp, &data_id) == 1)
				FLDset_node_data_id(out, 0, data_id);
			if (FLDget_node_data(out, 0, &data_type, &out_node_data,
					     &size, OM_GET_ARRAY_WR) != 1) {
				ERR_RETURN("Error setting node data");
			}

			if (FLDcopy_node_minmax(in, out, comp, 0) != 1) {
				ERR_RETURN("Error copying node minmax");
			}
			if (FLDcopy_node_minmax_vec(in, out, comp, 0) != 1) {
				ERR_RETURN("Error copying node minmax");
			}

			if (FLDget_node_data_type(in, comp, &data_type) != 1) {
				ERR_RETURN("Error copying node minmax");
			}

			UTILinit_array(out_node_data, out_nnodes,
				       *level, data_type);
			ARRfree(out_node_data);
		}
		else {
			if (FLDset_node_data_ncomp (out, 0) != 1) {
				ERR_RETURN("Error setting nnode_data");
			}
		}
	}
	else {
		ARRfree(out_nlist);
	}
	FLDfree_mesh_info (mesh_info);
	FLDinterp_end(block_table);

	ARRfree(min_node_list);
	ARRfree(max_node_list);
	ARRfree(node_data);
	ARRfree(out_coord);
	return(1);
}
