/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/match.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/om_att.h>
#include <avs/om_type.h>

#define METHOD_SUCCESS 1
#define METHOD_FAILURE 0
#define METHOD_ERROR   0

/* 64-bit porting. Only Modified Internally */
int DVfld_match_update(OMobj_id elem_id)
{
    OMobj_id in, links, link, ind_id, ref;
    int  found, ind, stat;
    xp_long i, nlink;
    OMobj *link_ptr;

    in = OMfind_subobj(elem_id,OMstr_to_name("in"),OM_OBJ_RD);
    links = OMfind_subobj(elem_id,OMstr_to_name("links"),OM_OBJ_RW);
    ind_id = OMfind_subobj(elem_id,OMstr_to_name("index"),OM_OBJ_RW);

    stat = OMget_num_subobjs(links, &nlink);
    if (stat != OM_STAT_SUCCESS)
        return METHOD_FAILURE;
    ind = -1;
    found = 0;
    for (i=0; i<nlink; i++) {
        if ((stat = OMget_array_subobj(links, i, &link, OM_OBJ_RW)) != 1)
            continue;

        /*
         * If there are no objects referencing this link, we must
         * blow it off.
         */
        link_ptr = OMmap_id_to_obj(link);
        if (link_ptr->refs == NULL) continue;

        /*
         * We use the 'ref_to' guy to make sure that we don't
         * end up improperly matching the object that is currently
         * connected.
         */
        if (ind == -1) /* Only match while we are using this result*/
            stat = OMref_to_match_obj(link, in, OM_MATCH_EXACT |
                                                OM_MATCH_NO_ERROR);
        else
            stat = OM_STAT_FAILURE;
        if (stat == OM_STAT_SUCCESS)  {
            if (OMget_obj_ref(link, &ref, 0) != 1 ||
                !OMequal_objs(ref, in)) {
                stat = OMset_obj_ref(link, in, OM_OBJ_REF_RDONLY);
            }
            else stat = OM_STAT_SUCCESS;
            /*
             * This is a workaround for a problem with
             * the above... since we are directly connecting
             * objects (and we don't have an intermediate name
             * reference object) the events are not properly
             * being generated for anyone downstream to revalid
             * ate the dependencies.  Eventually this could
             * just be removed.
             */
            OMsend_event(link, OM_EVENT_ADD_REF_TO);
            ind = (int)i;
            found = 1;
        }
        else {
            if (OMget_obj_ref(link, &ref, 0) == OM_STAT_SUCCESS)
                stat = OMset_obj_ref(link, OMnull_obj, 0);
            else
                stat = OM_STAT_SUCCESS;
        }

        if (stat != OM_STAT_SUCCESS) {
            ERRerror("match", 0, ERR_ORIG, "can't set link reference");
            return METHOD_ERROR;
        }
    }
    if (found) {
        stat = OMset_int_val(ind_id, ind);
	if (stat == OM_STAT_SUCCESS) stat = METHOD_SUCCESS;
	else                         stat = METHOD_FAILURE;
        return stat;
    }
    return METHOD_SUCCESS;
}

/* 64-bit porting. Only Modified Internally */
int
DV_ARRfld_match_update(OMobj_id elem_id, OMevent_mask event_mask, int seq_num)
{
    OMobj_id in, links, link, ind_id, ref;
    int  found, ind, stat;
    xp_long i, nlink, num_fields = -1;
    OMobj *link_ptr;

    in = OMfind_subobj(elem_id,OMstr_to_name("in"),OM_OBJ_RD);

    /* These next two lines are the only difference from DVfld_match_update */
    stat = OMget_array_size( in, &num_fields );
    if( num_fields <= 0 || stat != OM_STAT_SUCCESS ) return METHOD_FAILURE;

    links = OMfind_subobj(elem_id,OMstr_to_name("links"),OM_OBJ_RW);
    ind_id = OMfind_subobj(elem_id,OMstr_to_name("index"),OM_OBJ_RW);

    stat = OMget_num_subobjs(links, &nlink);
    if (stat != OM_STAT_SUCCESS)
        return METHOD_FAILURE;
    ind = -1;
    found = 0;
    for (i=0; i<nlink; i++) {
        if ((stat = OMget_array_subobj(links, i, &link, OM_OBJ_RW)) != 1)
            continue;

        /*
         * If there are no objects referencing this link, we must
         * blow it off.
         */
        link_ptr = OMmap_id_to_obj(link);
        if (link_ptr->refs == NULL) continue;

        /*
         * We use the 'ref_to' guy to make sure that we don't
         * end up improperly matching the object that is currently
         * connected.
         */
        if (ind == -1) /* Only match while we are using this result*/
            stat = OMref_to_match_obj(link, in, OM_MATCH_EXACT |
                                                OM_MATCH_NO_ERROR);
        else
            stat = OM_STAT_FAILURE;
        if (stat == OM_STAT_SUCCESS)  {
            if (OMget_obj_ref(link, &ref, 0) != 1 || !OMequal_objs(ref, in)) {
                stat = OMset_obj_ref(link, in, OM_OBJ_REF_RDONLY);
            }
            else stat = OM_STAT_SUCCESS;
            /*
             * This is a workaround for a problem with
             * the above... since we are directly connecting
             * objects (and we don't have an intermediate name
             * reference object) the events are not properly
             * being generated for anyone downstream to revalidate
             * the dependencies.  Eventually this could
             * just be removed.
             */
            OMsend_event(link, OM_EVENT_ADD_REF_TO);
            ind = (int)i;
            found = 1;
        }
        else {
            if (OMget_obj_ref(link, &ref, 0) == OM_STAT_SUCCESS )
                stat = OMset_obj_ref(link, OMnull_obj, 0);
            else
                stat = OM_STAT_SUCCESS;
        }

        if (stat != OM_STAT_SUCCESS) {
            ERRerror("match", 0, ERR_ORIG, "can't set link reference");
            return METHOD_ERROR;
        }
    }
    if (found) {
        stat = OMset_int_val(ind_id, ind);
	if (stat == OM_STAT_SUCCESS) stat = METHOD_SUCCESS;
	else                         stat = METHOD_FAILURE;
        return stat;
    }
    return METHOD_SUCCESS;
}

