/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/nmap.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/fld.h>
#include <avs/arr.h>
#include <avs/dv_util.h>
#include <avs/data_utils.h>

#define METHOD_SUCCESS 1
#define METHOD_FAILURE 0

#define ERR_RETURN(A) {ERRerror("nmap", 0, ERR_ORIG, A); \
                       return METHOD_FAILURE;}

#define MAX_NAME_SIZE 1024

int FUNCnmap (OMobj_id in, OMobj_id param, int nmap_comp, int *map_comp,
              int iso_comp, double iso_val, OMobj_id out);

/* 64-bit porting. Only Modified Internally */
int DVnmap_update(OMobj_id elem_id)
{
    OMobj_id in, out, param, out_comp_id;
    xp_long out_ncomp;
    int *out_comp;
    int type, stat, iso_comp;
    double iso_val;

    in = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
    param = OMfind_subobj(elem_id, OMstr_to_name("nparam"), OM_OBJ_RW);
    out = OMfind_subobj(elem_id, OMstr_to_name("out"), OM_OBJ_RW);
    out_comp_id = OMfind_subobj(elem_id, OMstr_to_name("map_comp"),
                                OM_OBJ_RD);

    type = OM_TYPE_INT;
    out_ncomp = 0;
    out_comp = (int *)NULL;
    stat = OMget_array_sz(out_comp_id, &type, (char **)(&out_comp),
                          &out_ncomp, OM_GET_ARRAY_RD);
    if (stat != OM_STAT_SUCCESS) {
        out_ncomp = 0;
        out_comp = NULL;
    }
    stat = OMget_name_int_val (elem_id, OMstr_to_name("iso_comp"), &iso_comp);
    if (stat != OM_STAT_SUCCESS) {
        iso_comp = -1;
    }
    stat = OMget_name_real_val (elem_id, OMstr_to_name("iso_val"), &iso_val);
    if (stat != OM_STAT_SUCCESS) {
        iso_val = 0.0;
    }
    stat = FUNCnmap(in, param, (int)out_ncomp, out_comp, iso_comp, iso_val, out);

    if (out_comp)
        ARRfree(out_comp);
    return stat;
}


/* 64-bit porting. Only Modified Internally */
int
DV_ARRnmap_update(OMobj_id elem_id, OMevent_mask event_mask, int seq_num)
{
    OMobj_id in_arr, param_arr, out_arr;
    xp_long i, num_fields;
    OMobj_id in, out, param, out_comp_id;
    xp_long out_ncomp;
    int *out_comp;
    int type, stat, iso_comp;
    double iso_val;

    in_arr = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
    param_arr = OMfind_subobj(elem_id, OMstr_to_name("nparam"), OM_OBJ_RW);
    out_arr = OMfind_subobj(elem_id, OMstr_to_name("out"), OM_OBJ_RW);
    out_comp_id = OMfind_subobj(elem_id, OMstr_to_name("map_comp"), OM_OBJ_RD);

    stat = OMget_array_size( in_arr, &num_fields );
    if( stat != OM_STAT_SUCCESS ) return METHOD_FAILURE;

    stat = OMset_array_size( out_arr, num_fields );
    if( stat != OM_STAT_SUCCESS ) return METHOD_FAILURE;

    type = OM_TYPE_INT;
    out_ncomp = 0;
    out_comp = (int *)NULL;
    stat = OMget_array_sz(out_comp_id, &type, (char **)(&out_comp),
                          &out_ncomp, OM_GET_ARRAY_RD);
    if (stat != OM_STAT_SUCCESS) {
        out_ncomp = 0;
        out_comp = NULL;
    }
    stat = OMget_name_int_val(elem_id, OMstr_to_name("iso_comp"), &iso_comp);
    if (stat != OM_STAT_SUCCESS) {
        iso_comp = -1;
    }
    stat = OMget_name_real_val(elem_id, OMstr_to_name("iso_val"), &iso_val);
    if (stat != OM_STAT_SUCCESS) {
        iso_val = 0.0;
    }

    for( i = 0; i < num_fields; ++i ) {
        int nnodes;
        stat = OMget_array_val( in_arr, i, &in, OM_OBJ_RD );
        if( stat != OM_STAT_SUCCESS ) continue;

        stat = OMget_array_val( param_arr, i, &param, OM_OBJ_RD );
        if( stat != OM_STAT_SUCCESS ) continue;

        /* Not sure why this is happening. */
        /* OMget_name_int_val( field, OMstr_to_name(name), val) */
        if (FLDget_int(param, "nnodes", &nnodes) != OM_STAT_SUCCESS)
            continue;

        stat = OMget_array_val( out_arr, i, &out, OM_OBJ_RW );
        if( stat != OM_STAT_SUCCESS ) continue;

        stat = FUNCnmap(in, param, (int)out_ncomp, out_comp, iso_comp, iso_val, out);
#if 0
        if( stat != METHOD_SUCCESS ) {
            ERRerror( "nmap", 1, ERR_ORIG,
                      "Error while processing field: %d", i );
        }
#endif
    }

    if (out_comp)
        ARRfree(out_comp);
    return METHOD_SUCCESS;
}


/* 64-bit porting. Only Modified Internally */
int FUNCnmap (OMobj_id in, OMobj_id param, int nmap_comp, int *map_comp,
              int iso_comp, double iso_val, OMobj_id out)
{
	int   i, veclen, ncomp;
	xp_long nnodes, par_nnodes, size;
	xp_long *min_node_list, *max_node_list;
	int   comp, data_type, data_id, null_flag, stat;
	char  label[MAX_NAME_SIZE], units[MAX_NAME_SIZE];
	float  *t;
	char   *node_data, *out_node_data;
	double null_value;

	if (FLDget_node_data_ncomp(in, &ncomp) != 1) {
		ERR_RETURN("Error getting ncomp");
	}
	if (FLDget_nnodes(in, &nnodes) != 1) {
		ERR_RETURN("cannot get nnodes");
	}

	if (FLDget_long(param, "nnodes", &par_nnodes) != 1) {
		ERR_RETURN("cannot get nnodes");
	}

	if (FLDset_node_data_ncomp (out, 0) != 1) {
		ERR_RETURN("Error setting nnode_data");
	}
	if (nnodes == 0 || par_nnodes == 0 || ncomp == 0 || nmap_comp == 0) {
		if (FLDset_nnodes (out, par_nnodes) != 1) {
			ERR_RETURN("Error setting nnodes");
		}
		if (FLDset_node_data_ncomp (out, 0) != 1) {
			ERR_RETURN("Error setting nnode_data");
		}
		return(1);
	}
	for (i=0; i<nmap_comp; i++) {
		if (map_comp[i] >= ncomp) {
			if (FLDset_nnodes(out, par_nnodes) != 1) {
				ERR_RETURN("cannot set nnodes");
			}
			if (FLDset_node_data_ncomp (out, 0) != 1) {
				ERR_RETURN("Error setting nnode_data");
			}
			ERR_RETURN("requested component does not exist, mapping is not performed");
		}
	}

	if (FLDget_array_long (param, "min_node", &min_node_list, &size,
			       OM_GET_ARRAY_RD) != 1) {
		ERR_RETURN("Error getting min_node_list");
	}
	if (FLDget_array_long (param, "max_node", &max_node_list, &size,
			       OM_GET_ARRAY_RD) != 1) {
		ERR_RETURN("Error getting max_node_list");
	}
	if (FLDget_array_float (param, "tpar", &t, &size,
				 OM_GET_ARRAY_RD) != 1) {
		ERR_RETURN("Error getting t array");
	}

	if (FLDset_nnodes (out, par_nnodes) != 1) {
		ERR_RETURN("Error setting nnodes");
	}
	if (FLDset_node_data_ncomp (out, nmap_comp) != 1) {
		ERR_RETURN("Error setting nnode_data");
	}

	for (comp=0; comp<nmap_comp; comp++) {
		if (FLDget_node_data_units(in, map_comp[comp], 
					   units, MAX_NAME_SIZE) != 1) {
			strcpy(units, "");
		}
		if (FLDget_node_data_label(in, map_comp[comp], 
					   label, MAX_NAME_SIZE) != 1) {
			strcpy(label, "");
		}
		if (FLDget_node_data_veclen(in, map_comp[comp], &veclen) != 1) {
			ERR_RETURN("Error getting veclen");
		}
		if (FLDset_node_data_comp (out, comp, veclen, label, units) != 1) {
			ERR_RETURN("Error setting node component");
		}
		if (FLDcopy_node_minmax(in, out, map_comp[comp], comp) != 1) {
			ERR_RETURN("Error copying node minmax");
		}
		if (FLDcopy_node_minmax_vec(in, out, map_comp[comp], comp) != 1) {
			ERR_RETURN("Error copying node minmax");
		}
		if (FLDget_node_data_id(in, map_comp[comp], &data_id) == 1)
			FLDset_node_data_id(out, comp, data_id);

		if (FLDget_node_data(in, map_comp[comp], &data_type, &node_data, 
				      &size, OM_GET_ARRAY_RD) != 1) {
			ERR_RETURN("cannot get node data");
		}
		if (FLDget_node_null_data(in, map_comp[comp], &null_flag, (char *)&null_value) != 1) {
			ERR_RETURN("cannot get null data");
		}
		if (FLDget_node_data(out, comp, &data_type, &out_node_data, 
				     &size, OM_GET_ARRAY_WR) != 1) {
			ERR_RETURN("Error setting node data");
		}
		if (map_comp[comp] == iso_comp) {
			UTILinit_array(out_node_data, par_nnodes*veclen, iso_val, data_type);
		}
		else {
			stat = UTILeval_param(par_nnodes, veclen, data_type, node_data,
					      null_flag, (char *)&null_value,
					      min_node_list, max_node_list, t, out_node_data);

			if (stat != 1) {
				if (FLDset_node_data_ncomp (out, 0) != 1) {
					ERR_RETURN("Error setting nnode_data");
				}
				ARRfree(node_data);
				ARRfree(out_node_data);
				ARRfree(min_node_list);
				ARRfree(max_node_list);
				ARRfree(t);
				ERR_RETURN("no data mapping performed");
			}
		}
		if (null_flag) {
			if (FLDset_node_null_data(out, comp, (char *)&null_value, data_type) != 1) {
				ERR_RETURN("Error setting null value");
			}
		}
		else {
			if (FLDset_node_null_flag(out, comp, 0) != 1) {
				ERR_RETURN("Error setting null flag");
			}
		}
		if (node_data)
			ARRfree(node_data);
		ARRfree(out_node_data);
	}
	ARRfree(min_node_list);
	ARRfree(max_node_list);
	ARRfree(t);
	return(1);
}
