/*
			Copyright (c) 2000 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/node_minmax.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <stdlib.h>

#include <avs/err.h>
#include <avs/om.h>
#include <avs/fld.h>
#include <avs/data_utils.h>

#define METHOD_SUCCESS 1
#define METHOD_FAILURE 0

#define ERR_RETURN(A) {ERRerror("node_minmax", 0, ERR_ORIG, A); \
                       return METHOD_FAILURE;}

/* 64-bit porting. Only Modified Internally */
int
DV_ARRnode_minmax_update(OMobj_id elem_id, OMevent_mask event_mask, int seq_num)
{
    OMobj_id in_arr_id, in_id, comp_id, min_id, max_id;
    xp_long i, ii, num_fields;
    int stat;
    int nfields_with_node_data = 0, ncomp = 0, comp = 0;
    int node_data_type;
    int bytes_per_node;

    double min, max;  /* large enough to hold any prim type */
    double fmin, fmax;

    int null_flag = 0;
    double null_value = 0.0;

    char * max_all;
    char * min_all;

    in_arr_id  = OMfind_subobj(elem_id,OMstr_to_name("in_field"),OM_OBJ_RD);

    stat = OMget_array_size( in_arr_id, &num_fields );
    if( stat != OM_STAT_SUCCESS ) {
        return METHOD_FAILURE;
    }
    else if( num_fields == 0 ) {
        return METHOD_SUCCESS;
    }

    comp_id = OMfind_subobj(elem_id,OMstr_to_name("component"),OM_OBJ_RD);
    OMget_int_val(comp_id, &comp);

    min_id = OMfind_subobj(elem_id,OMstr_to_name("min"),OM_OBJ_RW);
    max_id = OMfind_subobj(elem_id,OMstr_to_name("max"),OM_OBJ_RW);

    /* How many fields have node data? */

    for( i = 0; i < num_fields; ++i ) {
        stat = OMget_array_val( in_arr_id, i, &in_id, OM_OBJ_RD );
        if( stat != OM_STAT_SUCCESS ) continue;

        stat = FLDget_node_data_ncomp( in_id, &ncomp );
        if( (stat == OM_STAT_SUCCESS) && (ncomp > comp) ) {
            ++nfields_with_node_data;
            if( nfields_with_node_data == 1 )
                FLDget_node_data_type( in_id, comp, &node_data_type );
        }
    }

    /* Need to handle the case where no fields have node data. */
    /* At a minimum, do this ...                               */
    if( nfields_with_node_data == 0 ) return METHOD_SUCCESS;

    bytes_per_node = DTYPEtype_size[node_data_type];

    max_all = malloc( nfields_with_node_data * bytes_per_node );
    min_all = malloc( nfields_with_node_data * bytes_per_node );

    /* Accumulate all the mins and maxs from the fields */

    for( i = 0, ii = 0; i < num_fields; ++i ) {
        stat = OMget_array_val( in_arr_id, i, &in_id, OM_OBJ_RD );
        if( stat != OM_STAT_SUCCESS ) continue;

        stat = FLDget_node_data_ncomp( in_id, &ncomp );
        if( (stat == OM_STAT_SUCCESS) && (ncomp > comp) ) {

            FLDget_node_data_minmax( in_id, comp, (char *)&min, (char *)&max );

            memcpy( &(min_all[ii*bytes_per_node]),
                    (char *)&min,
                    bytes_per_node );

            memcpy( &(max_all[ii*bytes_per_node]),
                    (char *)&max,
                    bytes_per_node );

            ++ii;
        }
    }

    UTILcalc_min( nfields_with_node_data,
                  1, /* veclen  */
                  min_all,
                  node_data_type,
                  null_flag,
                  null_value,
                  &min );

    UTILcalc_max( nfields_with_node_data,
                  1,
                  max_all,
                  node_data_type,
                  null_flag,
                  null_value,
                  &max );

    free( min_all ); min_all = NULL;
    free( max_all ); max_all = NULL;

    UTILtype_to_double( &fmin, &min, node_data_type );
    UTILtype_to_double( &fmax, &max, node_data_type );

    OMset_real_val( min_id, fmin );
    OMset_real_val( max_id, fmax );

    return METHOD_SUCCESS;
}
