/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/rd_vol.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/fld.h>
#include <avs/f_utils.h>

int DPROC_read_vol_file (char *filename, OMobj_id dst);

int DVread_vol_update(OMobj_id elem_id)
{
   OMobj_id filename, out;
   char *str;

   filename = OMfind_subobj(elem_id, OMstr_to_name("filename"), OM_OBJ_RD);
   OMget_str_val(filename, &str, 0);

   out = OMfind_subobj(elem_id, OMstr_to_name("out"), OM_OBJ_RW);

   DPROC_read_vol_file (str, out);

   if (str) FREE(str);

   return(1);
}


/* 64-bit porting. Only Modified Internally */
int DPROC_read_vol_file (char *filename, OMobj_id dst)
{
    FILE *pf;
    unsigned char cx, cy, cz, *node_data;
    xp_long dims[3], size;
    int type;
    float *points;

    /* Attempt to open file */
    if (!(pf = (FILE *)FILEfopen(filename, SIO_R_BIN))) {
	ERRerror("read vol",1,ERR_ORIG,"Error opening file %s", filename);
	fclose(pf);
	return(0);
    }

    /* Read the dimensions */
    if (fread(&cx, sizeof(unsigned char), 1, pf) != 1) {
	ERRerror("read vol",1,ERR_ORIG,"Error reading data from %s", filename);
	fclose(pf);
	return(0);
    }
    if (fread(&cy, sizeof(unsigned char), 1, pf) != 1) {
	ERRerror("read vol",1,ERR_ORIG,"Error reading data from %s", filename);
	fclose(pf);
	return(0);
    }
    if (fread(&cz, sizeof(unsigned char), 1, pf) != 1) {
	ERRerror("read vol",1,ERR_ORIG,"Error reading data from %s", filename);
	fclose(pf);
	return(0);
    }

    /* Set the dimensions */
    dims[0] = cx;
    dims[1] = cy;
    dims[2] = cz;

    FLDset_dims (dst, dims);

    FLDget_points(dst, &points, &size, OM_GET_ARRAY_WR);

    points[0]=points[1]=points[2]=0.0;
    points[3] = (float)cx - 1.0;
    points[4] = (float)cy - 1.0;
    points[5] = (float)cz - 1.0;
    type = OM_TYPE_BYTE;
    FLDget_node_data(dst, 0, &type,
		      (char **)&node_data, &size, OM_GET_ARRAY_WR);

    if (fread(node_data, sizeof(char), size, pf) != size) {
	ERRerror("read vol",1,ERR_ORIG,"Error reading data from %s", filename);
	fclose(pf);
	return(0);
    }
    fclose(pf);
    ARRfree(node_data);
    ARRfree(points);
    return(1);
}
