/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/scat_tet.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/fld.h>
#include <avs/dv_util.h>

#define ERR_RETURN(A) ERRerror("scat_to_tet", 0, ERR_ORIG, A); return(0);
#define MAX_NAME_SIZE 1024

int FUNCscat_to_tet (OMobj_id in, int triangle, OMobj_id out);

int DVscat_to_tet_update(OMobj_id elem_id)
{
	OMobj_id in, out, elm;
	int triangle;

	in = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
	out = OMfind_subobj(elem_id, OMstr_to_name("out_mesh"), OM_OBJ_RW);
	elm = OMfind_subobj(elem_id, OMstr_to_name("triangle"), OM_OBJ_RD);
	OMget_int_val(elm, &triangle);

	if (FUNCscat_to_tet(in, triangle, out)) {
		return(1);
	}
	else return(0);
}

/* 64-bit porting. Only Modified Internally */
int FUNCscat_to_tet (OMobj_id in, int triangle, OMobj_id out)
{
	xp_long nnodes, out_ncells, size;
	int   nspace, cell_nnodes, stat;
	xp_long *out_nlist;
	float  *coord, min_ext[3], max_ext[3];
	OMobj_id   cell_set;
	char   cell_name[20];

	if (FLDset_ncell_sets (out, 0) != 1) {
		ERR_RETURN("Error setting ncell_sets");
	}
	/*--------------------------------------*/
	/*  Make out to be the same as in       */
	/*--------------------------------------*/
	if (FLDget_nnodes(in, &nnodes) != 1) {
		ERR_RETURN("cannot get nnodes");
	}
	if (FLDget_nspace(in, &nspace) != 1) {
		ERR_RETURN("cannot get nspace");
	}
	if (FLDget_coord_extent(in, min_ext, max_ext) != 1) {
		ERR_RETURN("cannot get extents");
	}
	if (FLDget_coord(in, &coord, &size, OM_GET_ARRAY_RD) != 1) {
		ERR_RETURN("cannot get coordinates");
	}
	out_ncells = 0;
	out_nlist = NULL;

	if (FLDset_ncell_sets (out, 0) != 1) {
		ERR_RETURN("Error setting ncell_sets");
	}
	stat = 0;
	if (nspace == 3 && !triangle) {
		stat = UTILdelaun_tess_3D (nnodes, coord, min_ext, max_ext, 0, 
					   &out_ncells, &out_nlist);
		strcpy(cell_name, "Tet");
		cell_nnodes = 4;
		if (out_ncells == 0 && nnodes > 3) {
			ERRerror( "scat_to_tet", 0, ERR_WARNING, 
	"No tetrahedrons found, are the input points coplanar or colinear?" );
		}
	}
	else if (nspace == 2 || nspace == 3 && triangle) {
		stat = UTILdelaun_tess_2D (nnodes, coord, nspace, min_ext, max_ext, 0, 
					   &out_ncells, &out_nlist);
		strcpy(cell_name, "Tri");
		cell_nnodes = 3;
		if (out_ncells == 0 && nnodes > 2) {
			ERRerror( "scat_to_tet", 0, ERR_WARNING, 
	"No triangles found, are the input points colinear?" );
		}
	}
	else
		return(0);

	if (stat != 1) {
		ARRfree(coord);
		ERR_RETURN("triangulation not performed");
	}
	/*** OUTPUT FIELD ***/

	if (stat && out_ncells) {
		if (FLDset_ncell_sets (out, 0) != 1) {
			ERR_RETURN("Error setting ncell_sets");
		}
		if (FLDadd_cell_set(out, cell_name) != 1) {
			ERR_RETURN("Error setting cell type");
		}
		if (FLDget_cell_set(out, 0, &cell_set) != 1) {
			ERR_RETURN("Error getting cell set");
		}
		if (FLDset_ncells(cell_set, out_ncells) != 1) {
			ERR_RETURN("Error setting ncells");
		}
		if (FLDset_node_connect(cell_set, out_nlist, cell_nnodes*out_ncells,
					OM_SET_ARRAY_FREE) != 1) {
			ERR_RETURN("Error setting cell connect list");
		}
	}
	else {
		if (FLDset_ncell_sets (out, 0) != 1) {
			ERR_RETURN("Error setting ncell_sets");
		}
		if (out_nlist != NULL) ARRfree(out_nlist);
	}
	ARRfree(coord);

	return(1);
}
