/*
			Copyright (c) 1993 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/sct_bin.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/dtype.h>
#include <avs/fld.h>
#include <avs/arr.h>
#include <avs/data_utils.h>

#define ERR_RETURN(A) ERRerror("scat_bin", 0, ERR_ORIG, A); return(0);
#define MAX_NAME_SIZE 1024

#define  IJK_TO_INDEX(ndim,dims,ijk,ind) \
{ \
	 int iii;\
	 xp_long ddd; \
	 for (ind=ijk[0],ddd=dims[0],iii=1; iii<ndim; iii++) { \
		 ind += ddd*ijk[iii]; \
		 ddd *= dims[iii]; \
	 } \
}

int FUNCscat_bin (OMobj_id in, int ndim, xp_long *dims, float *min_xyz,
                  float *max_xyz, int in_null_flag, double in_null_value,
                  OMobj_id out);

/* 64-bit porting. Only Modified Internally */
int DVscat_bin_update(OMobj_id elem_id)
{
	OMobj_id in, out,e_id;
	int  stat, ndim, null_flag;
	xp_long dims[3], r_dims[3], min_rng[3], max_rng[3];
	double null_value;
	float min_xyz[3], max_xyz[3];

	in = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
	out = OMfind_subobj(elem_id, OMstr_to_name("out"), OM_OBJ_RW);

	e_id = OMfind_subobj(elem_id, OMstr_to_name("rndim"),
				 OM_OBJ_RW);
	OMget_int_val(e_id, &ndim);

	e_id = OMfind_subobj(elem_id, OMstr_to_name("rdims"),
				 OM_OBJ_RW);
	r_dims[0] = ndim;
	min_rng[0] = 0;
	max_rng[0] = ndim;
	stat = OMget_sub_iarray(e_id, 1, r_dims, min_rng, max_rng,
				(void *)dims);
	if (stat != 1) {
		ERR_RETURN("Error getting dims");
	}

	e_id = OMfind_subobj(elem_id, OMstr_to_name("min_xyz"),
				 OM_OBJ_RW);
	r_dims[0] = ndim;
	min_rng[0] = 0;
	max_rng[0] = ndim;
	stat = OMget_sub_farray(e_id, 1, r_dims, min_rng, max_rng,
				(void *)min_xyz);
	if (stat != 1) {
		ERR_RETURN("Error getting min_xyz");
	}
	e_id = OMfind_subobj(elem_id, OMstr_to_name("max_xyz"),
				 OM_OBJ_RW);
	stat = OMget_sub_farray(e_id, 1, r_dims, min_rng, max_rng,
				(void *)max_xyz);
	if (stat != 1) {
		ERR_RETURN("Error getting max_xyz");
	}

	e_id = OMfind_subobj(elem_id, OMstr_to_name("null_value"),
				 OM_OBJ_RW);
	null_flag = OMget_real_val(e_id, &null_value);

	if (FUNCscat_bin(in, ndim, dims, min_xyz, max_xyz,
			     null_flag, null_value, out))
		return(1);
	else return(0);
}

/* 64-bit porting. Directly Modified */
int FUNCscat_bin (OMobj_id in, int ndim, xp_long *dims, float *min_xyz,
                  float *max_xyz, int in_null_flag, double in_null_value,
                  OMobj_id out)
{
	xp_long nnodes, out_nnodes;
	int   nspace, ncomp, comp, veclen, null_flag, data_id;
	int   i, dtype, rnull_flag, stat, j, max_dim;
	xp_long size, i_w, ind, ijk[3];
	char *node_data, *out_node_data;
	float *xyz, *out_xyz;
	char  label[MAX_NAME_SIZE], units[MAX_NAME_SIZE];
	double null_value, rnull_value,ff;

	if (FLDset_node_data_ncomp (out, 0) != 1) {
		ERR_RETURN("Error setting nnode_data");
	}

	for (i=0; i<ndim; i++) {
		if(dims[i] < 2)
			return(0);
	}
	if (FLDget_nnodes(in, &nnodes) != 1) {
		ERR_RETURN("cannot get nnodes");
	}
	if (FLDget_nspace(in, &nspace) != 1) {
		ERR_RETURN("cannot get nspace");
	}
	if (FLDget_coord(in, &xyz, &size, OM_GET_ARRAY_RD) != 1) {
		ERR_RETURN("cannot get coordinates");
	}
	if (FLDget_points (out, &out_xyz, &size, OM_GET_ARRAY_WR) != 1) {
		ERR_RETURN("Error getting points");
	}
	memcpy(out_xyz, min_xyz, ndim*sizeof(float));
	memcpy(out_xyz+ndim, max_xyz, ndim*sizeof(float));

	if (FLDget_node_data_ncomp (in, &ncomp) != 1) {
		ERR_RETURN("Error getting nnode_data");
	}
	if (FLDset_node_data_ncomp (out, ncomp) != 1) {
		ERR_RETURN("Error setting nnode_data");
	}
	if (FLDget_nnodes(out, &out_nnodes) != 1) {
		ERR_RETURN("cannot get nnodes");
	}
	null_flag = in_null_flag;
	for (comp=0; comp<ncomp; comp++) {
		if (FLDget_node_data_units(in, comp, units, MAX_NAME_SIZE) != 1) {
			strcpy(units, "");
		}
		if (FLDget_node_data_label(in, comp, label, MAX_NAME_SIZE) != 1) {
			strcpy(label, "");
		}
		if (FLDget_node_data_veclen(in, comp, &veclen) != 1) {
			ERR_RETURN("Error getting veclen");
		}
		if (FLDset_node_data_comp (out, comp, veclen, label, units) != 1) {
			ERR_RETURN("Error setting node component");
		}

		if (FLDget_node_data_id(in, comp, &data_id) == 1)
			FLDset_node_data_id(out, comp, data_id);

		if (FLDcopy_node_minmax(in, out, comp, comp) != 1) {
			ERR_RETURN("Error copying node minmax");
		}
		if (FLDcopy_node_minmax_vec(in, out, comp, comp) != 1) {
			ERR_RETURN("Error copying node minmax");
		}

		if (FLDget_node_data(in, comp, &dtype, &node_data,
				      &size, OM_GET_ARRAY_RD) != 1) {
			ERR_RETURN("cannot get node data");
		}
		if (FLDget_node_data(out, comp, &dtype, &out_node_data,
				      &size, OM_GET_ARRAY_WR) != 1) {
			ERR_RETURN("cannot get node data");
		}
		if (FLDget_node_null_data(in, comp, &rnull_flag, (char *)&rnull_value) != 1) {
			ERR_RETURN("cannot get null data");
		}
		if (rnull_flag && !null_flag) {
			UTILtype_to_double(&null_value, (char *)&rnull_value, dtype);
		}
		else if (!rnull_flag && !null_flag) {
			null_value = 0;
		}
		else {
			null_value = in_null_value;
		}
		max_dim = (ndim > nspace) ? nspace : ndim;

		UTILinit_array(out_node_data, veclen*out_nnodes,
					       null_value, dtype);

		size = veclen*DTYPEtype_size[dtype];

		for (i_w=0; i_w<nnodes; i_w++) {
			for (j=0; j<max_dim; j++) {
				ff = (xyz[i_w*nspace+j]-min_xyz[j])/
					(max_xyz[j] - min_xyz[j]);
				ijk[j] = ff*(dims[j]-1)+0.5;
			}

			for (;j<ndim;j++)
				ijk[j]=0;
			for (stat = 1, j=0; j<ndim; j++) {
				if (ijk[j] < 0) {
					stat = 0;
					break;
				}
				if (ijk[j] > dims[j]-1) {
					stat = 0;
					break;
				}
			}
			if (stat == 0)
				continue;
			IJK_TO_INDEX(ndim,dims,ijk,ind);
			memcpy(out_node_data+ind*size, node_data+i_w*size, size);
		}

		UTILdouble_to_type(&in_null_value, null_value, dtype);
		if (FLDset_node_null_data(out, comp, (char *)&in_null_value, dtype) != 1) {
			ERR_RETURN("Error setting null value");
		}

		ARRfree(node_data);
		ARRfree(out_node_data);

	}

	ARRfree(xyz);
	ARRfree(out_xyz);

	return(1);
}
