/*
			Copyright (c) 1994 by
			Advanced Visual Systems Inc.
			All Rights Reserved

	This software comprises unpublished confidential information of
	Advanced Visual Systems Inc. and may not be used, copied or made
	available to anyone, except in accordance with the license
	under which it is furnished.

	This file is under Perforce control
	$Id: //depot/express/fcs70/modules/sel_cell.c#1 $
*/

#define XP_WIDE_API	/* Use Wide APIs */

#include <avs/util.h>
#include <avs/err.h>
#include <avs/om.h>
#include <avs/fld.h>
#include <avs/arr.h>

#define ERR_RETURN(A) ERRerror("select cell sets", 0, ERR_ORIG, A); return(0);

/* 64-bit porting. Only Modified Internally */
int DVselect_cells_update(OMobj_id elem_id)
{
	OMobj_id in, out, sets_id, cell_set;
	int    stat, nsets, nc, cs, type, found, *sets;
	xp_long i, n;

	in = OMfind_subobj(elem_id, OMstr_to_name("in"), OM_OBJ_RD);
	sets_id = OMfind_subobj(elem_id, OMstr_to_name("sets"), OM_OBJ_RD);
	out = OMfind_subobj(elem_id, OMstr_to_name("out_cells"), OM_OBJ_RW);

	type = OM_TYPE_INT;
	n = 0;
	sets = (int *)NULL;
	OMget_array_sz(sets_id, &type, (char **)(&sets), &n, OM_GET_ARRAY_RD);

	sets_id = OMfind_subobj(out, OMstr_to_name("cell_set"), OM_OBJ_RW);
	if (OMis_null_obj(sets_id)) {
		ERR_RETURN("cannot get cell sets");
	}
	OMset_obj_ref(sets_id, OMnull_obj, 0);

	if (FLDget_ncell_sets(in, &nsets) != 1 || nsets == 0) {
		if(sets) ARRfree(sets);
		return(0);
	}

	for (nc=0,cs=0; cs<nsets; cs++) {
		if (FLDget_cell_set(in, cs, &cell_set) != 1) {
			ERR_RETURN("cannot get cell set");
		}
		for (found=0,i=0; i<n; i++) {
			if (sets[i] == cs) {
				found = 1;
				nc++;
				break;
			}
		}
		if (found) {
			stat = OMadd_obj_ref(sets_id, cell_set, 0);
			if (stat != 1) {
				ERR_RETURN("cannot reference cell set");
			}
		}
	}
	if(sets) ARRfree(sets);
	return(1);
}
